/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.amygdalum.testrecorder.runtime.Matches;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsNull;

public class ContainsMatcher<T>
extends TypeSafeMatcher<Collection<? extends T>> {
    private Class<T> type;
    private List<Matcher<T>> elements;

    public ContainsMatcher(Class<T> type) {
        this.type = type;
        this.elements = new ArrayList<Matcher<T>>();
    }

    public ContainsMatcher<T> and(T element) {
        return this.and(this.match(element));
    }

    public ContainsMatcher<T> and(Matcher<T> element) {
        this.elements.add(element);
        return this;
    }

    private Matcher<T> match(T element) {
        if (element == null) {
            return IsNull.nullValue(this.type);
        }
        return IsEqual.equalTo(element);
    }

    public void describeTo(Description description) {
        description.appendText("containing ").appendValueList("[", ", ", "]", this.elements);
    }

    protected void describeMismatchSafely(Collection<? extends T> item, Description mismatchDescription) {
        LinkedList<Matcher<T>> unmatched = new LinkedList<Matcher<T>>(this.elements);
        Matches matches = new Matches();
        ArrayList<T> notExpected = new ArrayList<T>();
        for (T element : item) {
            boolean success = this.tryMatch(unmatched, element);
            if (success) {
                matches.match();
                continue;
            }
            notExpected.add(element);
        }
        if (!notExpected.isEmpty()) {
            matches.mismatch("found " + notExpected.size() + " elements surplus " + this.toDescriptionSet(notExpected));
        }
        if (!unmatched.isEmpty()) {
            matches.mismatch("missing " + unmatched.size() + " elements");
        }
        mismatchDescription.appendText("mismatching elements ").appendDescriptionOf(matches);
    }

    private Set<String> toDescriptionSet(List<T> elements) {
        Matcher<T> matcher = this.bestMatcher();
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (T element : elements) {
            String desc = this.descriptionOf(matcher, element);
            set.add(desc);
        }
        return set;
    }

    private Matcher<T> bestMatcher() {
        for (Matcher<T> matcher : this.elements) {
            if (matcher.getClass() == IsNull.class) continue;
            return matcher;
        }
        return IsEqual.equalTo(null);
    }

    private <S> String descriptionOf(Matcher<S> matcher, S value) {
        StringDescription description = new StringDescription();
        matcher.describeMismatch(value, (Description)description);
        return description.toString();
    }

    protected boolean matchesSafely(Collection<? extends T> item) {
        LinkedList<Matcher<T>> unmatched = new LinkedList<Matcher<T>>(this.elements);
        for (T element : item) {
            boolean success = this.tryMatch(unmatched, element);
            if (success) continue;
            return false;
        }
        return unmatched.isEmpty();
    }

    private boolean tryMatch(List<Matcher<T>> unmatched, T element) {
        Iterator<Matcher<T>> matchers = unmatched.iterator();
        while (matchers.hasNext()) {
            Matcher<T> matcher = matchers.next();
            if (!matcher.matches(element)) continue;
            matchers.remove();
            return true;
        }
        return false;
    }

    public static <T> ContainsMatcher<T> empty(Class<T> type) {
        return new ContainsMatcher<T>(type);
    }

    @SafeVarargs
    public static <T> ContainsMatcher<T> contains(Class<T> key, Object ... elements) {
        ContainsMatcher<T> set = new ContainsMatcher<T>(key);
        for (Object element : elements) {
            if (element instanceof Matcher) {
                set.and((Matcher)element);
                continue;
            }
            set.and(key.cast(element));
        }
        return set;
    }
}

