/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.runtime;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.List;
import net.amygdalum.testrecorder.runtime.GenericComparator;
import net.amygdalum.testrecorder.runtime.GenericComparatorResult;
import net.amygdalum.testrecorder.util.Reflections;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.util.WorkSet;

public class GenericComparison {
    private static final GenericComparison NULL = new GenericComparison("<error>", null, null, null, true);
    private String root;
    private Object left;
    private Object right;
    private Boolean mismatch;
    private List<String> fields;

    public GenericComparison(String root, Object left, Object right) {
        this(root, left, right, null, null);
    }

    public GenericComparison(String root, Object left, Object right, List<String> fields) {
        this(root, left, right, fields, null);
    }

    public GenericComparison(String root, Object left, Object right, List<String> fields, Boolean mismatch) {
        this.root = root;
        this.left = left;
        this.right = right;
        this.fields = fields;
        this.mismatch = mismatch;
    }

    public String getRoot() {
        return this.root;
    }

    public Object getLeft() {
        return this.left;
    }

    public Object getRight() {
        return this.right;
    }

    public void setMismatch(Boolean mismatch) {
        this.mismatch = mismatch;
    }

    public static boolean equals(String root, Object o1, Object o2) {
        return GenericComparison.equals(new GenericComparison(root, o1, o2));
    }

    public static boolean equals(String root, Object o1, Object o2, List<String> fields) {
        return GenericComparison.equals(new GenericComparison(root, o1, o2, fields));
    }

    public static boolean equals(GenericComparison p) {
        WorkSet<GenericComparison> todo = new WorkSet<GenericComparison>();
        todo.add(p);
        return GenericComparison.equals(todo);
    }

    public static boolean equals(WorkSet<GenericComparison> todo) {
        while (todo.hasMoreElements()) {
            GenericComparison current = todo.remove();
            if (current.eval(todo)) continue;
            return false;
        }
        return true;
    }

    public boolean eval(WorkSet<GenericComparison> todo) {
        if (this.left == this.right) {
            return true;
        }
        if (this.left == null || this.right == null) {
            return false;
        }
        if (this.left.getClass() != this.right.getClass()) {
            return false;
        }
        Class<?> clazz = this.left.getClass();
        if (Types.isLiteral(clazz)) {
            return this.left.equals(this.right);
        }
        if (clazz.isArray()) {
            int length = Array.getLength(this.left);
            if (length != Array.getLength(this.right)) {
                return false;
            }
            for (int i = 0; i < length; ++i) {
                todo.add(GenericComparison.from(this.root, i, this.left, this.right));
            }
        }
        for (Field field : Types.allFields(clazz)) {
            String fieldName = field.getName();
            if (this.fields != null && !this.fields.contains(fieldName)) continue;
            todo.add(GenericComparison.from(this.root, fieldName, this.left, this.right));
        }
        return true;
    }

    public boolean eval(GenericComparator comparator, WorkSet<GenericComparison> todo) {
        if (this.left == this.right) {
            return true;
        }
        GenericComparatorResult compare = comparator.compare(this, todo);
        if (compare.isApplying()) {
            return compare.getResult();
        }
        if (this.left == null || this.right == null) {
            return false;
        }
        Class<?> clazz = this.left.getClass();
        if (Types.isLiteral(clazz)) {
            return this.left.equals(this.right);
        }
        if (clazz.isArray()) {
            int length = Array.getLength(this.left);
            if (length != Array.getLength(this.right)) {
                return false;
            }
            for (int i = 0; i < length; ++i) {
                todo.add(GenericComparison.from(this.root, i, this.left, this.right));
            }
        }
        for (Field field : Types.allFields(clazz)) {
            String fieldName = field.getName();
            if (this.fields != null && !this.fields.contains(fieldName)) continue;
            todo.add(GenericComparison.from(this.root, fieldName, this.left, this.right));
        }
        return true;
    }

    public static GenericComparison from(String root, String field, Object left, Object right) {
        try {
            Object f1 = Reflections.getValue(field, left);
            Object f2 = Reflections.getValue(field, right);
            String newRoot = root == null ? field : root + '.' + field;
            return new GenericComparison(newRoot, f1, f2);
        }
        catch (ReflectiveOperationException e) {
            return NULL;
        }
    }

    public static GenericComparison from(String root, Field lfield, Object left, Field rfield, Object right) {
        try {
            Object f1 = Reflections.getValue(lfield, left);
            Object f2 = Reflections.getValue(rfield, right);
            String newRoot = root == null ? lfield.getName() : root + '.' + lfield.getName();
            return new GenericComparison(newRoot, f1, f2);
        }
        catch (ReflectiveOperationException e) {
            return NULL;
        }
    }

    public static GenericComparison from(String root, int index, Object leftArray, Object rightArray) {
        try {
            String suffix = "[" + index + "]";
            String newRoot = root == null ? suffix : root + suffix;
            return new GenericComparison(newRoot, Array.get(leftArray, index), Array.get(rightArray, index));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return NULL;
        }
    }

    public static void compare(WorkSet<GenericComparison> remainder, GenericComparator comparator) {
        while (remainder.hasMoreElements()) {
            GenericComparison current = remainder.remove();
            if (current.eval(comparator, remainder)) continue;
            current.setMismatch(true);
        }
    }

    public boolean isMismatch() {
        return this.mismatch == null ? false : this.mismatch;
    }

    public int hashCode() {
        return 17 + System.identityHashCode(this.left) * 13 + System.identityHashCode(this.right) * 7;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericComparison that = (GenericComparison)obj;
        return this.right == that.right && this.left == that.left;
    }

    public String toString() {
        return this.root + ":" + System.identityHashCode(this.left) + "/" + System.identityHashCode(this.right) + "=" + this.isMismatch();
    }
}

