/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.runtime;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.amygdalum.testrecorder.runtime.GenericComparatorResult;
import net.amygdalum.testrecorder.runtime.GenericComparison;
import net.amygdalum.testrecorder.runtime.GenericObject;
import net.amygdalum.testrecorder.runtime.RecursiveMatcher;
import net.amygdalum.testrecorder.runtime.Wrapped;
import net.amygdalum.testrecorder.util.Reflections;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.util.WorkSet;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeMatcher;

public class GenericMatcher
extends GenericObject {
    public <T> Matcher<T> matching(Class<T> clazz) {
        return new InternalsMatcher<T>(clazz);
    }

    public Matcher<Object> matching(Wrapped wrapped) {
        return new InternalsMatcher(wrapped.getWrappedClass());
    }

    public <T, S> Matcher<S> matching(Class<T> clazz, Class<S> to) {
        return new CastingMatcher<S, T>(to, new InternalsMatcher<T>(clazz));
    }

    public <S> Matcher<S> matching(Wrapped clazz, Class<S> to) {
        return new CastingMatcher(to, (Matcher<?>)new InternalsMatcher(clazz.getWrappedClass()));
    }

    public List<GenericComparison> mismatchesWith(String root, Object o) {
        WorkSet<GenericComparison> remainder = new WorkSet<GenericComparison>();
        for (Field field : this.getGenericFields(o.getClass())) {
            GenericComparison comparison = GenericMatcher.getQualifiedField(o.getClass(), field.getName()).map(qfield -> GenericComparison.from(root, field, this, qfield, o)).orElseGet(() -> GenericComparison.from(root, field.getName(), (Object)this, o));
            remainder.add(comparison);
        }
        GenericComparison.compare(remainder, GenericMatcher::matching);
        return remainder.getDone().stream().filter(done -> done.isMismatch()).collect(Collectors.toList());
    }

    private static GenericComparatorResult matching(GenericComparison comparison, WorkSet<GenericComparison> todo) {
        RecursiveMatcher matcher;
        Object left = comparison.getLeft();
        Object right = comparison.getRight();
        if (left instanceof RecursiveMatcher && right != null) {
            matcher = (RecursiveMatcher)left;
            todo.addAll((Collection<GenericComparison>)matcher.mismatchesWith(comparison.getRoot(), right));
        }
        if (left instanceof Matcher) {
            matcher = (Matcher)left;
            if (matcher.matches(right)) {
                return GenericComparatorResult.MATCH;
            }
            return GenericComparatorResult.MISMATCH;
        }
        return GenericComparatorResult.NOT_APPLYING;
    }

    public static <T> Matcher<T> recursive(Class<T> clazz) {
        return Matchers.instanceOf(clazz);
    }

    public static Matcher<?> recursive(Wrapped wrapped) {
        return Matchers.instanceOf(wrapped.getWrappedClass());
    }

    private class CastingMatcher<S, T>
    extends TypeSafeMatcher<S>
    implements RecursiveMatcher {
        private Class<S> clazz;
        private Matcher<T> matcher;

        public CastingMatcher(Class<S> clazz, Matcher<T> matcher) {
            this.clazz = clazz;
            this.matcher = matcher;
        }

        public void describeTo(Description description) {
            description.appendDescriptionOf(this.matcher);
        }

        @Override
        public List<GenericComparison> mismatchesWith(String root, Object item) {
            return GenericMatcher.this.mismatchesWith(root, item);
        }

        protected boolean matchesSafely(S item) {
            if (!this.clazz.isInstance(item)) {
                return false;
            }
            return this.matcher.matches(item);
        }
    }

    private class InternalsMatcher<T>
    extends TypeSafeMatcher<T>
    implements RecursiveMatcher {
        private Class<T> clazz;

        public InternalsMatcher(Class<T> clazz) {
            this.clazz = clazz;
        }

        public void describeTo(Description description) {
            description.appendText(this.clazz.getName()).appendText(" {");
            for (Field field : Types.allFields(this.clazz)) {
                this.describeField(description, field, GenericMatcher.this);
            }
            description.appendText("\n}");
        }

        @Override
        public List<GenericComparison> mismatchesWith(String root, Object item) {
            return GenericMatcher.this.mismatchesWith(root, item);
        }

        protected boolean matchesSafely(T item) {
            Class<?> itemClass = item.getClass();
            if (this.isSynthetic(itemClass) ? !this.clazz.isAssignableFrom(itemClass) : this.clazz != itemClass) {
                return false;
            }
            List<GenericComparison> mismatches = this.mismatchesWith(null, item);
            return mismatches.isEmpty();
        }

        private boolean isSynthetic(Class<?> itemClass) {
            return itemClass.isSynthetic() || itemClass.getSimpleName().contains("$");
        }

        protected void describeMismatchSafely(T item, Description mismatchDescription) {
            List<GenericComparison> mismatches = this.mismatchesWith(null, item);
            if (!mismatches.isEmpty()) {
                mismatchDescription.appendText(item.getClass().getName()).appendText(" {");
                for (Field field : Types.allFields(item.getClass())) {
                    this.describeField(mismatchDescription, field, item);
                }
                mismatchDescription.appendText("\n}");
                mismatchDescription.appendText("\nfound mismatches at:");
                for (GenericComparison mismatch : mismatches) {
                    if (mismatch.getLeft() instanceof RecursiveMatcher) continue;
                    this.describeMismatch(mismatchDescription, mismatch);
                }
            }
        }

        private void describeField(Description description, Field field, Object object) {
            try {
                description.appendText("\n\t").appendText(field.getType().getSimpleName()).appendText(" ").appendText(field.getName()).appendText(": ");
                Object value = Reflections.getValue(field.getName(), object);
                this.describe(description, value);
                description.appendText(";");
            }
            catch (ReflectiveOperationException e) {
                description.appendText("\n\t").appendValue(field.getType()).appendText(" ").appendValue((Object)field.getName()).appendText(":<description failed>");
            }
        }

        private void describeMismatch(Description description, GenericComparison mismatch) {
            description.appendText("\n\t").appendText(mismatch.getRoot()).appendText(": ");
            this.describe(description, mismatch.getLeft());
            description.appendText(" != ");
            this.describe(description, mismatch.getRight());
        }

        private void describe(Description description, Object value) {
            if (value instanceof SelfDescribing) {
                description.appendDescriptionOf((SelfDescribing)value);
            } else {
                description.appendValue(value);
            }
        }
    }
}

