/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.runtime;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsNull;

public class MapMatcher<K, V>
extends TypeSafeMatcher<Map<K, V>> {
    private Class<K> key;
    private Class<V> value;
    private Map<Matcher<K>, Matcher<V>> entries;

    public MapMatcher(Class<K> key, Class<V> value) {
        this.key = key;
        this.value = value;
        this.entries = new LinkedHashMap<Matcher<K>, Matcher<V>>();
    }

    public MapMatcher<K, V> entry(K key, V value) {
        return this.entry(this.matchKey(key), this.matchValue(value));
    }

    public MapMatcher<K, V> entry(Matcher<?> key, V value) {
        return this.entry(key, this.matchValue(value));
    }

    public MapMatcher<K, V> entry(K key, Matcher<?> value) {
        return this.entry(this.matchKey(key), value);
    }

    public MapMatcher<K, V> entry(Matcher<?> key, Matcher<?> value) {
        this.entries.put(key, value);
        return this;
    }

    private Matcher<K> matchKey(K element) {
        if (element == null) {
            return IsNull.nullValue(this.key);
        }
        if (element instanceof Matcher) {
            return (Matcher)element;
        }
        return IsEqual.equalTo(element);
    }

    private Matcher<V> matchValue(V element) {
        if (element == null) {
            return IsNull.nullValue(this.value);
        }
        if (element instanceof Matcher) {
            return (Matcher)element;
        }
        return IsEqual.equalTo(element);
    }

    public void describeTo(Description description) {
        description.appendText("containing ").appendValueList("{", ", ", "}", this.entries.entrySet());
    }

    protected void describeMismatchSafely(Map<K, V> item, Description mismatchDescription) {
        LinkedList<Map.Entry<Matcher<K>, Matcher<V>>> unmatched = new LinkedList<Map.Entry<Matcher<K>, Matcher<V>>>(this.entries.entrySet());
        LinkedList<Map.Entry<K, V>> notfound = new LinkedList<Map.Entry<K, V>>();
        for (Map.Entry<K, V> entry : item.entrySet()) {
            boolean success = this.tryMatch(unmatched, entry);
            if (success) continue;
            notfound.add(new AbstractMap.SimpleEntry<K, V>(entry.getKey(), entry.getValue()));
        }
        if (!unmatched.isEmpty()) {
            mismatchDescription.appendText("missing entries ").appendValueList("{", ", ", "}", unmatched);
        }
        if (!unmatched.isEmpty() && !notfound.isEmpty()) {
            mismatchDescription.appendText(", ");
        }
        if (!notfound.isEmpty()) {
            mismatchDescription.appendText("unmatched entries ").appendValueList("{", ", ", "}", this.toDescriptionMap(notfound));
        }
    }

    private Collection<Map.Entry<String, String>> toDescriptionMap(List<Map.Entry<K, V>> entries) {
        Matcher<K> keyMatcher = this.bestKeyMatcher();
        Matcher<V> valueMatcher = this.bestValueMatcher();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (Map.Entry<K, V> entry : entries) {
            String key = this.descriptionOf(keyMatcher, entry.getKey());
            String value = this.descriptionOf(valueMatcher, entry.getValue());
            map.put(key, value);
        }
        return map.entrySet();
    }

    private Matcher<V> bestValueMatcher() {
        for (Matcher<V> matcher : this.entries.values()) {
            if (matcher.getClass() == IsNull.class) continue;
            return matcher;
        }
        return IsEqual.equalTo(null);
    }

    private Matcher<K> bestKeyMatcher() {
        for (Matcher<K> matcher : this.entries.keySet()) {
            if (matcher.getClass() == IsNull.class) continue;
            return matcher;
        }
        return IsEqual.equalTo(null);
    }

    private <T> String descriptionOf(Matcher<T> valueMatcher, T value) {
        StringDescription description = new StringDescription();
        valueMatcher.describeMismatch(value, (Description)description);
        return description.toString();
    }

    protected boolean matchesSafely(Map<K, V> item) {
        LinkedList<Map.Entry<Matcher<K>, Matcher<V>>> unmatched = new LinkedList<Map.Entry<Matcher<K>, Matcher<V>>>(this.entries.entrySet());
        for (Map.Entry<K, V> entry : item.entrySet()) {
            boolean success = this.tryMatch(unmatched, entry);
            if (success) continue;
            return false;
        }
        return unmatched.isEmpty();
    }

    private boolean tryMatch(List<Map.Entry<Matcher<K>, Matcher<V>>> unmatched, Map.Entry<K, V> entry) {
        K key = entry.getKey();
        V value = entry.getValue();
        Iterator<Map.Entry<Matcher<K>, Matcher<V>>> matchers = unmatched.iterator();
        while (matchers.hasNext()) {
            Map.Entry<Matcher<K>, Matcher<V>> matcher = matchers.next();
            if (!matcher.getKey().matches(key) || !matcher.getValue().matches(value)) continue;
            matchers.remove();
            return true;
        }
        return false;
    }

    public static <K, V> MapMatcher<K, V> noEntries(Class<K> key, Class<V> value) {
        return new MapMatcher<K, V>(key, value);
    }

    public static <K, V> MapMatcher<K, V> containsEntries(Class<K> key, Class<V> value) {
        return new MapMatcher<K, V>(key, value);
    }
}

