/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.runtime;

import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;

public class Matches<T>
implements SelfDescribing {
    private Deque<Matching<T>> matches = new LinkedList<Matching<T>>();
    private boolean mismatches = false;

    public Matches<T> mismatch(Matcher<T> matcher, Object element) {
        this.matches.add(new Mismatch<T>(matcher, element));
        this.mismatches = true;
        return this;
    }

    public Matches<T> mismatch(String description) {
        this.matches.add(new MismatchDescription(description));
        this.mismatches = true;
        return this;
    }

    public Matches<T> match() {
        Matching<T> peek = this.matches.peek();
        if (peek instanceof Match) {
            ((Match)peek).inc();
        } else {
            this.matches.add(new Match());
        }
        return this;
    }

    public boolean containsMismatches() {
        return this.mismatches;
    }

    public void describeTo(Description description) {
        description.appendText("<[");
        Iterator<Matching<T>> matchIterator = this.matches.iterator();
        if (matchIterator.hasNext()) {
            description.appendDescriptionOf((SelfDescribing)matchIterator.next());
        }
        while (matchIterator.hasNext()) {
            description.appendText(", ");
            description.appendDescriptionOf((SelfDescribing)matchIterator.next());
        }
        description.appendText("]>");
    }

    private static class Mismatch<T>
    extends Matching<T> {
        private Matcher<T> matcher;
        private Object element;

        public Mismatch(Matcher<T> matcher, Object element) {
            this.matcher = matcher;
            this.element = element;
        }

        public void describeTo(Description description) {
            this.matcher.describeMismatch(this.element, description);
        }
    }

    private static class MismatchDescription<T>
    extends Matching<T> {
        private String description;

        public MismatchDescription(String description) {
            this.description = description;
        }

        public void describeTo(Description description) {
            description.appendText(this.description);
        }
    }

    private static class Match<T>
    extends Matching<T> {
        private int count = 1;

        public void inc() {
            ++this.count;
        }

        public void describeTo(Description description) {
            char[] text = new char[this.count];
            Arrays.fill(text, '.');
            description.appendText(new String(text));
        }
    }

    private static abstract class Matching<T>
    implements SelfDescribing {
        private Matching() {
        }
    }
}

