/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.runtime;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import net.amygdalum.testrecorder.runtime.GenericObject;
import net.amygdalum.testrecorder.runtime.ValueFactory;
import net.amygdalum.testrecorder.util.Types;

public class NonDefaultValue
extends ValueFactory {
    public static final NonDefaultValue INSTANCE = new NonDefaultValue();
    private static final Object PLACEHOLDER = new Object();
    private Map<Class<?>, Object> cache = new HashMap();

    public static Object of(Class<?> clazz) {
        return INSTANCE.newValue(clazz);
    }

    @Override
    public String getDescription(Class<?> clazz) {
        if (clazz.isArray()) {
            return "new " + clazz.getComponentType().getSimpleName() + "[1]";
        }
        if (clazz.isInterface()) {
            return "proxy " + clazz.getSimpleName() + "()";
        }
        if (!Types.isLiteral(clazz) && !clazz.isEnum()) {
            return "new " + clazz.getSimpleName() + "()";
        }
        return super.getDescription(clazz);
    }

    @Override
    public Object newValue(Class<?> clazz) {
        if (clazz == Boolean.TYPE) {
            return true;
        }
        if (clazz == Character.TYPE) {
            return Character.valueOf('\u0001');
        }
        if (clazz == Byte.TYPE) {
            return (byte)1;
        }
        if (clazz == Short.TYPE) {
            return (short)1;
        }
        if (clazz == Integer.TYPE) {
            return 1;
        }
        if (clazz == Float.TYPE) {
            return Float.valueOf(1.0f);
        }
        if (clazz == Long.TYPE) {
            return 1L;
        }
        if (clazz == Double.TYPE) {
            return 1.0;
        }
        if (clazz == String.class) {
            return clazz.getSimpleName();
        }
        Object object = this.cache.get(clazz);
        if (object == PLACEHOLDER) {
            throw new IllegalArgumentException("cancelling because of potentially recursive object graph");
        }
        if (object == null) {
            this.cache.put(clazz, PLACEHOLDER);
            object = this.newReferenceValue(clazz);
            this.cache.put(clazz, object);
        }
        return object;
    }

    private Object newReferenceValue(Class<?> clazz) {
        if (clazz.isArray()) {
            return Array.newInstance(clazz.getComponentType(), 1);
        }
        if (clazz.isInterface()) {
            return GenericObject.newProxy(clazz);
        }
        if (clazz.isEnum()) {
            return GenericObject.newEnum(clazz);
        }
        return GenericObject.newInstance(clazz);
    }
}

