/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.runtime;

import java.util.ArrayList;
import java.util.stream.Collectors;
import net.amygdalum.testrecorder.runtime.ValueFactory;

public class Params {
    public static final Params NONE = new Params(new Class[0], ValueFactory.NONE);
    private Class<?>[] classes;
    private ValueFactory factory;

    public Params(Class<?>[] classes, ValueFactory factory) {
        this.classes = classes;
        this.factory = factory;
    }

    public Class<?>[] getClasses() {
        return this.classes;
    }

    public Object[] values() {
        ArrayList<Object> params = new ArrayList<Object>();
        for (Class<?> clazz : this.getClasses()) {
            Object value = this.factory.newValue(clazz);
            params.add(value);
        }
        return params.toArray(new Object[0]);
    }

    public String getDescription() {
        ArrayList<String> params = new ArrayList<String>();
        for (Class<?> clazz : this.getClasses()) {
            params.add(this.factory.getDescription(clazz));
        }
        return params.stream().collect(Collectors.joining(", ", "(", ")"));
    }
}

