/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.tools.JavaFileObject;
import net.amygdalum.testrecorder.util.RedefiningClassLoader;

public class ExtensibleClassLoader
extends URLClassLoader
implements RedefiningClassLoader {
    protected Set<String> packages;
    private Map<String, byte[]> resources;

    public ExtensibleClassLoader(ClassLoader loader, String ... packages) {
        super(ExtensibleClassLoader.extractUrls(loader), ExtensibleClassLoader.unwrap(loader));
        this.packages = new HashSet<String>(Arrays.asList(packages));
        this.resources = new LinkedHashMap<String, byte[]>();
    }

    private static URL[] extractUrls(ClassLoader loader) {
        LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
        while (loader != null) {
            if (loader instanceof URLClassLoader) {
                for (URL url : ((URLClassLoader)loader).getURLs()) {
                    urls.add(url);
                }
            }
            loader = loader.getParent();
        }
        return urls.toArray(new URL[0]);
    }

    private static ClassLoader unwrap(ClassLoader loader) {
        if (loader instanceof RedefiningClassLoader) {
            return loader.getParent();
        }
        return loader;
    }

    public void addPackage(String pkg) {
        this.packages.add(pkg);
    }

    protected boolean shouldBeRedefined(String name) {
        for (String pkg : this.packages) {
            if (!name.startsWith(pkg)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isRedefined(String name) {
        String resource = this.classToResource(name);
        return this.resources.containsKey(resource);
    }

    @Override
    public Class<?> define(String name, byte[] bytes) {
        String resource = this.classToResource(name);
        this.resources.put(resource, bytes);
        return this.defineClass(name, bytes, 0, bytes.length);
    }

    public void defineResource(String resource, byte[] content) {
        this.resources.put(resource, content);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        String resource = this.classToResource(name);
        if (this.resources.containsKey(resource) || this.resources.containsKey(this.enclosingClassName(resource))) {
            return this.findRedefinedClass(name);
        }
        if (this.shouldBeRedefined(name)) {
            return this.redefineClass(name);
        }
        return super.loadClass(name);
    }

    private String enclosingClassName(String name) {
        int specialIndicator = name.indexOf(36);
        if (specialIndicator < 0) {
            return name;
        }
        return name.substring(0, specialIndicator);
    }

    public Class<?> findRedefinedClass(String name) throws ClassNotFoundException {
        Class<?> find = this.findLoadedClass(name);
        if (find != null) {
            return find;
        }
        return this.findClass(name);
    }

    public Class<?> redefineClass(String name) throws ClassNotFoundException {
        try {
            byte[] bytes = this.getBytesForClass(name);
            return this.define(name, bytes);
        }
        catch (Throwable t) {
            throw new ClassNotFoundException(t.getMessage(), t);
        }
    }

    private byte[] getBytesForClass(String name) throws IOException {
        int bytesRead;
        InputStream input = ClassLoader.getSystemResourceAsStream(name.replace('.', '/') + ".class");
        byte[] buffer = new byte[8192];
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        while ((bytesRead = input.read(buffer)) != -1) {
            output.write(buffer, 0, bytesRead);
        }
        return output.toByteArray();
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        byte[] bytes = this.resources.get(name);
        if (bytes != null) {
            return new ByteArrayInputStream(bytes);
        }
        return super.getResourceAsStream(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if (this.resources.containsKey(name)) {
            int lastDot = name.lastIndexOf(46);
            String fileName = name.substring(lastDot + 1);
            Path file = Files.createTempFile(fileName, "", new FileAttribute[0]);
            Files.write(file, this.resources.get(name), new OpenOption[0]);
            URL url = file.toUri().toURL();
            return Collections.enumeration(Arrays.asList(url));
        }
        return super.getResources(name);
    }

    private String classToResource(String name) {
        return name.replace('.', '/') + JavaFileObject.Kind.CLASS.extension;
    }
}

