/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class FileSerializer {
    private FileSerializer() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String store(String dir, Object object) throws IOException {
        try {
            byte[] data = FileSerializer.serialize(object);
            String string = FileSerializer.digest(data);
            Path path = Paths.get(dir, string + ".serialized");
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            try (OutputStream o = Files.newOutputStream(path, StandardOpenOption.SYNC, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
                o.write(data);
                o.flush();
                String string2 = path.getFileName().toString();
                return string2;
            }
        }
        catch (IOException | NullPointerException e) {
            throw new IOException("failed writing object to file", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("failed hashing data to produce unique file name", e);
        }
    }

    private static byte[] serialize(Object object) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (ObjectOutputStream o = new ObjectOutputStream(out);){
            o.writeObject(object);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    private static String digest(byte[] data) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        byte[] mdbytes = md.digest(data);
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < mdbytes.length; ++i) {
            buffer.append(Integer.toString((mdbytes[i] & 0xFF) + 256, 16).substring(1));
        }
        return buffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T load(String dir, String fileName, Class<T> type) {
        try (ObjectInputStream in = new ObjectInputStream(Files.newInputStream(Paths.get(dir, fileName), StandardOpenOption.READ));){
            T object;
            Object rawObject = in.readObject();
            T t = object = type.cast(rawObject);
            return t;
        }
        catch (IOException | ClassCastException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

