/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.util;

public final class Literals {
    private Literals() {
    }

    public static String asLiteral(Character c) {
        StringBuilder buffer = new StringBuilder();
        buffer.append('\'');
        if (c.charValue() == '\n') {
            buffer.append("\\n");
        } else if (c.charValue() == '\r') {
            buffer.append("\\r");
        } else if (c.charValue() == '\\') {
            buffer.append("\\\\");
        } else if (c.charValue() == '\'') {
            buffer.append("\\'");
        } else if (c.charValue() < ' ' || c.charValue() >= '\u007f') {
            buffer.append("\\u");
            if (c.charValue() < '\u0010') {
                buffer.append("000");
            } else if (c.charValue() < '\u0100') {
                buffer.append("00");
            } else if (c.charValue() < '\u1000') {
                buffer.append('0');
            }
            buffer.append(Integer.toString(c.charValue(), 16));
        } else {
            buffer.append(c);
        }
        buffer.append('\'');
        return buffer.toString();
    }

    public static String asLiteral(String rawString) {
        if (rawString == null) {
            return "null";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append('\"');
        for (int i = 0; i < rawString.length(); ++i) {
            char c = rawString.charAt(i);
            if (c == '\n') {
                buffer.append("\\n");
                continue;
            }
            if (c == '\r') {
                buffer.append("\\r");
                continue;
            }
            if (c == '\\') {
                buffer.append("\\\\");
                continue;
            }
            if (c == '\"') {
                buffer.append("\\\"");
                continue;
            }
            if (c < ' ' || c >= '\u007f') {
                buffer.append("\\u");
                if (c < '\u0010') {
                    buffer.append("000");
                } else if (c < '\u0100') {
                    buffer.append("00");
                } else if (c < '\u1000') {
                    buffer.append('0');
                }
                buffer.append(Integer.toString(c, 16));
                continue;
            }
            buffer.append(c);
        }
        buffer.append('\"');
        return buffer.toString();
    }

    public static String asLiteral(Float f) {
        if (f.isNaN()) {
            return "Float.NaN";
        }
        if (f.floatValue() == Float.POSITIVE_INFINITY) {
            return "Float.POSITIVE_INFINITY";
        }
        if (f.floatValue() == Float.NEGATIVE_INFINITY) {
            return "Float.NEGATIVE_INFINITY";
        }
        return f.toString() + "f";
    }

    public static String asLiteral(Double d) {
        if (d.isNaN()) {
            return "Double.NaN";
        }
        if (d == Double.POSITIVE_INFINITY) {
            return "Double.POSITIVE_INFINITY";
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return "Double.NEGATIVE_INFINITY";
        }
        return d.toString();
    }

    public static String asLiteral(Object value) {
        if (value instanceof String) {
            return Literals.asLiteral((String)value);
        }
        if (value instanceof Character) {
            return Literals.asLiteral((Character)value);
        }
        if (value instanceof Byte) {
            return "(byte) " + value.toString();
        }
        if (value instanceof Short) {
            return "(short) " + value.toString();
        }
        if (value instanceof Integer) {
            return value.toString();
        }
        if (value instanceof Float) {
            return Literals.asLiteral((Float)value);
        }
        if (value instanceof Long) {
            return value.toString() + "l";
        }
        if (value instanceof Double) {
            return Literals.asLiteral((Double)value);
        }
        if (value == null) {
            return "null";
        }
        return value.toString();
    }

    public static String classOf(String name) {
        return name + ".class";
    }
}

