/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import net.amygdalum.testrecorder.util.Types;

public final class Reflections {
    private static final String MODIFIERS = "modifiers";

    private Reflections() {
    }

    public static <T extends AccessibleObject> Accessing<T> accessing(T o) {
        return new Accessing<T>(o);
    }

    public static Object getValue(String fieldName, Object item) throws ReflectiveOperationException {
        Field field = Types.getDeclaredField(item.getClass(), fieldName);
        return Reflections.getValue(field, item);
    }

    public static Object getValue(Field field, Object item) throws ReflectiveOperationException {
        return Reflections.accessing(field).call(f -> f.get(item));
    }

    public static interface AccessConsumer<T> {
        public void accept(T var1) throws ReflectiveOperationException;
    }

    public static interface AccessFunction<T, S> {
        public S apply(T var1) throws ReflectiveOperationException;
    }

    public static class Accessing<T extends AccessibleObject> {
        private T object;

        public Accessing(T object) {
            this.object = object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <S> S call(AccessFunction<T, S> code) throws ReflectiveOperationException {
            boolean reset = this.ensureAccess();
            try {
                S result;
                S s = result = code.apply(this.object);
                return s;
            }
            finally {
                this.resetAccess(reset);
            }
        }

        public void exec(AccessConsumer<T> code) throws ReflectiveOperationException {
            boolean reset = this.ensureAccess();
            try {
                code.accept(this.object);
            }
            finally {
                this.resetAccess(reset);
            }
        }

        private boolean ensureAccess() throws ReflectiveOperationException {
            int modifiers = ((Member)this.object).getModifiers();
            if (Modifier.isFinal(modifiers) && this.object instanceof Field) {
                this.makeNonFinal((Field)this.object);
            }
            if (Modifier.isPublic(modifiers) && Modifier.isPublic(((Member)this.object).getDeclaringClass().getModifiers())) {
                return false;
            }
            if (!((AccessibleObject)this.object).isAccessible()) {
                ((AccessibleObject)this.object).setAccessible(true);
                return true;
            }
            return false;
        }

        private void makeNonFinal(Field field) throws ReflectiveOperationException {
            Field modifiersField = Field.class.getDeclaredField(Reflections.MODIFIERS);
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        }

        private void resetAccess(boolean reset) {
            if (reset) {
                ((AccessibleObject)this.object).setAccessible(false);
            }
        }
    }
}

