/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.util;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.amygdalum.testrecorder.util.WorkSet;

public final class Types {
    private static final String SYNTHETIC_INDICATOR = "$";
    private static final String[] HANDLED_SYNTHETIC_PREFIXES = new String[]{"this$"};

    private Types() {
    }

    public static Type visibleType(Object element, Type componentType) {
        if (element != null) {
            for (Class<?> current = element.getClass(); current != Object.class; current = current.getSuperclass()) {
                if (Types.isHidden(current, null)) continue;
                return current;
            }
        }
        return componentType;
    }

    public static Type inferType(Type ... types) {
        Optional<Class> inferred = Arrays.stream(types).map(type -> Types.superTypes(Types.baseType(type))).reduce((s1, s2) -> Types.intersectClasses(s1, s2)).map(s -> Types.bestClass(s));
        return (Type)((Object)inferred.orElse(Object.class));
    }

    public static Optional<Type> mostSpecialOf(Type ... types) {
        return Arrays.stream(types).sorted(Types::byMostConcreteGeneric).findFirst();
    }

    private static Set<Class<?>> superTypes(Class<?> clazz) {
        WorkSet todo = new WorkSet();
        todo.add(clazz);
        while (!todo.isEmpty()) {
            Class next = (Class)todo.remove();
            if (next == Object.class) continue;
            Class superclass = next.getSuperclass();
            if (superclass != null) {
                todo.add(superclass);
            }
            for (Class<?> nextInterface : next.getInterfaces()) {
                todo.add(nextInterface);
            }
        }
        return todo.getDone();
    }

    private static Set<Class<?>> intersectClasses(Set<Class<?>> s1, Set<Class<?>> s2) {
        TreeSet result = new TreeSet(new Comparator<Class<?>>(){

            @Override
            public int compare(Class<?> o1, Class<?> o2) {
                if (o1.isAssignableFrom(o2)) {
                    return -1;
                }
                if (o2.isAssignableFrom(o1)) {
                    return 1;
                }
                int m1 = o1.getMethods().length;
                int m2 = o2.getMethods().length;
                if (m2 > m1) {
                    return 1;
                }
                if (m1 > m2) {
                    return -1;
                }
                return System.identityHashCode(o1) - System.identityHashCode(o2);
            }
        });
        result.addAll(s1);
        result.retainAll(s2);
        return result;
    }

    private static Class<?> bestClass(Set<Class<?>> classes) {
        Class<?> bestInterface = null;
        Class bestClass = Object.class;
        for (Class<?> clazz : classes) {
            if (clazz.isInterface()) {
                if (bestInterface == null) {
                    bestInterface = clazz;
                    continue;
                }
                if (!bestInterface.isAssignableFrom(clazz)) continue;
                bestInterface = clazz;
                continue;
            }
            if (!bestClass.isAssignableFrom(clazz)) continue;
            bestClass = clazz;
        }
        if (Types.isBoxedPrimitive(bestClass) || bestClass == String.class) {
            return bestClass;
        }
        if (bestInterface != null) {
            return bestInterface;
        }
        return bestClass;
    }

    public static Type resolve(Type type, Class<?> context) {
        Map<TypeVariable<?>, Type> freeVariables = Types.computeTypeVariableResolutions(type, context);
        return Types.updateTypes(type, freeVariables);
    }

    private static Type updateTypes(Type type, Map<TypeVariable<?>, Type> resolved) {
        if (resolved.isEmpty()) {
            return type;
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            Type resolvedType = Types.updateTypes(componentType, resolved);
            if (resolvedType != componentType) {
                return Types.array(resolvedType);
            }
        } else if (type instanceof ParameterizedType) {
            Object[] actualTypeArguments = ((ParameterizedType)type).getActualTypeArguments();
            Type ownerType = ((ParameterizedType)type).getOwnerType();
            Type rawType = ((ParameterizedType)type).getRawType();
            Object[] resolvedTypeArguments = (Type[])Arrays.stream(actualTypeArguments).map(typeArgument -> Types.updateTypes(typeArgument, resolved)).toArray(Type[]::new);
            if (!Arrays.equals(resolvedTypeArguments, actualTypeArguments)) {
                return Types.parameterized(rawType, ownerType, (Type[])resolvedTypeArguments);
            }
        } else if (type instanceof TypeVariable) {
            Type resolvedType = resolved.get(type);
            if (resolvedType != null) {
                return resolvedType;
            }
        } else if (type instanceof WildcardType) {
            Object[] resolvedUpperBounds;
            Object[] upperBounds = ((WildcardType)type).getUpperBounds();
            Object[] lowerBounds = ((WildcardType)type).getLowerBounds();
            if (lowerBounds.length > 0) {
                Object[] resolvedLowerBounds = (Type[])Arrays.stream(lowerBounds).map(bound -> Types.updateTypes(bound, resolved)).toArray(Type[]::new);
                if (!Arrays.equals(resolvedLowerBounds, lowerBounds)) {
                    return Types.wildcardSuper((Type[])resolvedLowerBounds);
                }
            } else if (upperBounds.length > 0 && upperBounds[0] != Object.class && !Arrays.equals(resolvedUpperBounds = (Type[])Arrays.stream(upperBounds).map(bound -> Types.updateTypes(bound, resolved)).toArray(Type[]::new), upperBounds)) {
                return Types.wildcardExtends((Type[])resolvedUpperBounds);
            }
            return type;
        }
        return type;
    }

    private static Map<TypeVariable<?>, Type> computeTypeVariableResolutions(Type type, Class<?> context) {
        Map<TypeVariable<?>, Type> typeVariables = Types.computeFreeTypeVariables(type);
        Set<ParameterizedType> typeVariableDefinitions = Types.computeTypeVariableDefinitions(context);
        HashMap next = new HashMap(typeVariables);
        while (!next.isEmpty()) {
            Iterator nexts = next.entrySet().iterator();
            while (nexts.hasNext()) {
                Type resolved;
                Map.Entry entry2 = nexts.next();
                TypeVariable key = (TypeVariable)entry2.getKey();
                Type value = (Type)entry2.getValue();
                if (value instanceof TypeVariable && value != (resolved = Types.resolve((TypeVariable)value, typeVariableDefinitions))) {
                    entry2.setValue(resolved);
                    typeVariables.put(key, resolved);
                    continue;
                }
                nexts.remove();
            }
        }
        typeVariables.entrySet().removeIf(entry -> entry.getValue() instanceof TypeVariable);
        return typeVariables;
    }

    private static Type resolve(TypeVariable<? extends GenericDeclaration> value, Set<ParameterizedType> types) {
        GenericDeclaration genericDeclaration = value.getGenericDeclaration();
        if (genericDeclaration instanceof Class) {
            Class clazz = (Class)genericDeclaration;
            Optional<ParameterizedType> matching = types.stream().filter(type -> type.getRawType() == clazz).sorted(Types::byMostConcrete).findFirst();
            if (matching.isPresent()) {
                TypeVariable<?>[] params = genericDeclaration.getTypeParameters();
                Type[] actual = matching.get().getActualTypeArguments();
                for (int i = 0; i < params.length && i < actual.length; ++i) {
                    if (params[i] != value) continue;
                    return actual[i];
                }
            }
        }
        return value;
    }

    public static int byMostConcrete(Type type1, Type type2) {
        if (type1 == type2) {
            return 0;
        }
        if (type1 instanceof Class && type2 instanceof Class) {
            Class clazz1 = (Class)type1;
            Class clazz2 = (Class)type2;
            if (clazz1.isAssignableFrom(clazz2)) {
                return 1;
            }
            if (clazz2.isAssignableFrom(clazz1)) {
                return -1;
            }
            return 0;
        }
        if (type1 instanceof Class) {
            return -1;
        }
        if (type2 instanceof Class) {
            return 1;
        }
        return Types.byMostConcrete(Types.baseType(type1), Types.baseType(type2));
    }

    public static int byMostConcreteGeneric(Type type1, Type type2) {
        Type[] typeArguments2;
        Type[] typeArguments1;
        if (type1 == type2) {
            return 0;
        }
        if (type1 instanceof Class && type2 instanceof Class) {
            Class clazz1 = (Class)type1;
            Class clazz2 = (Class)type2;
            if (clazz1.isAssignableFrom(clazz2)) {
                return 1;
            }
            if (clazz2.isAssignableFrom(clazz1)) {
                return -1;
            }
            return 0;
        }
        int compare = Types.byMostConcrete(Types.baseType(type1), Types.baseType(type2));
        if (compare == 0 && type1 instanceof ParameterizedType && type2 instanceof ParameterizedType && (compare = Integer.compare((typeArguments1 = ((ParameterizedType)type1).getActualTypeArguments()).length, (typeArguments2 = ((ParameterizedType)type2).getActualTypeArguments()).length)) == 0) {
            for (int i = 0; i < typeArguments1.length && i < typeArguments2.length; ++i) {
                compare += Types.byMostConcrete(typeArguments1[i], typeArguments2[i]);
            }
        }
        return compare;
    }

    private static Map<TypeVariable<?>, Type> computeFreeTypeVariables(Type type) {
        HashMap unresolvedVariables;
        block4: {
            Map<TypeVariable<?>, Type> typeBoundVariables;
            block6: {
                block5: {
                    block3: {
                        unresolvedVariables = new HashMap();
                        if (!(type instanceof GenericArrayType)) break block3;
                        Type componentType = ((GenericArrayType)type).getGenericComponentType();
                        Map<TypeVariable<?>, Type> componentTypeVariables = Types.computeFreeTypeVariables(componentType);
                        unresolvedVariables.putAll(componentTypeVariables);
                        break block4;
                    }
                    if (!(type instanceof ParameterizedType)) break block5;
                    for (Type typeArgument : ((ParameterizedType)type).getActualTypeArguments()) {
                        Map<TypeVariable<?>, Type> typeArgumentVariables = Types.computeFreeTypeVariables(typeArgument);
                        unresolvedVariables.putAll(typeArgumentVariables);
                    }
                    break block4;
                }
                if (!(type instanceof TypeVariable)) break block6;
                unresolvedVariables.put((TypeVariable)type, type);
                break block4;
            }
            if (!(type instanceof WildcardType)) break block4;
            for (Type typeBound : ((WildcardType)type).getUpperBounds()) {
                typeBoundVariables = Types.computeFreeTypeVariables(typeBound);
                unresolvedVariables.putAll(typeBoundVariables);
            }
            for (Type typeBound : ((WildcardType)type).getLowerBounds()) {
                typeBoundVariables = Types.computeFreeTypeVariables(typeBound);
                unresolvedVariables.putAll(typeBoundVariables);
            }
        }
        return unresolvedVariables;
    }

    private static Set<ParameterizedType> computeTypeVariableDefinitions(Class<?> context) {
        if (context == Object.class) {
            return Collections.emptySet();
        }
        HashSet<ParameterizedType> types = new HashSet<ParameterizedType>();
        Type superType = context.getGenericSuperclass();
        if (superType instanceof ParameterizedType) {
            types.add((ParameterizedType)superType);
        }
        types.addAll(Types.computeTypeVariableDefinitions(Types.baseType(superType)));
        for (Type interfaceType : context.getGenericInterfaces()) {
            if (types.contains(interfaceType)) continue;
            if (interfaceType instanceof ParameterizedType) {
                types.add((ParameterizedType)interfaceType);
            }
            types.addAll(Types.computeTypeVariableDefinitions(Types.baseType(interfaceType)));
        }
        return types;
    }

    public static Class<?> baseType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof GenericArrayType) {
            return Array.newInstance(Types.baseType(((GenericArrayType)type).getGenericComponentType()), 0).getClass();
        }
        if (type instanceof ParameterizedType) {
            return Types.baseType(((ParameterizedType)type).getRawType());
        }
        return Object.class;
    }

    public static Class<?> boxedType(Type type) {
        if (!(type instanceof Class)) {
            return Types.baseType(type);
        }
        Class clazz = (Class)type;
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Void.TYPE) {
            return Void.class;
        }
        return clazz;
    }

    public static Type component(Type arrayType) {
        if (arrayType instanceof Class && ((Class)arrayType).isArray()) {
            return ((Class)arrayType).getComponentType();
        }
        if (arrayType instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)arrayType).getGenericComponentType();
            return Types.isBound(componentType) ? componentType : Object.class;
        }
        return Object.class;
    }

    public static boolean assignableTypes(Type toType, Type fromType) {
        Class<?> fromClass;
        if (toType == null) {
            return false;
        }
        if (fromType == null) {
            return true;
        }
        Class<?> toClass = Types.baseType(toType);
        if (!toClass.isAssignableFrom(fromClass = Types.baseType(fromType))) {
            return false;
        }
        if (toType instanceof Class || fromType instanceof Class) {
            return true;
        }
        List toArguments = Types.typeArguments(toType).collect(Collectors.toList());
        List fromArguments = Types.typeArguments(fromType).collect(Collectors.toList());
        return toArguments.equals(fromArguments);
    }

    public static boolean equalGenericTypes(Type type1, Type type2) {
        return type1.equals(type2) || type2.equals(type1);
    }

    public static boolean equalTypes(Type type1, Type type2) {
        return Types.baseType(type1).equals(Types.baseType(type2));
    }

    public static boolean boxingEquivalentTypes(Type type1, Type type2) {
        if (type1 instanceof Class && type2 instanceof Class) {
            return Types.boxedType(type1).equals(Types.boxedType(type2));
        }
        return false;
    }

    public static Optional<Type> typeArgument(Type type, int i) {
        if (type instanceof ParameterizedType) {
            Type[] actualTypeArguments = ((ParameterizedType)type).getActualTypeArguments();
            if (actualTypeArguments == null || actualTypeArguments.length <= i) {
                return Optional.empty();
            }
            return Optional.of(actualTypeArguments[i]);
        }
        return Optional.empty();
    }

    public static Stream<Type> typeArguments(Type type) {
        if (type instanceof ParameterizedType) {
            return Arrays.stream(((ParameterizedType)type).getActualTypeArguments());
        }
        return Stream.empty();
    }

    public static Class<?> innerType(Class<?> clazz, String name) {
        for (Class<?> inner : clazz.getDeclaredClasses()) {
            if (!inner.getSimpleName().equals(name)) continue;
            return inner;
        }
        throw new TypeNotPresentException(clazz.getName() + SYNTHETIC_INDICATOR + name, new ClassNotFoundException(clazz.getName() + SYNTHETIC_INDICATOR + name));
    }

    public static boolean isHidden(Type type, String pkg) {
        Class<?> clazz = Types.baseType(type);
        while (true) {
            int modifiers = clazz.getModifiers();
            if (clazz.isAnonymousClass() || clazz.isSynthetic()) {
                return true;
            }
            if (Modifier.isPublic(modifiers)) {
                return false;
            }
            if (Modifier.isPrivate(modifiers)) {
                return true;
            }
            if (clazz.isArray()) {
                clazz = clazz.getComponentType();
                continue;
            }
            if (pkg == null || !pkg.equals(clazz.getPackage().getName())) {
                return true;
            }
            if (clazz.getEnclosingClass() == null) break;
            clazz = clazz.getEnclosingClass();
        }
        return false;
    }

    public static boolean isGeneric(Type type) {
        return !(type instanceof Class);
    }

    public static boolean isGenericVariable(Type type, String pkg) {
        return type instanceof TypeVariable;
    }

    public static boolean isErasureHidden(Type type, String pkg) {
        if (type instanceof ParameterizedType) {
            Type[] actualTypeArguments = ((ParameterizedType)type).getActualTypeArguments();
            if (actualTypeArguments == null) {
                return false;
            }
            for (Type typeArgument : actualTypeArguments) {
                if (!Types.isHidden(typeArgument, pkg)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isHidden(Constructor<?> constructor, String pkg) {
        int modifiers = constructor.getModifiers();
        if (Modifier.isPrivate(modifiers)) {
            return true;
        }
        return Types.isHidden(constructor.getDeclaringClass(), pkg) || constructor.getDeclaringClass().getEnclosingClass() != null && !Modifier.isPublic(modifiers);
    }

    public static boolean isBoxedPrimitive(Type type) {
        if (!(type instanceof Class)) {
            return false;
        }
        Class clazz = (Class)type;
        if (clazz == Boolean.class) {
            return true;
        }
        if (clazz == Character.class) {
            return true;
        }
        if (clazz == Byte.class) {
            return true;
        }
        if (clazz == Short.class) {
            return true;
        }
        if (clazz == Integer.class) {
            return true;
        }
        if (clazz == Float.class) {
            return true;
        }
        if (clazz == Long.class) {
            return true;
        }
        return clazz == Double.class;
    }

    public static boolean isPrimitive(Type type) {
        return type instanceof Class && ((Class)type).isPrimitive();
    }

    public static boolean isLiteral(Type type) {
        return Types.isPrimitive(type) || Types.isBoxedPrimitive(type) || type == String.class;
    }

    public static boolean isBound(Type type) {
        return !(type instanceof TypeVariable) && !(type instanceof WildcardType);
    }

    public static Type array(Type componentType) {
        if (componentType instanceof Class) {
            return Array.newInstance((Class)componentType, 0).getClass();
        }
        return new GenericArrayTypeImplementation(componentType);
    }

    public static ParameterizedType parameterized(Type raw, Type owner, Type ... typeArgs) {
        return new ParameterizedTypeImplementation(raw, owner, typeArgs);
    }

    public static WildcardType wildcard() {
        return new WildcardTypeImplementation();
    }

    public static WildcardType wildcardExtends(Type ... bounds) {
        return new WildcardTypeImplementation().extending(bounds);
    }

    public static WildcardType wildcardSuper(Type ... bounds) {
        return new WildcardTypeImplementation().limiting(bounds);
    }

    public static List<Field> allFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> current = clazz; current != Object.class; current = current.getSuperclass()) {
            for (Field field : current.getDeclaredFields()) {
                if (field.isSynthetic()) continue;
                fields.add(field);
            }
        }
        return fields;
    }

    public static List<Class<?>> innerClasses(Class<?> of) {
        return Arrays.asList(of.getDeclaredClasses());
    }

    public static List<Method> allMethods(Class<?> clazz) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Class<?> current = clazz; current != Object.class; current = current.getSuperclass()) {
            for (Method method : current.getDeclaredMethods()) {
                if (method.isSynthetic()) continue;
                methods.add(method);
            }
        }
        return methods;
    }

    public static <T> Constructor<T> getDeclaredConstructor(Class<T> clazz, Class<?> ... parameterTypes) throws NoSuchMethodException {
        return clazz.getDeclaredConstructor(parameterTypes);
    }

    public static Method getDeclaredMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) throws NoSuchMethodException {
        Class<?> current = clazz;
        while (current != Object.class) {
            try {
                Method method = current.getDeclaredMethod(name, parameterTypes);
                if (!method.isSynthetic()) {
                    return method;
                }
                current = current.getSuperclass();
            }
            catch (NoSuchMethodException e) {
                current = current.getSuperclass();
            }
        }
        return current.getDeclaredMethod(name, parameterTypes);
    }

    public static List<Method> getDeclaredMethods(Class<?> clazz, String methodName) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Class<?> current = clazz; current != Object.class; current = current.getSuperclass()) {
            for (Method method : current.getDeclaredMethods()) {
                if (!method.getName().equals(methodName)) continue;
                methods.add(method);
            }
        }
        return methods;
    }

    public static Field getDeclaredField(Class<?> clazz, String name) throws NoSuchFieldException {
        Class<?> current;
        for (current = clazz; current != Object.class; current = current.getSuperclass()) {
            try {
                return current.getDeclaredField(name);
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        return current.getDeclaredField(name);
    }

    public static List<Field> getDeclaredFields(Class<?> clazz, String name) {
        ArrayList<Field> list = new ArrayList<Field>();
        Class<?> current = clazz;
        while (current != Object.class) {
            try {
                list.add(current.getDeclaredField(name));
                current = current.getSuperclass();
            }
            catch (NoSuchFieldException e) {
                current = current.getSuperclass();
            }
        }
        return list;
    }

    public static boolean needsCast(Type variableType, Type expressionType) {
        return !Types.baseType(variableType).isAssignableFrom(Types.baseType(expressionType)) && !Types.boxingEquivalentTypes(variableType, expressionType);
    }

    public static boolean isFinal(Field field) {
        return (field.getModifiers() & 0x10) == 16;
    }

    public static boolean isStatic(Field field) {
        return (field.getModifiers() & 8) == 8;
    }

    public static boolean isUnhandledSynthetic(Field field) {
        String name = field.getName();
        if (!field.isSynthetic() && !name.contains(SYNTHETIC_INDICATOR)) {
            return false;
        }
        for (String prefix : HANDLED_SYNTHETIC_PREFIXES) {
            if (!name.startsWith(prefix)) continue;
            return false;
        }
        return true;
    }

    public static Class<?> classFrom(Class<?> clazz, ClassLoader loader) throws ClassNotFoundException {
        int arrayDimensions = 0;
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
            ++arrayDimensions;
        }
        Class<?> reloadedClazz = clazz.isPrimitive() ? clazz : loader.loadClass(clazz.getName());
        for (int i = 0; i < arrayDimensions; ++i) {
            reloadedClazz = Array.newInstance(reloadedClazz, 0).getClass();
        }
        return reloadedClazz;
    }

    public static Class<?>[] parameterTypesFrom(Method method, ClassLoader loader) throws ClassNotFoundException {
        Class<?>[] parameterTypes = method.getParameterTypes();
        Class[] reloadedParameterTypes = new Class[parameterTypes.length];
        for (int i = 0; i < reloadedParameterTypes.length; ++i) {
            reloadedParameterTypes[i] = Types.classFrom(parameterTypes[i], loader);
        }
        return reloadedParameterTypes;
    }

    public static Class<?> returnTypeFrom(Method method, ClassLoader loader) throws ClassNotFoundException {
        Class<?> returnType = method.getReturnType();
        Class<?> reloadedReturnType = Types.classFrom(returnType, loader);
        return reloadedReturnType;
    }

    private static final class WildcardTypeImplementation
    implements WildcardType {
        private Type[] upperBounds = new Type[0];
        private Type[] lowerBounds = new Type[0];

        public WildcardTypeImplementation extending(Type ... bounds) {
            this.upperBounds = bounds;
            return this;
        }

        public WildcardTypeImplementation limiting(Type ... bounds) {
            this.lowerBounds = bounds;
            return this;
        }

        @Override
        public Type[] getUpperBounds() {
            return this.upperBounds;
        }

        @Override
        public Type[] getLowerBounds() {
            return this.lowerBounds;
        }

        @Override
        public String getTypeName() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("?");
            if (this.lowerBounds.length > 0) {
                buffer.append(" super ").append(Stream.of(this.lowerBounds).map(type -> type.getTypeName()).collect(Collectors.joining(", ")));
            }
            if (this.upperBounds.length > 0) {
                buffer.append(" extends ").append(Stream.of(this.upperBounds).filter(type -> type != Object.class).map(type -> type.getTypeName()).collect(Collectors.joining(", ")));
            }
            return buffer.toString();
        }

        public int hashCode() {
            return Arrays.hashCode(this.upperBounds) * 5 + Arrays.hashCode(this.lowerBounds) * 7 + 23;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WildcardTypeImplementation that = (WildcardTypeImplementation)obj;
            return Arrays.equals(this.upperBounds, that.upperBounds) && Arrays.equals(this.lowerBounds, that.lowerBounds);
        }

        public String toString() {
            return this.getTypeName();
        }
    }

    private static final class ParameterizedTypeImplementation
    implements ParameterizedType {
        private Type raw;
        private Type owner;
        private Type[] typeArgs;

        public ParameterizedTypeImplementation(Type raw, Type owner, Type ... typeArgs) {
            this.raw = raw;
            this.owner = owner;
            this.typeArgs = typeArgs;
        }

        @Override
        public Type getRawType() {
            return this.raw;
        }

        @Override
        public Type getOwnerType() {
            return this.owner;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.typeArgs;
        }

        @Override
        public String getTypeName() {
            StringBuilder buffer = new StringBuilder();
            buffer.append(this.raw.getTypeName());
            buffer.append('<');
            if (this.typeArgs != null && this.typeArgs.length > 0) {
                buffer.append(Stream.of(this.typeArgs).map(type -> type.getTypeName()).collect(Collectors.joining(", ")));
            }
            buffer.append('>');
            return buffer.toString();
        }

        public int hashCode() {
            return this.raw.hashCode() * 3 + (this.owner == null ? 0 : this.owner.hashCode() * 5) + Arrays.hashCode(this.typeArgs) * 7 + 13;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ParameterizedTypeImplementation that = (ParameterizedTypeImplementation)obj;
            return this.raw.equals(that.raw) && Objects.equals(this.owner, that.owner) && Arrays.equals(this.typeArgs, that.typeArgs);
        }

        public String toString() {
            return this.getTypeName();
        }
    }

    private static final class GenericArrayTypeImplementation
    implements GenericArrayType {
        private Type componentType;

        public GenericArrayTypeImplementation(Type componentType) {
            this.componentType = componentType;
        }

        @Override
        public Type getGenericComponentType() {
            return this.componentType;
        }

        @Override
        public String getTypeName() {
            StringBuilder buffer = new StringBuilder();
            buffer.append(this.componentType.getTypeName());
            buffer.append("[]");
            return buffer.toString();
        }

        public int hashCode() {
            return this.componentType.hashCode() + 19;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GenericArrayTypeImplementation that = (GenericArrayTypeImplementation)obj;
            return this.componentType.equals(that.componentType);
        }

        public String toString() {
            return this.getTypeName();
        }
    }
}

