/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.xrayinterface;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import net.amygdalum.xrayinterface.MethodInvocationHandler;
import net.amygdalum.xrayinterface.SignatureUtil;
import net.amygdalum.xrayinterface.XRayInterface;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsNull;

public class IsEquivalent<S, T extends Matcher<S>>
extends BaseMatcher<S> {
    private static final String WITH = "with";
    private Class<T> interfaceClazz;
    private Map<String, Object> properties;

    public IsEquivalent(Class<T> interfaceClazz) {
        this.interfaceClazz = interfaceClazz;
        this.properties = new LinkedHashMap<String, Object>();
    }

    public static <S, T extends Matcher<S>> T equivalentTo(Class<T> interfaceClazz) {
        return (T)((Matcher)new XRayInterfaceWith(new IsEquivalent<S, T>(interfaceClazz)).to(interfaceClazz));
    }

    protected MethodInvocationHandler handle(final String name) {
        return new MethodInvocationHandler(){

            @Override
            public Object invoke(Object object, Object ... args) throws Throwable {
                ((IsEquivalent)((Object)object)).properties.put(name, args[0]);
                return new XRayInterfaceWith((Object)IsEquivalent.this).to(IsEquivalent.this.interfaceClazz);
            }
        };
    }

    public boolean matches(Object item) {
        for (Map.Entry<String, Object> property : this.properties.entrySet()) {
            String name = property.getKey();
            Object value = property.getValue();
            try {
                Object itemValue = this.propertyValueFor(item, name);
                Matcher<?> matcher = this.matcherFor(value);
                if (matcher.matches(itemValue)) continue;
                return false;
            }
            catch (NoSuchFieldException e) {
                return false;
            }
        }
        return true;
    }

    private Object propertyValueFor(Object item, String name) throws NoSuchFieldException {
        for (Class<?> currentClass = item.getClass(); currentClass != null; currentClass = currentClass.getSuperclass()) {
            for (String fieldName : SignatureUtil.computeFieldNames(name)) {
                try {
                    Field field = currentClass.getDeclaredField(fieldName);
                    field.setAccessible(true);
                    return field.get(item);
                }
                catch (Exception e) {
                }
            }
        }
        throw new NoSuchFieldException(name);
    }

    private Matcher<?> matcherFor(Object value) {
        if (value instanceof Matcher) {
            return (Matcher)value;
        }
        if (value == null) {
            return IsNull.nullValue();
        }
        return IsEqual.equalTo((Object)value);
    }

    public void describeTo(Description description) {
        description.appendText("with properties ").appendValueList("", ", ", "", this.properties.entrySet());
    }

    public void describeMismatch(Object item, Description description) {
        LinkedHashMap<String, Object> mismatchedProperties = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            String property = entry.getKey();
            Object expected = entry.getValue();
            try {
                Object value = this.propertyValueFor(item, property);
                if (expected instanceof Matcher) {
                    value = this.describe((Matcher)expected, value);
                }
                mismatchedProperties.put(property, value);
            }
            catch (NoSuchFieldException e) {
                mismatchedProperties.put(property, "<missing>");
            }
        }
        description.appendText("with properties ").appendValueList("", ", ", "", mismatchedProperties.entrySet());
    }

    private String describe(Matcher<?> expected, Object value) {
        StringDescription description = new StringDescription();
        expected.describeMismatch(value, (Description)description);
        return description.toString();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    private static final class XRayInterfaceWith<S, T extends Matcher<S>>
    extends XRayInterface {
        private XRayInterfaceWith(Object object) {
            super(object);
        }

        @Override
        protected MethodInvocationHandler findInvocationHandler(Method method) throws NoSuchMethodException, NoSuchFieldException {
            IsEquivalent satisfiesMatcher = (IsEquivalent)((Object)this.getObject());
            if (method.getName().startsWith(IsEquivalent.WITH) && method.getParameterTypes().length == 1 && method.getReturnType() == satisfiesMatcher.interfaceClazz) {
                return satisfiesMatcher.handle(method.getName().substring(4));
            }
            return super.findInvocationHandler(method);
        }
    }
}

