/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.xrayinterface;

import java.util.Objects;
import java.util.stream.Stream;

public interface Type {
    public Class<?> matchedType();

    public Class<?> convertedType();

    public boolean matches(Class<?> var1);

    public Type matching(Class<?> var1);

    public static boolean matches(Type[] matchTypes, Class<?>[] types) {
        if (matchTypes.length != types.length) {
            return false;
        }
        for (int i = 0; i < types.length; ++i) {
            if (matchTypes[i].matches(types[i])) continue;
            return false;
        }
        return true;
    }

    public static Class<?>[] matchedTypes(Type[] types) {
        return (Class[])Stream.of(types).map(c -> c.matchedType()).toArray(Class[]::new);
    }

    public static Class<?>[] convertedTypes(Type[] types) {
        return (Class[])Stream.of(types).map(c -> c.convertedType()).toArray(Class[]::new);
    }

    public static boolean isWeakMatching(Type[] types) {
        return Stream.of(types).map(c -> c.matchedType()).anyMatch(Objects::isNull);
    }
}

