/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.xrayinterface;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.amygdalum.xrayinterface.ConstructorInvoker;
import net.amygdalum.xrayinterface.FieldGetter;
import net.amygdalum.xrayinterface.FieldProperty;
import net.amygdalum.xrayinterface.FieldSetter;
import net.amygdalum.xrayinterface.InterfaceMismatchException;
import net.amygdalum.xrayinterface.InvocationResolver;
import net.amygdalum.xrayinterface.MethodInvocationHandler;
import net.amygdalum.xrayinterface.MethodInvoker;
import net.amygdalum.xrayinterface.StaticGetter;
import net.amygdalum.xrayinterface.StaticMethodInvoker;
import net.amygdalum.xrayinterface.StaticProperty;
import net.amygdalum.xrayinterface.StaticSetter;

public class XRayInterface
extends InvocationResolver
implements InvocationHandler {
    private Map<Method, MethodInvocationHandler> methods = new HashMap<Method, MethodInvocationHandler>();
    private Object object;

    public XRayInterface(Object object) {
        super(object.getClass());
        this.object = object;
    }

    public XRayInterface(Class<?> clazz) {
        super(clazz);
    }

    public Map<Method, MethodInvocationHandler> getInterfaceMethods() {
        return this.methods;
    }

    public List<ConstructorInvoker> getConstructors() {
        return this.methods.values().stream().filter(value -> value instanceof ConstructorInvoker).map(value -> (ConstructorInvoker)value).collect(Collectors.toList());
    }

    public List<FieldProperty> getFieldProperties() {
        FieldProperty property;
        String field;
        LinkedHashMap<String, FieldProperty> properties = new LinkedHashMap<String, FieldProperty>();
        for (FieldSetter setter : this.getFieldSetters()) {
            field = setter.getFieldName();
            property = properties.computeIfAbsent(field, key -> new FieldProperty());
            property.setSetter(setter);
        }
        for (FieldGetter getter : this.getFieldGetters()) {
            field = getter.getFieldName();
            property = properties.computeIfAbsent(field, key -> new FieldProperty());
            property.setGetter(getter);
        }
        return new ArrayList<FieldProperty>(properties.values());
    }

    public List<FieldSetter> getFieldSetters() {
        return this.filteredMethods(FieldSetter.class);
    }

    public List<FieldGetter> getFieldGetters() {
        return this.filteredMethods(FieldGetter.class);
    }

    public List<StaticProperty> getStaticProperties() {
        StaticProperty property;
        String field;
        LinkedHashMap<String, StaticProperty> properties = new LinkedHashMap<String, StaticProperty>();
        for (StaticSetter setter : this.getStaticSetters()) {
            field = setter.getFieldName();
            property = properties.computeIfAbsent(field, key -> new StaticProperty());
            property.setSetter(setter);
        }
        for (StaticGetter getter : this.getStaticGetters()) {
            field = getter.getFieldName();
            property = properties.computeIfAbsent(field, key -> new StaticProperty());
            property.setGetter(getter);
        }
        return new ArrayList<StaticProperty>(properties.values());
    }

    public List<StaticSetter> getStaticSetters() {
        return this.filteredMethods(StaticSetter.class);
    }

    public List<StaticGetter> getStaticGetters() {
        return this.filteredMethods(StaticGetter.class);
    }

    public List<MethodInvoker> getMethods() {
        return this.filteredMethods(MethodInvoker.class);
    }

    public List<StaticMethodInvoker> getStaticMethods() {
        return this.filteredMethods(StaticMethodInvoker.class);
    }

    private <T> List<T> filteredMethods(Class<T> clazz) {
        return this.methods.values().stream().filter(value -> clazz.isInstance(value)).map(value -> clazz.cast(value)).collect(Collectors.toList());
    }

    public Object getObject() {
        return this.object;
    }

    public static XRayInterface xray(Object object) {
        if (object instanceof Class) {
            return new XRayInterface((Class)object);
        }
        return new XRayInterface(object);
    }

    public <T> T to(Class<T> interfaceClass) {
        try {
            ArrayList todo = new ArrayList();
            HashSet<Class> done = new HashSet<Class>();
            todo.add(interfaceClass);
            while (!todo.isEmpty()) {
                Class currentClass = (Class)todo.remove(0);
                done.add(currentClass);
                for (Method method : currentClass.getDeclaredMethods()) {
                    if (method.isDefault() || Modifier.isStatic(method.getModifiers())) continue;
                    if (!this.methods.containsKey(method)) {
                        this.methods.put(method, this.findInvocationHandler(method));
                    }
                    for (Class<?> superInterfaceClazz : currentClass.getInterfaces()) {
                        if (done.contains(superInterfaceClazz)) continue;
                        todo.add(superInterfaceClazz);
                    }
                }
            }
            return (T)Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, (InvocationHandler)this);
        }
        catch (NoSuchFieldException e) {
            throw new InterfaceMismatchException("cannot resolve property " + e.getMessage() + " on " + this.getType());
        }
        catch (NoSuchMethodException e) {
            throw new InterfaceMismatchException("cannot resolve method/property " + e.getMessage() + " on " + this.getType());
        }
    }

    public List<Method> unMappable(Class<?> interfaceClazz) {
        LinkedList<Method> conflicts = new LinkedList<Method>();
        for (Method method : interfaceClazz.getDeclaredMethods()) {
            try {
                this.findInvocationHandler(method);
            }
            catch (NoSuchFieldException | NoSuchMethodException e) {
                conflicts.add(method);
            }
        }
        return conflicts;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        MethodInvocationHandler handler = this.methods.get(method);
        if (handler != null) {
            return handler.invoke(this.object, args);
        }
        return method.invoke((Object)this, args);
    }

    public int hashCode() {
        return this.object.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Proxy) {
            return obj.equals(this);
        }
        return super.equals(obj);
    }
}

