/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.agents;

import org.distributeme.agents.Agency;
import org.distributeme.agents.AgencyException;
import org.distributeme.agents.Agent;
import org.distributeme.agents.AgentPackage;
import org.distributeme.agents.AgentPackageUtility;
import org.distributeme.agents.transporter.TransporterServiceException;
import org.distributeme.agents.transporter.generated.RemoteTransporterServiceStub;
import org.distributeme.agents.transporter.generated.TransporterServiceConstants;
import org.distributeme.core.ServiceDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum AgencyImpl implements Agency
{
    INSTANCE;

    private static Logger log;

    @Override
    public void receiveAndAwakeAgent(AgentPackage agentpackage) throws AgencyException {
        if (log.isDebugEnabled()) {
            log.debug("Incoming agent " + agentpackage);
        }
        Agent agent = AgentPackageUtility.unpack(agentpackage);
        Thread agentThread = new Thread((Runnable)new AgentRunnable(agent), "Agent " + agent.toString());
        agentThread.start();
    }

    @Override
    public void sendAgent(Agent agent, ServiceDescriptor destination) throws AgencyException {
        try {
            ServiceDescriptor target = destination.changeServiceId(TransporterServiceConstants.getServiceId());
            System.out.println("Sending agent " + agent + " to " + target);
            RemoteTransporterServiceStub transporter = new RemoteTransporterServiceStub(target);
            transporter.receiveAndAwakeAgent(AgentPackageUtility.pack(agent));
        }
        catch (TransporterServiceException e) {
            throw new AgencyException("sendAgent(" + agent + ", " + destination + ")", e);
        }
    }

    static {
        log = LoggerFactory.getLogger(AgencyImpl.class);
    }

    static class AgentRunnable
    implements Runnable {
        private Agent agent;

        public AgentRunnable(Agent toRun) {
            this.agent = toRun;
        }

        @Override
        public void run() {
            this.agent.awake();
        }
    }
}

