/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.agents;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.distributeme.agents.Agent;
import org.distributeme.agents.AgentPackage;

public class AgentPackageUtility {
    public static AgentPackage pack(Agent agent) {
        AgentPackage ret = new AgentPackage();
        try {
            ret.setRootClazzName(agent.getClass().getName());
            ret.setSerializedData(AgentPackageUtility.serializeAgent(agent));
            List<Class<?>> classes = AgentPackageUtility.scanForCustomClasses(agent);
            for (Class<?> c : classes) {
                ret.addClazzDefinition(c.getName(), AgentPackageUtility.readClass(c));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't pack agent " + agent, e);
        }
        return ret;
    }

    private static byte[] readClass(Class<?> c) {
        InputStream in = null;
        try {
            String path = c.getSimpleName() + ".class";
            in = c.getResourceAsStream(path);
            byte[] clazzData = new byte[in.available()];
            in.read(clazzData);
            byte[] byArray = clazzData;
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't load class " + c, e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static Agent unpack(AgentPackage pack) {
        try {
            AgentPackageUtilClassLoader loader = new AgentPackageUtilClassLoader(pack);
            Class<?> myAgent = Class.forName(pack.getRootClazzName(), true, loader);
            Agent agent = AgentPackageUtility.deserializeAgent(pack.getSerializedData(), loader);
            return agent;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] serializeAgent(Agent obj) throws IOException {
        ByteArrayOutputStream bOut = null;
        ObjectOutputStream oOut = null;
        try {
            bOut = new ByteArrayOutputStream();
            oOut = new ObjectOutputStream(bOut);
            oOut.writeObject(obj);
            byte[] byArray = bOut.toByteArray();
            return byArray;
        }
        finally {
            if (oOut != null) {
                try {
                    oOut.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static Agent deserializeAgent(byte[] data, final AgentPackageUtilClassLoader loader) throws IOException {
        ByteArrayInputStream bIn = null;
        ObjectInputStream oIn = null;
        try {
            bIn = new ByteArrayInputStream(data);
            oIn = new ObjectInputStream(bIn){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    System.out.println("Resolve class " + desc.getName() + " with loader " + loader);
                    return loader.loadClass(desc.getName(), false);
                }
            };
            Agent agent = (Agent)oIn.readObject();
            return agent;
        }
        catch (ClassNotFoundException e) {
            throw new IOException("deserialization failed: " + e.getMessage());
        }
        finally {
            if (oIn != null) {
                try {
                    oIn.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    static List<Class<?>> scanForCustomClasses(Agent agent) {
        ArrayList ret = new ArrayList();
        AgentPackageUtility.scanForCustomClassesInternally(agent.getClass(), ret);
        return ret;
    }

    private static void scanForCustomClassesInternally(Class<?> toScan, List<Class<?>> foundClasses) {
        if (toScan.isPrimitive()) {
            return;
        }
        foundClasses.add(toScan);
        Field[] fields = toScan.getDeclaredFields();
        if (fields == null || fields.length == 0) {
            return;
        }
        for (Field f : fields) {
            if (f.getType().isPrimitive() || f.getType().getName().startsWith("java.") || foundClasses.contains(f.getType())) continue;
            AgentPackageUtility.scanForCustomClassesInternally(f.getType(), foundClasses);
        }
    }

    static class AgentPackageUtilClassLoader
    extends ClassLoader {
        private Map<String, byte[]> classDefs;
        private Map<String, Class> cache = new HashMap<String, Class>();

        public AgentPackageUtilClassLoader(AgentPackage pack) {
            this.classDefs = pack.getClazzDefinitions();
        }

        @Override
        protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class fromCache = this.cache.get(name);
            if (fromCache != null) {
                return fromCache;
            }
            if (this.classDefs.get(name) == null) {
                return super.loadClass(name, resolve);
            }
            byte[] data = this.classDefs.get(name);
            Class<?> c = this.defineClass(name, data, 0, data.length);
            this.cache.put(name, c);
            return c;
        }
    }
}

