/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.agents.transporter.generated;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.distributeme.agents.AgentPackage;
import org.distributeme.agents.transporter.TransporterService;
import org.distributeme.agents.transporter.TransporterServiceException;
import org.distributeme.agents.transporter.generated.RemoteTransporterService;
import org.distributeme.agents.transporter.generated.TransporterServiceConstants;
import org.distributeme.core.Defaults;
import org.distributeme.core.ServerSideCallContext;
import org.distributeme.core.Verbosity;
import org.distributeme.core.concurrencycontrol.ConcurrencyControlStrategy;
import org.distributeme.core.interceptor.InterceptionContext;
import org.distributeme.core.interceptor.InterceptionPhase;
import org.distributeme.core.interceptor.InterceptorRegistry;
import org.distributeme.core.interceptor.InterceptorResponse;
import org.distributeme.core.interceptor.ServerSideRequestInterceptor;
import org.distributeme.core.util.VoidMarker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteTransporterServiceSkeleton
implements RemoteTransporterService {
    private static Logger log = LoggerFactory.getLogger(RemoteTransporterServiceSkeleton.class);
    private TransporterService implementation;
    private long lastAccess;
    private long created;
    private ConcurrencyControlStrategy clazzWideCCStrategy;
    private ConcurrencyControlStrategy receiveAndAwakeAgentCCStrategy_orgdistributemeagentsAgentPackageagent;

    public RemoteTransporterServiceSkeleton() {
        this(null);
    }

    public RemoteTransporterServiceSkeleton(TransporterService anImplementation) {
        this.receiveAndAwakeAgentCCStrategy_orgdistributemeagentsAgentPackageagent = this.clazzWideCCStrategy = Defaults.getDefaultConcurrencyControlStrategy();
        this.created = System.currentTimeMillis();
        this.implementation = anImplementation;
    }

    @Override
    public List receiveAndAwakeAgent(AgentPackage agent, Map<?, ?> __transportableCallContext) throws TransporterServiceException {
        InterceptorResponse interceptorResponse;
        this.lastAccess = System.currentTimeMillis();
        ServerSideCallContext diMeCallContext = new ServerSideCallContext("receiveAndAwakeAgent", __transportableCallContext);
        diMeCallContext.setServiceId(TransporterServiceConstants.getServiceId());
        ArrayList<AgentPackage> diMeParameters = new ArrayList<AgentPackage>();
        diMeParameters.add(agent);
        diMeCallContext.setParameters(diMeParameters);
        InterceptionContext diMeInterceptionContext = new InterceptionContext();
        List diMeInterceptors = InterceptorRegistry.getInstance().getServerSideRequestInterceptors();
        ArrayList<Object> __return = new ArrayList<Object>();
        diMeInterceptionContext.setCurrentPhase(InterceptionPhase.BEFORE_SERVANT_CALL);
        for (ServerSideRequestInterceptor interceptor : diMeInterceptors) {
            interceptorResponse = interceptor.beforeServantCall(diMeCallContext, diMeInterceptionContext);
            switch (interceptorResponse.getCommand()) {
                case ABORT: {
                    if (interceptorResponse.getException() instanceof RuntimeException) {
                        throw (RuntimeException)interceptorResponse.getException();
                    }
                    if (interceptorResponse.getException() instanceof TransporterServiceException) {
                        throw (TransporterServiceException)interceptorResponse.getException();
                    }
                    throw new RuntimeException("Interceptor exception", interceptorResponse.getException());
                }
                case RETURN: {
                    __return.set(0, interceptorResponse.getReturnValue());
                    diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
                    break;
                }
                case OVERWRITE_RETURN_AND_CONTINUE: {
                    __return.set(0, interceptorResponse.getReturnValue());
                    diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
                    break;
                }
            }
        }
        this.receiveAndAwakeAgentCCStrategy_orgdistributemeagentsAgentPackageagent.notifyServerSideCallStarted(diMeCallContext);
        try {
            this.implementation.receiveAndAwakeAgent(agent);
            __return.add(VoidMarker.VOID);
            __return.add(diMeCallContext.getTransportableCallContext());
            diMeInterceptionContext.setCurrentPhase(InterceptionPhase.AFTER_SERVANT_CALL);
            for (ServerSideRequestInterceptor interceptor : diMeInterceptors) {
                interceptorResponse = interceptor.afterServantCall(diMeCallContext, diMeInterceptionContext);
                switch (interceptorResponse.getCommand()) {
                    case ABORT: {
                        if (interceptorResponse.getException() instanceof RuntimeException) {
                            throw (RuntimeException)interceptorResponse.getException();
                        }
                        if (interceptorResponse.getException() instanceof TransporterServiceException) {
                            throw (TransporterServiceException)interceptorResponse.getException();
                        }
                        throw new RuntimeException("Interceptor exception", interceptorResponse.getException());
                    }
                    case RETURN: {
                        __return.set(0, interceptorResponse.getReturnValue());
                        diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
                        break;
                    }
                    case OVERWRITE_RETURN_AND_CONTINUE: {
                        __return.set(0, interceptorResponse.getReturnValue());
                        diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
                        break;
                    }
                }
            }
            ArrayList<Object> arrayList = __return;
            return arrayList;
        }
        catch (TransporterServiceException e) {
            if (Verbosity.logServerSideExceptions()) {
                log.error("receiveAndAwakeAgent()", (Throwable)e);
            }
            throw e;
        }
        finally {
            this.receiveAndAwakeAgentCCStrategy_orgdistributemeagentsAgentPackageagent.notifyServerSideCallFinished(diMeCallContext);
        }
    }

    public long getCreationTimestamp() {
        return this.created;
    }

    public long getLastAccessTimestamp() {
        return this.lastAccess;
    }
}

