/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.agents.transporter.generated;

import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.distributeme.agents.AgentPackage;
import org.distributeme.agents.transporter.TransporterService;
import org.distributeme.agents.transporter.TransporterServiceException;
import org.distributeme.agents.transporter.generated.RemoteTransporterService;
import org.distributeme.agents.transporter.generated.TransporterServiceConstants;
import org.distributeme.core.ClientSideCallContext;
import org.distributeme.core.Defaults;
import org.distributeme.core.DiscoveryMode;
import org.distributeme.core.RegistryUtil;
import org.distributeme.core.ServiceDescriptor;
import org.distributeme.core.concurrencycontrol.ConcurrencyControlStrategy;
import org.distributeme.core.exception.DistributemeRuntimeException;
import org.distributeme.core.exception.NoConnectionToServerException;
import org.distributeme.core.exception.ServiceUnavailableException;
import org.distributeme.core.failing.FailDecision;
import org.distributeme.core.failing.FailingStrategy;
import org.distributeme.core.interceptor.FailedByInterceptorException;
import org.distributeme.core.interceptor.InterceptionContext;
import org.distributeme.core.interceptor.InterceptionPhase;
import org.distributeme.core.interceptor.InterceptorRegistry;
import org.distributeme.core.interceptor.InterceptorResponse;

public class RemoteTransporterServiceStub
implements TransporterService {
    private volatile ConcurrentMap<String, RemoteTransporterService> delegates = new ConcurrentHashMap<String, RemoteTransporterService>();
    private DiscoveryMode discoveryMode = DiscoveryMode.AUTO;
    private FailingStrategy clazzWideFailingStrategy;
    private FailingStrategy receiveAndAwakeAgentFailingStrategy_orgdistributemeagentsAgentPackageagent = this.clazzWideFailingStrategy = Defaults.getDefaultFailingStrategy();
    private ConcurrencyControlStrategy clazzWideCCStrategy;
    private ConcurrencyControlStrategy receiveAndAwakeAgentCCStrategy_orgdistributemeagentsAgentPackageagent = this.clazzWideCCStrategy = Defaults.getDefaultConcurrencyControlStrategy();
    private ServiceDescriptor manuallySetDescriptor;
    private RemoteTransporterService manuallySetTarget;

    public RemoteTransporterServiceStub() {
        this.discoveryMode = DiscoveryMode.AUTO;
    }

    public RemoteTransporterServiceStub(ServiceDescriptor target) {
        this.discoveryMode = DiscoveryMode.MANUAL;
        this.manuallySetDescriptor = target;
        try {
            this.manuallySetTarget = this.lookup(this.manuallySetDescriptor);
        }
        catch (NoConnectionToServerException e) {
            throw new IllegalStateException("Can not resolve manually set reference", e);
        }
    }

    @Override
    public void receiveAndAwakeAgent(AgentPackage agent) throws TransporterServiceException {
        this.receiveAndAwakeAgent(agent, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveAndAwakeAgent(AgentPackage agent, ClientSideCallContext diMeCallContext) throws TransporterServiceException {
        InterceptorResponse interceptorResponse;
        List __fromServerSide = null;
        Throwable exceptionInMethod = null;
        boolean diMeForceFailing = false;
        boolean abortAndFail = false;
        if (diMeCallContext == null) {
            diMeCallContext = new ClientSideCallContext("receiveAndAwakeAgent");
        }
        if (this.discoveryMode == DiscoveryMode.MANUAL) {
            diMeCallContext.setServiceId(this.manuallySetDescriptor.getServiceId());
        }
        if (this.discoveryMode == DiscoveryMode.AUTO && diMeCallContext.getServiceId() == null) {
            diMeCallContext.setServiceId(TransporterServiceConstants.getServiceId());
        }
        HashMap __transportableCallContext = diMeCallContext.getTransportableCallContext();
        List diMeInterceptors = InterceptorRegistry.getInstance().getClientSideRequestInterceptors();
        InterceptionContext diMeInterceptionContext = new InterceptionContext();
        this.receiveAndAwakeAgentCCStrategy_orgdistributemeagentsAgentPackageagent.notifyClientSideCallStarted(diMeCallContext);
        try {
            ArrayList<AgentPackage> diMeParameters = new ArrayList<AgentPackage>();
            diMeParameters.add(agent);
            diMeCallContext.setParameters(diMeParameters);
            diMeInterceptionContext.setCurrentPhase(InterceptionPhase.BEFORE_SERVICE_CALL);
            block61: for (Object interceptor : diMeInterceptors) {
                interceptorResponse = interceptor.beforeServiceCall(diMeCallContext, diMeInterceptionContext);
                switch (interceptorResponse.getCommand()) {
                    case ABORT: {
                        if (interceptorResponse.getException() instanceof RuntimeException) {
                            throw (RuntimeException)interceptorResponse.getException();
                        }
                        if (interceptorResponse.getException() instanceof TransporterServiceException) {
                            throw (TransporterServiceException)interceptorResponse.getException();
                        }
                        throw new RuntimeException("Interceptor exception", interceptorResponse.getException());
                    }
                    case RETURN: {
                        return;
                    }
                    case CONTINUE: {
                        continue block61;
                    }
                    case ABORT_AND_FAIL: {
                        abortAndFail = true;
                        exceptionInMethod = new FailedByInterceptorException();
                        continue block61;
                    }
                    case RETURN_AND_FAIL: {
                        diMeForceFailing = true;
                        exceptionInMethod = new FailedByInterceptorException();
                        continue block61;
                    }
                }
                throw new IllegalStateException("Unsupported or unexpected command from interceptor " + interceptorResponse.getCommand() + " in phase:" + diMeInterceptionContext.getCurrentPhase());
            }
            agent = (AgentPackage)diMeParameters.get(0);
            if (!abortAndFail) {
                __fromServerSide = this.getDelegate(diMeCallContext.getServiceId()).receiveAndAwakeAgent(agent, __transportableCallContext);
                __transportableCallContext.putAll((HashMap)__fromServerSide.get(1));
                return;
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
            this.notifyDelegateFailed(diMeCallContext.getServiceId());
            exceptionInMethod = e;
        }
        catch (NoConnectionToServerException e) {
            exceptionInMethod = e;
        }
        finally {
            this.receiveAndAwakeAgentCCStrategy_orgdistributemeagentsAgentPackageagent.notifyClientSideCallFinished(diMeCallContext);
            diMeInterceptionContext.setCurrentPhase(InterceptionPhase.AFTER_SERVICE_CALL);
            if (__fromServerSide != null) {
                diMeInterceptionContext.setReturnValue(__fromServerSide.get(0));
            }
            diMeInterceptionContext.setException((Exception)exceptionInMethod);
            boolean diMeReturnOverriden = false;
            block62: for (Object interceptor : diMeInterceptors) {
                interceptorResponse = interceptor.afterServiceCall(diMeCallContext, diMeInterceptionContext);
                switch (interceptorResponse.getCommand()) {
                    case ABORT: {
                        if (interceptorResponse.getException() instanceof RuntimeException) {
                            throw (RuntimeException)interceptorResponse.getException();
                        }
                        if (interceptorResponse.getException() instanceof TransporterServiceException) {
                            throw (TransporterServiceException)interceptorResponse.getException();
                        }
                        throw new RuntimeException("Interceptor exception", interceptorResponse.getException());
                    }
                    case RETURN: {
                        return;
                    }
                    case CONTINUE: {
                        continue block62;
                    }
                    case ABORT_AND_FAIL: {
                        abortAndFail = true;
                        continue block62;
                    }
                    case RETURN_AND_FAIL: {
                        this.receiveAndAwakeAgentFailingStrategy_orgdistributemeagentsAgentPackageagent.callFailed(diMeCallContext);
                        continue block62;
                    }
                }
                throw new IllegalStateException("Unsupported or unexpected command from interceptor " + interceptorResponse.getCommand() + " in phase:" + diMeInterceptionContext.getCurrentPhase());
            }
        }
        if (exceptionInMethod != null || diMeForceFailing || abortAndFail) {
            FailDecision failDecision = this.receiveAndAwakeAgentFailingStrategy_orgdistributemeagentsAgentPackageagent.callFailed(diMeCallContext);
            if (failDecision.getTargetService() != null) {
                diMeCallContext.setServiceId(failDecision.getTargetService());
            }
            switch (failDecision.getReaction()) {
                case RETRY: {
                    this.receiveAndAwakeAgent(agent, diMeCallContext.increaseCallCount());
                    return;
                }
                case RETRYONCE: {
                    if (!diMeCallContext.isFirstCall()) break;
                    this.receiveAndAwakeAgent(agent, diMeCallContext.increaseCallCount());
                    return;
                }
            }
        }
        if (exceptionInMethod == null) {
            throw new AssertionError((Object)"Exception must have been thrown before, but it wasn't, framework error!");
        }
        throw this.mapException((Exception)exceptionInMethod);
    }

    private void notifyDelegateFailed(String serviceId) {
        if (this.discoveryMode == DiscoveryMode.MANUAL) {
            this.manuallySetTarget = null;
            return;
        }
        if (serviceId != null) {
            this.delegates.remove(serviceId);
        }
    }

    private RemoteTransporterService getDelegate() throws NoConnectionToServerException {
        if (this.discoveryMode == DiscoveryMode.MANUAL) {
            if (this.manuallySetTarget != null) {
                return this.manuallySetTarget;
            }
            this.manuallySetTarget = this.lookup(this.manuallySetDescriptor);
            return this.manuallySetTarget;
        }
        return this.getDelegate(TransporterServiceConstants.getServiceId());
    }

    private RemoteTransporterService getDelegate(String serviceId) throws NoConnectionToServerException {
        if (serviceId == null || this.discoveryMode == DiscoveryMode.MANUAL) {
            return this.getDelegate();
        }
        RemoteTransporterService delegate = (RemoteTransporterService)this.delegates.get(serviceId);
        if (delegate == null) {
            try {
                delegate = this.lookup(serviceId);
                RemoteTransporterService existingDelegate = this.delegates.putIfAbsent(serviceId, delegate);
                if (existingDelegate != null) {
                    delegate = existingDelegate;
                }
            }
            catch (Exception e) {
                throw new NoConnectionToServerException("Couldn't lookup delegate because: " + e.getMessage() + " at " + RegistryUtil.describeRegistry(), e);
            }
        }
        return delegate;
    }

    private RemoteTransporterService lookup(String serviceId) throws NoConnectionToServerException {
        ServiceDescriptor toLookup = new ServiceDescriptor(ServiceDescriptor.Protocol.RMI, serviceId);
        ServiceDescriptor targetService = RegistryUtil.resolve((ServiceDescriptor)toLookup);
        if (targetService == null) {
            throw new RuntimeException("Can't resolve host for an instance of " + TransporterServiceConstants.getServiceId());
        }
        Registry registry = null;
        try {
            registry = LocateRegistry.getRegistry(targetService.getHost(), targetService.getPort());
        }
        catch (Exception e) {
            System.err.println("lookup - couldn't obtain rmi registry on " + targetService + ", aborting lookup");
            e.printStackTrace();
            throw new NoConnectionToServerException("Can't resolve rmi registry for an instance of " + TransporterServiceConstants.getServiceId());
        }
        try {
            return (RemoteTransporterService)registry.lookup(serviceId);
        }
        catch (RemoteException e) {
            throw new NoConnectionToServerException("Can't lookup service in the target rmi registry for an instance of " + serviceId, (Exception)e);
        }
        catch (NotBoundException e) {
            throw new NoConnectionToServerException("Can't lookup service in the target rmi registry for an instance of " + serviceId, (Exception)e);
        }
    }

    private RemoteTransporterService lookup(ServiceDescriptor serviceDescriptor) throws NoConnectionToServerException {
        Registry registry = null;
        try {
            registry = LocateRegistry.getRegistry(serviceDescriptor.getHost(), serviceDescriptor.getPort());
        }
        catch (Exception e) {
            System.err.println("lookup - couldn't obtain rmi registry on " + serviceDescriptor + ", aborting lookup");
            e.printStackTrace();
            throw new NoConnectionToServerException("Can't resolve rmi registry for " + serviceDescriptor);
        }
        try {
            RemoteTransporterService ret = (RemoteTransporterService)registry.lookup(serviceDescriptor.getServiceId());
            return ret;
        }
        catch (RemoteException e) {
            throw new NoConnectionToServerException("Can't lookup service in the target rmi registry for an instance of " + serviceDescriptor, (Exception)e);
        }
        catch (NotBoundException e) {
            throw new NoConnectionToServerException("Can't lookup service in the target rmi registry for an instance of " + serviceDescriptor, (Exception)e);
        }
    }

    private DistributemeRuntimeException mapException(Exception in) {
        if (in instanceof DistributemeRuntimeException) {
            return (DistributemeRuntimeException)in;
        }
        if (in instanceof RemoteException) {
            return new ServiceUnavailableException("Service unavailable due to rmi failure: " + in.getMessage(), in);
        }
        return new ServiceUnavailableException("Unexpected exception: " + in.getMessage() + " " + in.getClass().getName(), in);
    }
}

