package org.distributeme.test.asynch.generated;
//CHECKSTYLE:OFF

import java.util.List;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.distributeme.test.asynch.TestService;
import java.lang.InterruptedException;
import org.distributeme.core.exception.DistributemeRuntimeException;
import org.distributeme.core.exception.NoConnectionToServerException;
import org.distributeme.core.exception.ServiceUnavailableException;
import org.distributeme.core.Defaults;
import org.distributeme.core.asynch.CallBackHandler;
import org.distributeme.core.asynch.SingleCallHandler;
import org.distributeme.core.asynch.CallTimeoutedException;
import java.lang.IllegalStateException;
import org.distributeme.core.ServiceLocator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;

public class AsynchTestServiceStub implements AsynchTestService{


	private final TestService diMeTarget;
	private final ExecutorService diMeExecutor;
	private final AtomicLong diMeRequestCounter = new AtomicLong();

	public AsynchTestServiceStub(){
		this(ServiceLocator.getRemote(TestService.class));
	}


	public AsynchTestServiceStub(TestService aTarget){
		diMeTarget = aTarget;
		diMeExecutor = Executors.newFixedThreadPool(Defaults.getAsynchExecutorPoolSize());
	}

	public long ping(long param){
		SingleCallHandler diMeCallHandler = new SingleCallHandler();
		asynchPing(param, diMeCallHandler);
		try{
			diMeCallHandler.waitForResults(2000);
		}catch(InterruptedException e){
		}
		if (!diMeCallHandler.isFinished())
			throw new CallTimeoutedException();
		if (diMeCallHandler.isSuccess())
			return ((Long)diMeCallHandler.getReturnValue()).longValue();
		if (diMeCallHandler.isError()){
			Exception exceptionInMethod = diMeCallHandler.getReturnException();
			if (exceptionInMethod instanceof RuntimeException)
				throw (RuntimeException)exceptionInMethod;
			throw new RuntimeException("Shouldn't happen, unexpected exception of class "+exceptionInMethod.getClass().getName()+" thrown by method", exceptionInMethod);
		} //...if isError
		throw new IllegalStateException("You can't be here ;-)");
	} //...long ping(long param)

	public  void asynchPing(final long param, final CallBackHandler... diMeHandlers){
		diMeExecutor.execute(new Runnable() {
			@Override
			public void run() {
				try{
					// make the real call here
					long diMeReturnValue = diMeTarget.ping(param);
					if (diMeHandlers!=null){
						for (CallBackHandler diMeHandler : diMeHandlers){
							try{
								diMeHandler.success(diMeReturnValue);
							}catch(Exception ignored){
							// add exception warn here
							}
						} //...for
					} //...if
				}catch(Exception e){
					if (diMeHandlers!=null){
						for (CallBackHandler diMeHandler : diMeHandlers){
							try{
								diMeHandler.error(e);
							}catch(Exception ignored){
							// add exception warn here
							}
						} //...for
					} //...if
				} //...catch
			}
		});
	} //...public  void asynchPing(final long param, final CallBackHandler... diMeHandlers)

	public long sleepAndReturnRandom(long sleepTime){
		SingleCallHandler diMeCallHandler = new SingleCallHandler();
		asynchSleepAndReturnRandom(sleepTime, diMeCallHandler);
		try{
			diMeCallHandler.waitForResults(2000);
		}catch(InterruptedException e){
		}
		if (!diMeCallHandler.isFinished())
			throw new CallTimeoutedException();
		if (diMeCallHandler.isSuccess())
			return ((Long)diMeCallHandler.getReturnValue()).longValue();
		if (diMeCallHandler.isError()){
			Exception exceptionInMethod = diMeCallHandler.getReturnException();
			if (exceptionInMethod instanceof RuntimeException)
				throw (RuntimeException)exceptionInMethod;
			throw new RuntimeException("Shouldn't happen, unexpected exception of class "+exceptionInMethod.getClass().getName()+" thrown by method", exceptionInMethod);
		} //...if isError
		throw new IllegalStateException("You can't be here ;-)");
	} //...long sleepAndReturnRandom(long sleepTime)

	public  void asynchSleepAndReturnRandom(final long sleepTime, final CallBackHandler... diMeHandlers){
		diMeExecutor.execute(new Runnable() {
			@Override
			public void run() {
				try{
					// make the real call here
					long diMeReturnValue = diMeTarget.sleepAndReturnRandom(sleepTime);
					if (diMeHandlers!=null){
						for (CallBackHandler diMeHandler : diMeHandlers){
							try{
								diMeHandler.success(diMeReturnValue);
							}catch(Exception ignored){
							// add exception warn here
							}
						} //...for
					} //...if
				}catch(Exception e){
					if (diMeHandlers!=null){
						for (CallBackHandler diMeHandler : diMeHandlers){
							try{
								diMeHandler.error(e);
							}catch(Exception ignored){
							// add exception warn here
							}
						} //...for
					} //...if
				} //...catch
			}
		});
	} //...public  void asynchSleepAndReturnRandom(final long sleepTime, final CallBackHandler... diMeHandlers)

	public void sleep(long sleepTime){
		SingleCallHandler diMeCallHandler = new SingleCallHandler();
		asynchSleep(sleepTime, diMeCallHandler);
		try{
			diMeCallHandler.waitForResults(2000);
		}catch(InterruptedException e){
		}
		if (!diMeCallHandler.isFinished())
			throw new CallTimeoutedException();
		if (diMeCallHandler.isSuccess())
			return;
		if (diMeCallHandler.isError()){
			Exception exceptionInMethod = diMeCallHandler.getReturnException();
			if (exceptionInMethod instanceof RuntimeException)
				throw (RuntimeException)exceptionInMethod;
			throw new RuntimeException("Shouldn't happen, unexpected exception of class "+exceptionInMethod.getClass().getName()+" thrown by method", exceptionInMethod);
		} //...if isError
		throw new IllegalStateException("You can't be here ;-)");
	} //...void sleep(long sleepTime)

	public  void asynchSleep(final long sleepTime, final CallBackHandler... diMeHandlers){
		diMeExecutor.execute(new Runnable() {
			@Override
			public void run() {
				try{
					// make the real call here
					diMeTarget.sleep(sleepTime);
					if (diMeHandlers!=null){
						for (CallBackHandler diMeHandler : diMeHandlers){
							try{
								diMeHandler.success(null);
							}catch(Exception ignored){
							// add exception warn here
							}
						} //...for
					} //...if
				}catch(Exception e){
					if (diMeHandlers!=null){
						for (CallBackHandler diMeHandler : diMeHandlers){
							try{
								diMeHandler.error(e);
							}catch(Exception ignored){
							// add exception warn here
							}
						} //...for
					} //...if
				} //...catch
			}
		});
	} //...public  void asynchSleep(final long sleepTime, final CallBackHandler... diMeHandlers)

	public void sleepAndThrowTypedException(long sleepTime) throws org.distributeme.test.asynch.TestServiceException{
		SingleCallHandler diMeCallHandler = new SingleCallHandler();
		asynchSleepAndThrowTypedException(sleepTime, diMeCallHandler);
		try{
			diMeCallHandler.waitForResults(2000);
		}catch(InterruptedException e){
		}
		if (!diMeCallHandler.isFinished())
			throw new CallTimeoutedException();
		if (diMeCallHandler.isSuccess())
			return;
		if (diMeCallHandler.isError()){
			Exception exceptionInMethod = diMeCallHandler.getReturnException();
			if (exceptionInMethod instanceof RuntimeException)
				throw (RuntimeException)exceptionInMethod;
			if (exceptionInMethod instanceof org.distributeme.test.asynch.TestServiceException)
				throw (org.distributeme.test.asynch.TestServiceException)exceptionInMethod;
			throw new RuntimeException("Shouldn't happen, unexpected exception of class "+exceptionInMethod.getClass().getName()+" thrown by method", exceptionInMethod);
		} //...if isError
		throw new IllegalStateException("You can't be here ;-)");
	} //...void sleepAndThrowTypedException(long sleepTime) throws org.distributeme.test.asynch.TestServiceException

	public  void asynchSleepAndThrowTypedException(final long sleepTime, final CallBackHandler... diMeHandlers){
		diMeExecutor.execute(new Runnable() {
			@Override
			public void run() {
				try{
					// make the real call here
					diMeTarget.sleepAndThrowTypedException(sleepTime);
					if (diMeHandlers!=null){
						for (CallBackHandler diMeHandler : diMeHandlers){
							try{
								diMeHandler.success(null);
							}catch(Exception ignored){
							// add exception warn here
							}
						} //...for
					} //...if
				}catch(Exception e){
					if (diMeHandlers!=null){
						for (CallBackHandler diMeHandler : diMeHandlers){
							try{
								diMeHandler.error(e);
							}catch(Exception ignored){
							// add exception warn here
							}
						} //...for
					} //...if
				} //...catch
			}
		});
	} //...public  void asynchSleepAndThrowTypedException(final long sleepTime, final CallBackHandler... diMeHandlers)

	public void sleepAndThrowRuntimeException(long sleepTime){
		SingleCallHandler diMeCallHandler = new SingleCallHandler();
		asynchSleepAndThrowRuntimeException(sleepTime, diMeCallHandler);
		try{
			diMeCallHandler.waitForResults(2000);
		}catch(InterruptedException e){
		}
		if (!diMeCallHandler.isFinished())
			throw new CallTimeoutedException();
		if (diMeCallHandler.isSuccess())
			return;
		if (diMeCallHandler.isError()){
			Exception exceptionInMethod = diMeCallHandler.getReturnException();
			if (exceptionInMethod instanceof RuntimeException)
				throw (RuntimeException)exceptionInMethod;
			throw new RuntimeException("Shouldn't happen, unexpected exception of class "+exceptionInMethod.getClass().getName()+" thrown by method", exceptionInMethod);
		} //...if isError
		throw new IllegalStateException("You can't be here ;-)");
	} //...void sleepAndThrowRuntimeException(long sleepTime)

	public  void asynchSleepAndThrowRuntimeException(final long sleepTime, final CallBackHandler... diMeHandlers){
		diMeExecutor.execute(new Runnable() {
			@Override
			public void run() {
				try{
					// make the real call here
					diMeTarget.sleepAndThrowRuntimeException(sleepTime);
					if (diMeHandlers!=null){
						for (CallBackHandler diMeHandler : diMeHandlers){
							try{
								diMeHandler.success(null);
							}catch(Exception ignored){
							// add exception warn here
							}
						} //...for
					} //...if
				}catch(Exception e){
					if (diMeHandlers!=null){
						for (CallBackHandler diMeHandler : diMeHandlers){
							try{
								diMeHandler.error(e);
							}catch(Exception ignored){
							// add exception warn here
							}
						} //...for
					} //...if
				} //...catch
			}
		});
	} //...public  void asynchSleepAndThrowRuntimeException(final long sleepTime, final CallBackHandler... diMeHandlers)


	public void shutdown(){
		diMeExecutor.shutdown();
	}
}
