package org.distributeme.test.combined.generated;
//CHECKSTYLE:OFF

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import java.rmi.server.UnicastRemoteObject;
import java.security.Permission;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import org.distributeme.core.RegistryUtil;
import org.distributeme.core.RegistryLocation;
import java.rmi.server.ExportException;
import org.distributeme.core.ServiceDescriptor;
import org.distributeme.core.util.LocalServiceDescriptorStore;
import org.distributeme.core.ServiceDescriptor.Protocol;
import net.anotheria.anoprise.metafactory.MetaFactory;
import net.anotheria.anoprise.metafactory.FactoryNotFoundException;
import net.anotheria.anoprise.metafactory.Extension;
import net.anotheria.util.PidTools;
import net.anotheria.util.IdCodeGenerator;
import org.distributeme.core.RMIRegistryUtil;
import java.rmi.RemoteException;
import net.anotheria.anoprise.metafactory.ServiceFactory;
import org.distributeme.core.lifecycle.LifecycleComponentImpl;
import org.distributeme.core.Verbosity;
import org.distributeme.core.SystemPropertyNames;
import org.distributeme.core.ServerShutdownHook;
import org.distributeme.core.conventions.SystemProperties;
import java.util.List;
import org.distributeme.core.routing.RoutingAware;

import org.distributeme.support.lifecycle.generated.LifecycleSupportServer;
import org.distributeme.support.eventservice.generated.EventServiceRMIBridgeServer;
import org.distributeme.agents.transporter.generated.TransporterServer;
public class BusinessAndAdminServer{

	private static Logger log;
	private static Marker FATAL = MarkerFactory.getMarker("FATAL");

	public static void main(String a[]) throws Exception{
		if (System.getSecurityManager()==null)
			// We allow all operations.
			System.setSecurityManager(new SecurityManager(){
				public void checkPermission(Permission perm) { }
			});
		try {
			init();
			// Log current server PID (Process Id)
			PidTools.logPid();
			// force verbosity to configure itself
			Verbosity.logServerSideExceptions();
			createSupportServicesAndRegisterLocally();
			createCombinedServicesAndRegisterLocally();
			startService();
			notifyListenersAboutStart();
		} catch (Throwable e) {
			log.error(FATAL, "Unhandled exception caught", e);
			System.err.println(e.getMessage());
			System.exit(-4);
		}
	} //...main

	private static final List<org.distributeme.core.listener.ServerLifecycleListener> serverListeners = new java.util.ArrayList<org.distributeme.core.listener.ServerLifecycleListener>(0);
	private static void notifyListenersAboutStart(){
		// configured listeners
		List<org.distributeme.core.listener.ServerLifecycleListener> configuredListeners = org.distributeme.core.listener.ListenerRegistry.getInstance().getServerLifecycleListeners();
		if (configuredListeners!=null && configuredListeners.size()>0){
			for (org.distributeme.core.listener.ServerLifecycleListener listener : configuredListeners){
				try{
					listener.afterStart();
				}catch(Exception e){
					log.error("Couldn't call afterStart on  listener " + listener, e);
				}
			} //...for
		} //...if
	} //...notifyListenersAboutStart

	public static void init() throws Exception{
		log = LoggerFactory.getLogger(BusinessAndAdminServer.class);
		// // CUSTOM CODE STARTED
		// // CUSTOM CODE ENDED
	} //...init

	public static void startService() throws Exception{
		String instanceId = IdCodeGenerator.generateCode(10);
		ServiceDescriptor adminserverDescriptor = org.distributeme.test.combined.generated.AdminServer.createDescriptor(instanceId);
		LocalServiceDescriptorStore.getInstance().addServiceDescriptor(adminserverDescriptor);

		if (!RegistryUtil.bind(adminserverDescriptor)){
			log.error(FATAL, "Couldn't bind "+adminserverDescriptor+" to the central registry at "+RegistryUtil.describeRegistry());
			System.err.println("Couldn't bind "+adminserverDescriptor+" at the central registry at "+RegistryUtil.describeRegistry());
			System.exit(-3);
		} //...central registry bind
		Runtime.getRuntime().addShutdownHook(new ServerShutdownHook(adminserverDescriptor));

		System.out.println("Server "+adminserverDescriptor.getServiceId()+" is up and ready.");
		ServiceDescriptor businessserverDescriptor = org.distributeme.test.combined.generated.BusinessServer.createDescriptor(instanceId);
		LocalServiceDescriptorStore.getInstance().addServiceDescriptor(businessserverDescriptor);

		if (!RegistryUtil.bind(businessserverDescriptor)){
			log.error(FATAL, "Couldn't bind "+businessserverDescriptor+" to the central registry at "+RegistryUtil.describeRegistry());
			System.err.println("Couldn't bind "+businessserverDescriptor+" at the central registry at "+RegistryUtil.describeRegistry());
			System.exit(-3);
		} //...central registry bind
		Runtime.getRuntime().addShutdownHook(new ServerShutdownHook(businessserverDescriptor));

		System.out.println("Server "+businessserverDescriptor.getServiceId()+" is up and ready.");
		Runtime.getRuntime().addShutdownHook(new org.distributeme.core.listener.ServerLifecycleListenerShutdownHook(serverListeners));
	} //...startService

	public static void createSupportServicesAndRegisterLocally() throws Exception{
		org.distributeme.support.lifecycle.generated.LifecycleSupportServer.init();
		org.distributeme.support.lifecycle.generated.LifecycleSupportServer.createServiceAndRegisterLocally();
		org.distributeme.support.eventservice.generated.EventServiceRMIBridgeServer.init();
		org.distributeme.support.eventservice.generated.EventServiceRMIBridgeServer.createServiceAndRegisterLocally();
		org.distributeme.agents.transporter.generated.TransporterServer.init();
		org.distributeme.agents.transporter.generated.TransporterServer.createServiceAndRegisterLocally();
	} //...createSupportServicesAndRegisterLocally


	public static void createCombinedServicesAndRegisterLocally() throws Exception{
		createCombinedServicesAndRegisterLocally(-1);
	} //...createCombinedServicesAndRegisterLocally

	public static void createCombinedServicesAndRegisterLocally(int customRegistryPort) throws Exception{
		org.distributeme.test.combined.generated.AdminServer.init();
		org.distributeme.test.combined.generated.AdminServer.createServiceAndRegisterLocally(customRegistryPort);
		org.distributeme.test.combined.generated.BusinessServer.init();
		org.distributeme.test.combined.generated.BusinessServer.createServiceAndRegisterLocally(customRegistryPort);
	} //...createCombinedServicesAndRegisterLocally

}
