package org.distributeme.test.concurrencycontrol.generated;
//CHECKSTYLE:OFF

import java.util.List;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import java.rmi.RemoteException;
import java.rmi.NotBoundException;
import org.distributeme.core.RegistryUtil;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import org.distributeme.core.ServiceDescriptor;
import org.distributeme.core.ServiceDescriptor.Protocol;
import org.distributeme.core.DiscoveryMode;
import org.distributeme.core.failing.FailingStrategy;
import org.distributeme.core.concurrencycontrol.ConcurrencyControlStrategy;
import org.distributeme.core.failing.FailDecision;
import org.distributeme.core.ClientSideCallContext;
import org.distributeme.core.exception.DistributemeRuntimeException;
import org.distributeme.core.exception.NoConnectionToServerException;
import org.distributeme.core.exception.ServiceUnavailableException;
import org.distributeme.core.Defaults;
import org.distributeme.core.interceptor.ClientSideRequestInterceptor;
import org.distributeme.core.interceptor.InterceptorRegistry;
import org.distributeme.core.interceptor.InterceptorResponse;
import org.distributeme.core.interceptor.InterceptionContext;
import org.distributeme.core.interceptor.InterceptionPhase;
import org.distributeme.core.interceptor.FailedByInterceptorException;

public class RemoteTestServiceStub implements org.distributeme.test.concurrencycontrol.TestService{


	private volatile ConcurrentMap<String,RemoteTestService> delegates = new ConcurrentHashMap<String,RemoteTestService>();

	private DiscoveryMode discoveryMode = DiscoveryMode.AUTO;

	// ROUTER DECL V2
	// No class-wide-router set, skipping.

	// Method wide routers if applicable 
	// Method wide routers END 

	// ROUTER DECL V2 end

	// Failing
	// Class wide failing strategy 
	private FailingStrategy clazzWideFailingStrategy = Defaults.getDefaultFailingStrategy();

	private FailingStrategy clientSideLimitedFailingStrategy_longparameter = clazzWideFailingStrategy;
	private FailingStrategy serverSideLimitedFailingStrategy_longparameter = clazzWideFailingStrategy;
	private FailingStrategy bothSideLimitedFailingStrategy_longparameter = clazzWideFailingStrategy;
	private FailingStrategy clazzLevelServerSideLimitedFailingStrategy_longparameter = clazzWideFailingStrategy;
	private FailingStrategy printAndResetStatsFailingStrategy = clazzWideFailingStrategy;
	private FailingStrategy printStatsFailingStrategy = clazzWideFailingStrategy;
	// Failing end

	// CONCURRENCY CONTROL
	// Class wide concurrency control strategy 
	private ConcurrencyControlStrategy clazzWideCCStrategy = createConcurrencyControlStrategy1();

	private ConcurrencyControlStrategy clientSideLimitedCCStrategy_longparameter = createConcurrencyControlStrategy2();
	private ConcurrencyControlStrategy serverSideLimitedCCStrategy_longparameter = createConcurrencyControlStrategy3();
	private ConcurrencyControlStrategy bothSideLimitedCCStrategy_longparameter = createConcurrencyControlStrategy4();
	private ConcurrencyControlStrategy clazzLevelServerSideLimitedCCStrategy_longparameter = clazzWideCCStrategy;
	private ConcurrencyControlStrategy printAndResetStatsCCStrategy = clazzWideCCStrategy;
	private ConcurrencyControlStrategy printStatsCCStrategy = clazzWideCCStrategy;
	// CONCURRENCY CONTROL end

	public RemoteTestServiceStub(){
		discoveryMode = DiscoveryMode.AUTO;
	}

	private ServiceDescriptor manuallySetDescriptor;
	private RemoteTestService manuallySetTarget;

	public RemoteTestServiceStub(ServiceDescriptor target){
		discoveryMode = DiscoveryMode.MANUAL;
		manuallySetDescriptor = target;
		try{
			manuallySetTarget = lookup(manuallySetDescriptor);
		}catch(NoConnectionToServerException e){
			throw new IllegalStateException("Can not resolve manually set reference", e);
		}
	}

	public long clientSideLimited(long parameter){
		return clientSideLimited(parameter, (ClientSideCallContext)null);
	} //...public long clientSideLimited(long parameter)

	private long clientSideLimited(long parameter, org.distributeme.core.ClientSideCallContext diMeCallContext){
		List __fromServerSide = null;
		Exception exceptionInMethod = null;
		// This flag is used by the interceptor logic to mark a request es failed, even it is not.
		boolean diMeForceFailing = false;
		boolean abortAndFail = false;
		if (diMeCallContext == null)
			diMeCallContext = new ClientSideCallContext("clientSideLimited");
		if (discoveryMode == DiscoveryMode.MANUAL) {
			diMeCallContext.setServiceId(manuallySetDescriptor.getServiceId());
		}
		if (discoveryMode==DiscoveryMode.AUTO && diMeCallContext.getServiceId()==null)
			diMeCallContext.setServiceId(TestServiceConstants.getServiceId());

		HashMap __transportableCallContext = diMeCallContext.getTransportableCallContext();
		// Initialize interceptors
		List<ClientSideRequestInterceptor> diMeInterceptors = InterceptorRegistry.getInstance().getClientSideRequestInterceptors();
		InterceptionContext diMeInterceptionContext = new InterceptionContext();

		// Concurrency control, client side - start
		clientSideLimitedCCStrategy_longparameter.notifyClientSideCallStarted(diMeCallContext);

		try{
			ArrayList<Object> diMeParameters = new ArrayList<Object>();
			diMeParameters.add(parameter);
			diMeCallContext.setParameters(diMeParameters);
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.BEFORE_SERVICE_CALL);
			for (ClientSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.beforeServiceCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					return ((Long)interceptorResponse.getReturnValue()).longValue();
				case CONTINUE:
					break;
				case ABORT_AND_FAIL:
					abortAndFail = true;
					exceptionInMethod = new FailedByInterceptorException();
					break;
				case RETURN_AND_FAIL:
				// Force failing logic to work.
					diMeForceFailing = true;
					exceptionInMethod = new FailedByInterceptorException();
					break;
				default:
					throw new IllegalStateException("Unsupported or unexpected command from interceptor " + interceptorResponse.getCommand()+ " in phase:"+diMeInterceptionContext.getCurrentPhase());
				} //...switch
			} //...for
			// parse parameters again in case an interceptor modified them
			parameter = ((Long)diMeParameters.get(0)).longValue();
			if (!abortAndFail){
				__fromServerSide = getDelegate(diMeCallContext.getServiceId()).clientSideLimited(parameter,  __transportableCallContext);
				__transportableCallContext.putAll(((HashMap)__fromServerSide.get(1)));
				return ((Long)__fromServerSide.get(0)).longValue();
			}
		}catch(RemoteException e){
			// handle exceptions properly
			e.printStackTrace();
			notifyDelegateFailed(diMeCallContext.getServiceId());
			exceptionInMethod = e;
		}catch(NoConnectionToServerException e){
			exceptionInMethod = e;
		}finally{
			// Concurrency control, client side - end
			clientSideLimitedCCStrategy_longparameter.notifyClientSideCallFinished(diMeCallContext);
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.AFTER_SERVICE_CALL);
			if (__fromServerSide!=null){
				diMeInterceptionContext.setReturnValue(__fromServerSide.get(0));
			}
			diMeInterceptionContext.setException(exceptionInMethod);
			boolean diMeReturnOverriden = false;
			for (ClientSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.afterServiceCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					return ((Long)interceptorResponse.getReturnValue()).longValue();
				case OVERWRITE_RETURN_AND_CONTINUE:
					if (__fromServerSide == null)
						throw new AssertionError("Incorrect use of interceptor, there is no return value in this method or it is null");
					__fromServerSide.set(0, interceptorResponse.getReturnValue());
					diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
					diMeReturnOverriden = true;
					break;
				case CONTINUE:
					break;
				case ABORT_AND_FAIL:
					abortAndFail = true;
					break;
				case RETURN_AND_FAIL:
				// Force failing logic to work.
				clientSideLimitedFailingStrategy_longparameter.callFailed(diMeCallContext);
					break;
				default:
					throw new IllegalStateException("Unsupported or unexpected command from interceptor " + interceptorResponse.getCommand()+ " in phase:"+diMeInterceptionContext.getCurrentPhase());
				} //...switch
			} //...for
			// The next check for null of __fromServerSide is unneeded but for security reasons.
			if (diMeReturnOverriden && __fromServerSide!=null)
				return ((Long)__fromServerSide.get(0)).longValue();

		} //...finally
		// Failing
		if (exceptionInMethod!=null || diMeForceFailing || abortAndFail){
			FailDecision failDecision = clientSideLimitedFailingStrategy_longparameter.callFailed(diMeCallContext);
			if (failDecision.getTargetService()!=null)
				diMeCallContext.setServiceId(failDecision.getTargetService());
			switch(failDecision.getReaction()){
				case RETRY:
					return clientSideLimited(parameter, diMeCallContext.increaseCallCount());
				case RETRYONCE:
					// Only retry if its the first call
					if (!diMeCallContext.isFirstCall())
						break;
					return clientSideLimited(parameter, diMeCallContext.increaseCallCount());
				case FAIL:
				default:
				// Fail or default is to do nothing at all and let the request fail
			} //...switch(failDecision)
		}
		// fail through, if we are here, we must have had an exception before.
		if (exceptionInMethod == null)
			throw new AssertionError("Exception must have been thrown before, but it wasn't, framework error!");
		throw mapException(exceptionInMethod);
	}

	public long serverSideLimited(long parameter){
		return serverSideLimited(parameter, (ClientSideCallContext)null);
	} //...public long serverSideLimited(long parameter)

	private long serverSideLimited(long parameter, org.distributeme.core.ClientSideCallContext diMeCallContext){
		List __fromServerSide = null;
		Exception exceptionInMethod = null;
		// This flag is used by the interceptor logic to mark a request es failed, even it is not.
		boolean diMeForceFailing = false;
		boolean abortAndFail = false;
		if (diMeCallContext == null)
			diMeCallContext = new ClientSideCallContext("serverSideLimited");
		if (discoveryMode == DiscoveryMode.MANUAL) {
			diMeCallContext.setServiceId(manuallySetDescriptor.getServiceId());
		}
		if (discoveryMode==DiscoveryMode.AUTO && diMeCallContext.getServiceId()==null)
			diMeCallContext.setServiceId(TestServiceConstants.getServiceId());

		HashMap __transportableCallContext = diMeCallContext.getTransportableCallContext();
		// Initialize interceptors
		List<ClientSideRequestInterceptor> diMeInterceptors = InterceptorRegistry.getInstance().getClientSideRequestInterceptors();
		InterceptionContext diMeInterceptionContext = new InterceptionContext();

		// Concurrency control, client side - start
		serverSideLimitedCCStrategy_longparameter.notifyClientSideCallStarted(diMeCallContext);

		try{
			ArrayList<Object> diMeParameters = new ArrayList<Object>();
			diMeParameters.add(parameter);
			diMeCallContext.setParameters(diMeParameters);
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.BEFORE_SERVICE_CALL);
			for (ClientSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.beforeServiceCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					return ((Long)interceptorResponse.getReturnValue()).longValue();
				case CONTINUE:
					break;
				case ABORT_AND_FAIL:
					abortAndFail = true;
					exceptionInMethod = new FailedByInterceptorException();
					break;
				case RETURN_AND_FAIL:
				// Force failing logic to work.
					diMeForceFailing = true;
					exceptionInMethod = new FailedByInterceptorException();
					break;
				default:
					throw new IllegalStateException("Unsupported or unexpected command from interceptor " + interceptorResponse.getCommand()+ " in phase:"+diMeInterceptionContext.getCurrentPhase());
				} //...switch
			} //...for
			// parse parameters again in case an interceptor modified them
			parameter = ((Long)diMeParameters.get(0)).longValue();
			if (!abortAndFail){
				__fromServerSide = getDelegate(diMeCallContext.getServiceId()).serverSideLimited(parameter,  __transportableCallContext);
				__transportableCallContext.putAll(((HashMap)__fromServerSide.get(1)));
				return ((Long)__fromServerSide.get(0)).longValue();
			}
		}catch(RemoteException e){
			// handle exceptions properly
			e.printStackTrace();
			notifyDelegateFailed(diMeCallContext.getServiceId());
			exceptionInMethod = e;
		}catch(NoConnectionToServerException e){
			exceptionInMethod = e;
		}finally{
			// Concurrency control, client side - end
			serverSideLimitedCCStrategy_longparameter.notifyClientSideCallFinished(diMeCallContext);
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.AFTER_SERVICE_CALL);
			if (__fromServerSide!=null){
				diMeInterceptionContext.setReturnValue(__fromServerSide.get(0));
			}
			diMeInterceptionContext.setException(exceptionInMethod);
			boolean diMeReturnOverriden = false;
			for (ClientSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.afterServiceCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					return ((Long)interceptorResponse.getReturnValue()).longValue();
				case OVERWRITE_RETURN_AND_CONTINUE:
					if (__fromServerSide == null)
						throw new AssertionError("Incorrect use of interceptor, there is no return value in this method or it is null");
					__fromServerSide.set(0, interceptorResponse.getReturnValue());
					diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
					diMeReturnOverriden = true;
					break;
				case CONTINUE:
					break;
				case ABORT_AND_FAIL:
					abortAndFail = true;
					break;
				case RETURN_AND_FAIL:
				// Force failing logic to work.
				serverSideLimitedFailingStrategy_longparameter.callFailed(diMeCallContext);
					break;
				default:
					throw new IllegalStateException("Unsupported or unexpected command from interceptor " + interceptorResponse.getCommand()+ " in phase:"+diMeInterceptionContext.getCurrentPhase());
				} //...switch
			} //...for
			// The next check for null of __fromServerSide is unneeded but for security reasons.
			if (diMeReturnOverriden && __fromServerSide!=null)
				return ((Long)__fromServerSide.get(0)).longValue();

		} //...finally
		// Failing
		if (exceptionInMethod!=null || diMeForceFailing || abortAndFail){
			FailDecision failDecision = serverSideLimitedFailingStrategy_longparameter.callFailed(diMeCallContext);
			if (failDecision.getTargetService()!=null)
				diMeCallContext.setServiceId(failDecision.getTargetService());
			switch(failDecision.getReaction()){
				case RETRY:
					return serverSideLimited(parameter, diMeCallContext.increaseCallCount());
				case RETRYONCE:
					// Only retry if its the first call
					if (!diMeCallContext.isFirstCall())
						break;
					return serverSideLimited(parameter, diMeCallContext.increaseCallCount());
				case FAIL:
				default:
				// Fail or default is to do nothing at all and let the request fail
			} //...switch(failDecision)
		}
		// fail through, if we are here, we must have had an exception before.
		if (exceptionInMethod == null)
			throw new AssertionError("Exception must have been thrown before, but it wasn't, framework error!");
		throw mapException(exceptionInMethod);
	}

	public long bothSideLimited(long parameter){
		return bothSideLimited(parameter, (ClientSideCallContext)null);
	} //...public long bothSideLimited(long parameter)

	private long bothSideLimited(long parameter, org.distributeme.core.ClientSideCallContext diMeCallContext){
		List __fromServerSide = null;
		Exception exceptionInMethod = null;
		// This flag is used by the interceptor logic to mark a request es failed, even it is not.
		boolean diMeForceFailing = false;
		boolean abortAndFail = false;
		if (diMeCallContext == null)
			diMeCallContext = new ClientSideCallContext("bothSideLimited");
		if (discoveryMode == DiscoveryMode.MANUAL) {
			diMeCallContext.setServiceId(manuallySetDescriptor.getServiceId());
		}
		if (discoveryMode==DiscoveryMode.AUTO && diMeCallContext.getServiceId()==null)
			diMeCallContext.setServiceId(TestServiceConstants.getServiceId());

		HashMap __transportableCallContext = diMeCallContext.getTransportableCallContext();
		// Initialize interceptors
		List<ClientSideRequestInterceptor> diMeInterceptors = InterceptorRegistry.getInstance().getClientSideRequestInterceptors();
		InterceptionContext diMeInterceptionContext = new InterceptionContext();

		// Concurrency control, client side - start
		bothSideLimitedCCStrategy_longparameter.notifyClientSideCallStarted(diMeCallContext);

		try{
			ArrayList<Object> diMeParameters = new ArrayList<Object>();
			diMeParameters.add(parameter);
			diMeCallContext.setParameters(diMeParameters);
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.BEFORE_SERVICE_CALL);
			for (ClientSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.beforeServiceCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					return ((Long)interceptorResponse.getReturnValue()).longValue();
				case CONTINUE:
					break;
				case ABORT_AND_FAIL:
					abortAndFail = true;
					exceptionInMethod = new FailedByInterceptorException();
					break;
				case RETURN_AND_FAIL:
				// Force failing logic to work.
					diMeForceFailing = true;
					exceptionInMethod = new FailedByInterceptorException();
					break;
				default:
					throw new IllegalStateException("Unsupported or unexpected command from interceptor " + interceptorResponse.getCommand()+ " in phase:"+diMeInterceptionContext.getCurrentPhase());
				} //...switch
			} //...for
			// parse parameters again in case an interceptor modified them
			parameter = ((Long)diMeParameters.get(0)).longValue();
			if (!abortAndFail){
				__fromServerSide = getDelegate(diMeCallContext.getServiceId()).bothSideLimited(parameter,  __transportableCallContext);
				__transportableCallContext.putAll(((HashMap)__fromServerSide.get(1)));
				return ((Long)__fromServerSide.get(0)).longValue();
			}
		}catch(RemoteException e){
			// handle exceptions properly
			e.printStackTrace();
			notifyDelegateFailed(diMeCallContext.getServiceId());
			exceptionInMethod = e;
		}catch(NoConnectionToServerException e){
			exceptionInMethod = e;
		}finally{
			// Concurrency control, client side - end
			bothSideLimitedCCStrategy_longparameter.notifyClientSideCallFinished(diMeCallContext);
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.AFTER_SERVICE_CALL);
			if (__fromServerSide!=null){
				diMeInterceptionContext.setReturnValue(__fromServerSide.get(0));
			}
			diMeInterceptionContext.setException(exceptionInMethod);
			boolean diMeReturnOverriden = false;
			for (ClientSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.afterServiceCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					return ((Long)interceptorResponse.getReturnValue()).longValue();
				case OVERWRITE_RETURN_AND_CONTINUE:
					if (__fromServerSide == null)
						throw new AssertionError("Incorrect use of interceptor, there is no return value in this method or it is null");
					__fromServerSide.set(0, interceptorResponse.getReturnValue());
					diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
					diMeReturnOverriden = true;
					break;
				case CONTINUE:
					break;
				case ABORT_AND_FAIL:
					abortAndFail = true;
					break;
				case RETURN_AND_FAIL:
				// Force failing logic to work.
				bothSideLimitedFailingStrategy_longparameter.callFailed(diMeCallContext);
					break;
				default:
					throw new IllegalStateException("Unsupported or unexpected command from interceptor " + interceptorResponse.getCommand()+ " in phase:"+diMeInterceptionContext.getCurrentPhase());
				} //...switch
			} //...for
			// The next check for null of __fromServerSide is unneeded but for security reasons.
			if (diMeReturnOverriden && __fromServerSide!=null)
				return ((Long)__fromServerSide.get(0)).longValue();

		} //...finally
		// Failing
		if (exceptionInMethod!=null || diMeForceFailing || abortAndFail){
			FailDecision failDecision = bothSideLimitedFailingStrategy_longparameter.callFailed(diMeCallContext);
			if (failDecision.getTargetService()!=null)
				diMeCallContext.setServiceId(failDecision.getTargetService());
			switch(failDecision.getReaction()){
				case RETRY:
					return bothSideLimited(parameter, diMeCallContext.increaseCallCount());
				case RETRYONCE:
					// Only retry if its the first call
					if (!diMeCallContext.isFirstCall())
						break;
					return bothSideLimited(parameter, diMeCallContext.increaseCallCount());
				case FAIL:
				default:
				// Fail or default is to do nothing at all and let the request fail
			} //...switch(failDecision)
		}
		// fail through, if we are here, we must have had an exception before.
		if (exceptionInMethod == null)
			throw new AssertionError("Exception must have been thrown before, but it wasn't, framework error!");
		throw mapException(exceptionInMethod);
	}

	public long clazzLevelServerSideLimited(long parameter){
		return clazzLevelServerSideLimited(parameter, (ClientSideCallContext)null);
	} //...public long clazzLevelServerSideLimited(long parameter)

	private long clazzLevelServerSideLimited(long parameter, org.distributeme.core.ClientSideCallContext diMeCallContext){
		List __fromServerSide = null;
		Exception exceptionInMethod = null;
		// This flag is used by the interceptor logic to mark a request es failed, even it is not.
		boolean diMeForceFailing = false;
		boolean abortAndFail = false;
		if (diMeCallContext == null)
			diMeCallContext = new ClientSideCallContext("clazzLevelServerSideLimited");
		if (discoveryMode == DiscoveryMode.MANUAL) {
			diMeCallContext.setServiceId(manuallySetDescriptor.getServiceId());
		}
		if (discoveryMode==DiscoveryMode.AUTO && diMeCallContext.getServiceId()==null)
			diMeCallContext.setServiceId(TestServiceConstants.getServiceId());

		HashMap __transportableCallContext = diMeCallContext.getTransportableCallContext();
		// Initialize interceptors
		List<ClientSideRequestInterceptor> diMeInterceptors = InterceptorRegistry.getInstance().getClientSideRequestInterceptors();
		InterceptionContext diMeInterceptionContext = new InterceptionContext();

		// Concurrency control, client side - start
		clazzLevelServerSideLimitedCCStrategy_longparameter.notifyClientSideCallStarted(diMeCallContext);

		try{
			ArrayList<Object> diMeParameters = new ArrayList<Object>();
			diMeParameters.add(parameter);
			diMeCallContext.setParameters(diMeParameters);
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.BEFORE_SERVICE_CALL);
			for (ClientSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.beforeServiceCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					return ((Long)interceptorResponse.getReturnValue()).longValue();
				case CONTINUE:
					break;
				case ABORT_AND_FAIL:
					abortAndFail = true;
					exceptionInMethod = new FailedByInterceptorException();
					break;
				case RETURN_AND_FAIL:
				// Force failing logic to work.
					diMeForceFailing = true;
					exceptionInMethod = new FailedByInterceptorException();
					break;
				default:
					throw new IllegalStateException("Unsupported or unexpected command from interceptor " + interceptorResponse.getCommand()+ " in phase:"+diMeInterceptionContext.getCurrentPhase());
				} //...switch
			} //...for
			// parse parameters again in case an interceptor modified them
			parameter = ((Long)diMeParameters.get(0)).longValue();
			if (!abortAndFail){
				__fromServerSide = getDelegate(diMeCallContext.getServiceId()).clazzLevelServerSideLimited(parameter,  __transportableCallContext);
				__transportableCallContext.putAll(((HashMap)__fromServerSide.get(1)));
				return ((Long)__fromServerSide.get(0)).longValue();
			}
		}catch(RemoteException e){
			// handle exceptions properly
			e.printStackTrace();
			notifyDelegateFailed(diMeCallContext.getServiceId());
			exceptionInMethod = e;
		}catch(NoConnectionToServerException e){
			exceptionInMethod = e;
		}finally{
			// Concurrency control, client side - end
			clazzLevelServerSideLimitedCCStrategy_longparameter.notifyClientSideCallFinished(diMeCallContext);
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.AFTER_SERVICE_CALL);
			if (__fromServerSide!=null){
				diMeInterceptionContext.setReturnValue(__fromServerSide.get(0));
			}
			diMeInterceptionContext.setException(exceptionInMethod);
			boolean diMeReturnOverriden = false;
			for (ClientSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.afterServiceCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					return ((Long)interceptorResponse.getReturnValue()).longValue();
				case OVERWRITE_RETURN_AND_CONTINUE:
					if (__fromServerSide == null)
						throw new AssertionError("Incorrect use of interceptor, there is no return value in this method or it is null");
					__fromServerSide.set(0, interceptorResponse.getReturnValue());
					diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
					diMeReturnOverriden = true;
					break;
				case CONTINUE:
					break;
				case ABORT_AND_FAIL:
					abortAndFail = true;
					break;
				case RETURN_AND_FAIL:
				// Force failing logic to work.
				clazzLevelServerSideLimitedFailingStrategy_longparameter.callFailed(diMeCallContext);
					break;
				default:
					throw new IllegalStateException("Unsupported or unexpected command from interceptor " + interceptorResponse.getCommand()+ " in phase:"+diMeInterceptionContext.getCurrentPhase());
				} //...switch
			} //...for
			// The next check for null of __fromServerSide is unneeded but for security reasons.
			if (diMeReturnOverriden && __fromServerSide!=null)
				return ((Long)__fromServerSide.get(0)).longValue();

		} //...finally
		// Failing
		if (exceptionInMethod!=null || diMeForceFailing || abortAndFail){
			FailDecision failDecision = clazzLevelServerSideLimitedFailingStrategy_longparameter.callFailed(diMeCallContext);
			if (failDecision.getTargetService()!=null)
				diMeCallContext.setServiceId(failDecision.getTargetService());
			switch(failDecision.getReaction()){
				case RETRY:
					return clazzLevelServerSideLimited(parameter, diMeCallContext.increaseCallCount());
				case RETRYONCE:
					// Only retry if its the first call
					if (!diMeCallContext.isFirstCall())
						break;
					return clazzLevelServerSideLimited(parameter, diMeCallContext.increaseCallCount());
				case FAIL:
				default:
				// Fail or default is to do nothing at all and let the request fail
			} //...switch(failDecision)
		}
		// fail through, if we are here, we must have had an exception before.
		if (exceptionInMethod == null)
			throw new AssertionError("Exception must have been thrown before, but it wasn't, framework error!");
		throw mapException(exceptionInMethod);
	}

	public void printAndResetStats(){
		printAndResetStats((ClientSideCallContext)null);
	} //...public void printAndResetStats()

	private void printAndResetStats(org.distributeme.core.ClientSideCallContext diMeCallContext){
		List __fromServerSide = null;
		Exception exceptionInMethod = null;
		// This flag is used by the interceptor logic to mark a request es failed, even it is not.
		boolean diMeForceFailing = false;
		boolean abortAndFail = false;
		if (diMeCallContext == null)
			diMeCallContext = new ClientSideCallContext("printAndResetStats");
		if (discoveryMode == DiscoveryMode.MANUAL) {
			diMeCallContext.setServiceId(manuallySetDescriptor.getServiceId());
		}
		if (discoveryMode==DiscoveryMode.AUTO && diMeCallContext.getServiceId()==null)
			diMeCallContext.setServiceId(TestServiceConstants.getServiceId());

		HashMap __transportableCallContext = diMeCallContext.getTransportableCallContext();
		// Initialize interceptors
		List<ClientSideRequestInterceptor> diMeInterceptors = InterceptorRegistry.getInstance().getClientSideRequestInterceptors();
		InterceptionContext diMeInterceptionContext = new InterceptionContext();

		// Concurrency control, client side - start
		printAndResetStatsCCStrategy.notifyClientSideCallStarted(diMeCallContext);

		try{
			ArrayList<Object> diMeParameters = new ArrayList<Object>();
			diMeCallContext.setParameters(diMeParameters);
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.BEFORE_SERVICE_CALL);
			for (ClientSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.beforeServiceCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					return;
				case CONTINUE:
					break;
				case ABORT_AND_FAIL:
					abortAndFail = true;
					exceptionInMethod = new FailedByInterceptorException();
					break;
				case RETURN_AND_FAIL:
				// Force failing logic to work.
					diMeForceFailing = true;
					exceptionInMethod = new FailedByInterceptorException();
					break;
				default:
					throw new IllegalStateException("Unsupported or unexpected command from interceptor " + interceptorResponse.getCommand()+ " in phase:"+diMeInterceptionContext.getCurrentPhase());
				} //...switch
			} //...for
			// parse parameters again in case an interceptor modified them
			if (!abortAndFail){
				__fromServerSide = getDelegate(diMeCallContext.getServiceId()).printAndResetStats( __transportableCallContext);
				__transportableCallContext.putAll(((HashMap)__fromServerSide.get(1)));
				return;
			}
		}catch(RemoteException e){
			// handle exceptions properly
			e.printStackTrace();
			notifyDelegateFailed(diMeCallContext.getServiceId());
			exceptionInMethod = e;
		}catch(NoConnectionToServerException e){
			exceptionInMethod = e;
		}finally{
			// Concurrency control, client side - end
			printAndResetStatsCCStrategy.notifyClientSideCallFinished(diMeCallContext);
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.AFTER_SERVICE_CALL);
			if (__fromServerSide!=null){
				diMeInterceptionContext.setReturnValue(__fromServerSide.get(0));
			}
			diMeInterceptionContext.setException(exceptionInMethod);
			boolean diMeReturnOverriden = false;
			for (ClientSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.afterServiceCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					return;
				case CONTINUE:
					break;
				case ABORT_AND_FAIL:
					abortAndFail = true;
					break;
				case RETURN_AND_FAIL:
				// Force failing logic to work.
				printAndResetStatsFailingStrategy.callFailed(diMeCallContext);
					break;
				default:
					throw new IllegalStateException("Unsupported or unexpected command from interceptor " + interceptorResponse.getCommand()+ " in phase:"+diMeInterceptionContext.getCurrentPhase());
				} //...switch
			} //...for

		} //...finally
		// Failing
		if (exceptionInMethod!=null || diMeForceFailing || abortAndFail){
			FailDecision failDecision = printAndResetStatsFailingStrategy.callFailed(diMeCallContext);
			if (failDecision.getTargetService()!=null)
				diMeCallContext.setServiceId(failDecision.getTargetService());
			switch(failDecision.getReaction()){
				case RETRY:
					printAndResetStats(diMeCallContext.increaseCallCount());
					return;
				case RETRYONCE:
					// Only retry if its the first call
					if (!diMeCallContext.isFirstCall())
						break;
					printAndResetStats(diMeCallContext.increaseCallCount());
					return;
				case FAIL:
				default:
				// Fail or default is to do nothing at all and let the request fail
			} //...switch(failDecision)
		}
		// fail through, if we are here, we must have had an exception before.
		if (exceptionInMethod == null)
			throw new AssertionError("Exception must have been thrown before, but it wasn't, framework error!");
		throw mapException(exceptionInMethod);
	}

	public void printStats(){
		printStats((ClientSideCallContext)null);
	} //...public void printStats()

	private void printStats(org.distributeme.core.ClientSideCallContext diMeCallContext){
		List __fromServerSide = null;
		Exception exceptionInMethod = null;
		// This flag is used by the interceptor logic to mark a request es failed, even it is not.
		boolean diMeForceFailing = false;
		boolean abortAndFail = false;
		if (diMeCallContext == null)
			diMeCallContext = new ClientSideCallContext("printStats");
		if (discoveryMode == DiscoveryMode.MANUAL) {
			diMeCallContext.setServiceId(manuallySetDescriptor.getServiceId());
		}
		if (discoveryMode==DiscoveryMode.AUTO && diMeCallContext.getServiceId()==null)
			diMeCallContext.setServiceId(TestServiceConstants.getServiceId());

		HashMap __transportableCallContext = diMeCallContext.getTransportableCallContext();
		// Initialize interceptors
		List<ClientSideRequestInterceptor> diMeInterceptors = InterceptorRegistry.getInstance().getClientSideRequestInterceptors();
		InterceptionContext diMeInterceptionContext = new InterceptionContext();

		// Concurrency control, client side - start
		printStatsCCStrategy.notifyClientSideCallStarted(diMeCallContext);

		try{
			ArrayList<Object> diMeParameters = new ArrayList<Object>();
			diMeCallContext.setParameters(diMeParameters);
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.BEFORE_SERVICE_CALL);
			for (ClientSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.beforeServiceCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					return;
				case CONTINUE:
					break;
				case ABORT_AND_FAIL:
					abortAndFail = true;
					exceptionInMethod = new FailedByInterceptorException();
					break;
				case RETURN_AND_FAIL:
				// Force failing logic to work.
					diMeForceFailing = true;
					exceptionInMethod = new FailedByInterceptorException();
					break;
				default:
					throw new IllegalStateException("Unsupported or unexpected command from interceptor " + interceptorResponse.getCommand()+ " in phase:"+diMeInterceptionContext.getCurrentPhase());
				} //...switch
			} //...for
			// parse parameters again in case an interceptor modified them
			if (!abortAndFail){
				__fromServerSide = getDelegate(diMeCallContext.getServiceId()).printStats( __transportableCallContext);
				__transportableCallContext.putAll(((HashMap)__fromServerSide.get(1)));
				return;
			}
		}catch(RemoteException e){
			// handle exceptions properly
			e.printStackTrace();
			notifyDelegateFailed(diMeCallContext.getServiceId());
			exceptionInMethod = e;
		}catch(NoConnectionToServerException e){
			exceptionInMethod = e;
		}finally{
			// Concurrency control, client side - end
			printStatsCCStrategy.notifyClientSideCallFinished(diMeCallContext);
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.AFTER_SERVICE_CALL);
			if (__fromServerSide!=null){
				diMeInterceptionContext.setReturnValue(__fromServerSide.get(0));
			}
			diMeInterceptionContext.setException(exceptionInMethod);
			boolean diMeReturnOverriden = false;
			for (ClientSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.afterServiceCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					return;
				case CONTINUE:
					break;
				case ABORT_AND_FAIL:
					abortAndFail = true;
					break;
				case RETURN_AND_FAIL:
				// Force failing logic to work.
				printStatsFailingStrategy.callFailed(diMeCallContext);
					break;
				default:
					throw new IllegalStateException("Unsupported or unexpected command from interceptor " + interceptorResponse.getCommand()+ " in phase:"+diMeInterceptionContext.getCurrentPhase());
				} //...switch
			} //...for

		} //...finally
		// Failing
		if (exceptionInMethod!=null || diMeForceFailing || abortAndFail){
			FailDecision failDecision = printStatsFailingStrategy.callFailed(diMeCallContext);
			if (failDecision.getTargetService()!=null)
				diMeCallContext.setServiceId(failDecision.getTargetService());
			switch(failDecision.getReaction()){
				case RETRY:
					printStats(diMeCallContext.increaseCallCount());
					return;
				case RETRYONCE:
					// Only retry if its the first call
					if (!diMeCallContext.isFirstCall())
						break;
					printStats(diMeCallContext.increaseCallCount());
					return;
				case FAIL:
				default:
				// Fail or default is to do nothing at all and let the request fail
			} //...switch(failDecision)
		}
		// fail through, if we are here, we must have had an exception before.
		if (exceptionInMethod == null)
			throw new AssertionError("Exception must have been thrown before, but it wasn't, framework error!");
		throw mapException(exceptionInMethod);
	}

	// according to findbugs this method is never used, so we remove it for now reduce warnings.

	//private void notifyDelegateFailed(){
		//notifyDelegateFailed(TestServiceConstants.getServiceId());
	//}

	private void notifyDelegateFailed(String serviceId){
		if (discoveryMode==DiscoveryMode.MANUAL){
			manuallySetTarget = null;
			return;
		}
		if (serviceId!=null)
			delegates.remove(serviceId);
	} //...notifyDelegateFailed

	private RemoteTestService getDelegate() throws NoConnectionToServerException{
		if (discoveryMode==DiscoveryMode.MANUAL){
			if (manuallySetTarget!=null)
				return manuallySetTarget;
			manuallySetTarget = lookup(manuallySetDescriptor);
			return manuallySetTarget;
		} //...if (mode==MANUAL)
		return getDelegate(TestServiceConstants.getServiceId());
	}

	private RemoteTestService getDelegate(String serviceId) throws NoConnectionToServerException{
		// if no serviceId is provided, fallback to default resolve with manual mode
		if (serviceId==null || discoveryMode==DiscoveryMode.MANUAL)
			return getDelegate();
		RemoteTestService delegate = delegates.get(serviceId);
		if (delegate==null){
			try{
				delegate = lookup(serviceId);
				RemoteTestService existingDelegate = delegates.putIfAbsent(serviceId, delegate);
				if (existingDelegate!=null)
					delegate = existingDelegate;
			}catch(Exception e){
			// //TODO - generate and throw typed exception.
				throw new NoConnectionToServerException("Couldn't lookup delegate because: "+e.getMessage()+" at "+RegistryUtil.describeRegistry(), e);
			}//try
		} //...first if (del==null) 
		return delegate;
	} //...fun

	private RemoteTestService lookup(String serviceId) throws NoConnectionToServerException{
		// //first we need to lookup target host.
		ServiceDescriptor toLookup = new ServiceDescriptor(Protocol.RMI, serviceId);
		ServiceDescriptor targetService = RegistryUtil.resolve(toLookup);
		if (targetService==null)
			throw new RuntimeException("Can't resolve host for an instance of "+TestServiceConstants.getServiceId());
		Registry registry = null;
		try{
			registry = LocateRegistry.getRegistry(targetService.getHost(), targetService.getPort());
		}catch(Exception e){
			System.err.println("lookup - couldn't obtain rmi registry on "+targetService+", aborting lookup"); e.printStackTrace();
			throw new NoConnectionToServerException("Can't resolve rmi registry for an instance of "+TestServiceConstants.getServiceId());
		}
		try{
			return (RemoteTestService) registry.lookup(serviceId);
		}catch(RemoteException e){
			throw new NoConnectionToServerException("Can't lookup service in the target rmi registry for an instance of "+serviceId, e);
		}catch(NotBoundException e){
			throw new NoConnectionToServerException("Can't lookup service in the target rmi registry for an instance of "+serviceId, e);
		}
	}

	private RemoteTestService lookup(ServiceDescriptor serviceDescriptor) throws NoConnectionToServerException{
		Registry registry = null;
		try{
			registry = LocateRegistry.getRegistry(serviceDescriptor.getHost(), serviceDescriptor.getPort());
		}catch(Exception e){
			System.err.println("lookup - couldn't obtain rmi registry on "+serviceDescriptor+", aborting lookup"); e.printStackTrace();
			throw new NoConnectionToServerException("Can't resolve rmi registry for "+serviceDescriptor);
		}
		try{
			RemoteTestService ret = (RemoteTestService) registry.lookup(serviceDescriptor.getServiceId());
			return ret;
		}catch(RemoteException e){
			throw new NoConnectionToServerException("Can't lookup service in the target rmi registry for an instance of "+serviceDescriptor, e);
		}catch(NotBoundException e){
			throw new NoConnectionToServerException("Can't lookup service in the target rmi registry for an instance of "+serviceDescriptor, e);
		}
	}

	private DistributemeRuntimeException mapException(Exception in){
		if (in instanceof DistributemeRuntimeException)
			return (DistributemeRuntimeException) in;
		if (in instanceof RemoteException)
			return new ServiceUnavailableException ("Service unavailable due to rmi failure: "+in.getMessage(), in);
		return new ServiceUnavailableException("Unexpected exception: "+in.getMessage()+" " + in.getClass().getName(), in);
	}
	private ConcurrencyControlStrategy createConcurrencyControlStrategy1(){
		ConcurrencyControlStrategy strat = new org.distributeme.core.concurrencycontrol.ConstantBasedConcurrencyControlStrategy();
		strat.customize("0,5");
		return strat;
	}
	private ConcurrencyControlStrategy createConcurrencyControlStrategy2(){
		ConcurrencyControlStrategy strat = new org.distributeme.core.concurrencycontrol.ConstantBasedConcurrencyControlStrategy();
		strat.customize("3,0");
		return strat;
	}
	private ConcurrencyControlStrategy createConcurrencyControlStrategy3(){
		ConcurrencyControlStrategy strat = new org.distributeme.core.concurrencycontrol.ConfigurationBasedConcurrencyControlStrategy();
		strat.customize("ccconfig");
		return strat;
	}
	private ConcurrencyControlStrategy createConcurrencyControlStrategy4(){
		ConcurrencyControlStrategy strat = new org.distributeme.core.concurrencycontrol.ConstantBasedConcurrencyControlStrategy();
		strat.customize("4,5");
		return strat;
	}
}
