package org.distributeme.test.interception.generated;
//CHECKSTYLE:OFF

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.List;
import java.util.Map;
import java.util.ArrayList;
import org.distributeme.core.Verbosity;
import org.distributeme.core.Defaults;
import org.distributeme.core.ServerSideCallContext;
import org.distributeme.core.interceptor.ServerSideRequestInterceptor;
import org.distributeme.core.interceptor.InterceptorResponse;
import org.distributeme.core.interceptor.InterceptionContext;
import org.distributeme.core.interceptor.InterceptorRegistry;
import org.distributeme.core.interceptor.InterceptionPhase;
import org.distributeme.core.concurrencycontrol.ConcurrencyControlStrategy;
import net.anotheria.moskito.core.dynamic.MoskitoInvokationProxy;
import net.anotheria.moskito.core.logging.DefaultStatsLogger;
import net.anotheria.moskito.core.logging.IntervalStatsLogger;
import net.anotheria.moskito.core.logging.SLF4JLogOutput;
import net.anotheria.moskito.core.stats.DefaultIntervals;
import net.anotheria.moskito.core.predefined.ServiceStatsCallHandler;
import net.anotheria.moskito.core.predefined.ServiceStatsFactory;
import net.anotheria.moskito.core.registry.IProducerRegistryAPI;
import net.anotheria.moskito.core.registry.ProducerRegistryAPIFactory;
import net.anotheria.moskito.core.producers.IStatsProducer;

// Generated by org.distributeme.generator.SkeletonGenerator
public class RemoteTestServiceSkeleton implements RemoteTestService {

	private static Logger log = LoggerFactory.getLogger(RemoteTestServiceSkeleton.class);

	private org.distributeme.test.interception.TestService implementation;

	private long lastAccess;
	private long created;

	// CONCURRENCY CONTROL
	// Class wide concurrency control strategy 
	private ConcurrencyControlStrategy clazzWideCCStrategy = Defaults.getDefaultConcurrencyControlStrategy();

	private ConcurrencyControlStrategy callByValueCCStrategy_javautilMapparameters = clazzWideCCStrategy;
	private ConcurrencyControlStrategy callByReferenceCCStrategy_javautilMapparameters = clazzWideCCStrategy;
	private ConcurrencyControlStrategy sumCCStrategy_inta_intb = clazzWideCCStrategy;
	private ConcurrencyControlStrategy modifiedSumCCStrategy_inta_intb = clazzWideCCStrategy;
	private ConcurrencyControlStrategy modifiedSumParametersCCStrategy_inta_intb = clazzWideCCStrategy;
	private ConcurrencyControlStrategy returnStringCCStrategy = clazzWideCCStrategy;
	private ConcurrencyControlStrategy returnStringCaughtInClientCCStrategy = clazzWideCCStrategy;
	private ConcurrencyControlStrategy sleepingCallCCStrategy_longtimeToSleep = clazzWideCCStrategy;
	// CONCURRENCY CONTROL end

	public RemoteTestServiceSkeleton(){
		this(null);
	}

	public RemoteTestServiceSkeleton(org.distributeme.test.interception.TestService anImplementation){
		created = System.currentTimeMillis();
		MoskitoInvokationProxy proxy = new MoskitoInvokationProxy(
			anImplementation,
			new ServiceStatsCallHandler(),
			new ServiceStatsFactory(),
			"TestService", 
			"service",
			"default",
			org.distributeme.test.interception.TestService.class, net.anotheria.anoprise.metafactory.Service.class
		);
		implementation = (org.distributeme.test.interception.TestService) proxy.createProxy();
		// add moskito logger
		new DefaultStatsLogger(proxy.getProducer(), new SLF4JLogOutput(LoggerFactory.getLogger("moskito.custom.default")));
		new IntervalStatsLogger(proxy.getProducer(), DefaultIntervals.FIVE_MINUTES, new SLF4JLogOutput(LoggerFactory.getLogger("moskito.custom.5m")));
		new IntervalStatsLogger(proxy.getProducer(), DefaultIntervals.FIFTEEN_MINUTES, new SLF4JLogOutput(LoggerFactory.getLogger("moskito.custom.15m")));
		new IntervalStatsLogger(proxy.getProducer(), DefaultIntervals.ONE_HOUR, new SLF4JLogOutput(LoggerFactory.getLogger("moskito.custom.1h")));
		new IntervalStatsLogger(proxy.getProducer(), DefaultIntervals.ONE_DAY, new SLF4JLogOutput(LoggerFactory.getLogger("moskito.custom.1d")));
		//end moskito logger
		// //ADD LOGGING FOR ALL BUILTIN PRODUCERS
		IProducerRegistryAPI api = new ProducerRegistryAPIFactory().createProducerRegistryAPI();
		List<IStatsProducer> stats = api.getAllProducersBySubsystem("builtin");
		for (IStatsProducer producer : stats){
			new DefaultStatsLogger(producer, new SLF4JLogOutput(LoggerFactory.getLogger("moskito.bi.default")));
			new IntervalStatsLogger(producer, DefaultIntervals.FIVE_MINUTES, new SLF4JLogOutput(LoggerFactory.getLogger("moskito.bi.5m")));
			new IntervalStatsLogger(producer, DefaultIntervals.FIFTEEN_MINUTES, new SLF4JLogOutput(LoggerFactory.getLogger("moskito.bi.15m")));
			new IntervalStatsLogger(producer, DefaultIntervals.ONE_HOUR, new SLF4JLogOutput(LoggerFactory.getLogger("moskito.bi.1h")));
			new IntervalStatsLogger(producer, DefaultIntervals.ONE_DAY, new SLF4JLogOutput(LoggerFactory.getLogger("moskito.bi.1d")));
		}
	}

	public List callByValue(java.util.Map<java.lang.String,java.lang.String> parameters, Map<?,?> __transportableCallContext){
		lastAccess = System.currentTimeMillis();
		ServerSideCallContext diMeCallContext = new ServerSideCallContext("callByValue", __transportableCallContext);
		diMeCallContext.setServiceId(TestServiceConstants.getServiceId());
		ArrayList<Object> diMeParameters = new ArrayList<Object>();
		diMeParameters.add(parameters);
		diMeCallContext.setParameters(diMeParameters);
		InterceptionContext diMeInterceptionContext = new InterceptionContext();
		// Initialize interceptors
		List<ServerSideRequestInterceptor> diMeInterceptors = InterceptorRegistry.getInstance().getServerSideRequestInterceptors();

		ArrayList __return = new ArrayList();

		diMeInterceptionContext.setCurrentPhase(InterceptionPhase.BEFORE_SERVANT_CALL);
		for (ServerSideRequestInterceptor interceptor : diMeInterceptors){
			InterceptorResponse interceptorResponse = interceptor.beforeServantCall(diMeCallContext, diMeInterceptionContext);
			switch(interceptorResponse.getCommand()){
			case ABORT:
				if (interceptorResponse.getException() instanceof RuntimeException)
					throw (RuntimeException) interceptorResponse.getException();
				throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
			case RETURN:
				__return.set(0, interceptorResponse.getReturnValue());
				diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
				break;
			case OVERWRITE_RETURN_AND_CONTINUE:
				__return.set(0, interceptorResponse.getReturnValue());
				diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
				break;
			case CONTINUE:
				break;
			} //...switch
		} //...for
		// Concurrency control, server side - 
		callByValueCCStrategy_javautilMapparameters.notifyServerSideCallStarted(diMeCallContext);

		try{
			implementation.callByValue(parameters);
			__return.add(org.distributeme.core.util.VoidMarker.VOID);
			__return.add(diMeCallContext.getTransportableCallContext());
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.AFTER_SERVANT_CALL);
			for (ServerSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.afterServantCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					__return.set(0, interceptorResponse.getReturnValue());
					diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
					break;
				case OVERWRITE_RETURN_AND_CONTINUE:
					__return.set(0, interceptorResponse.getReturnValue());
					diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
					break;
				case CONTINUE:
					break;
				} //...switch
			} //...for
			return __return;
		}finally{
			callByValueCCStrategy_javautilMapparameters.notifyServerSideCallFinished(diMeCallContext);
		}
	}

	public List callByReference(java.util.Map<java.lang.String,java.lang.String> parameters, Map<?,?> __transportableCallContext){
		lastAccess = System.currentTimeMillis();
		ServerSideCallContext diMeCallContext = new ServerSideCallContext("callByReference", __transportableCallContext);
		diMeCallContext.setServiceId(TestServiceConstants.getServiceId());
		ArrayList<Object> diMeParameters = new ArrayList<Object>();
		diMeParameters.add(parameters);
		diMeCallContext.setParameters(diMeParameters);
		InterceptionContext diMeInterceptionContext = new InterceptionContext();
		// Initialize interceptors
		List<ServerSideRequestInterceptor> diMeInterceptors = InterceptorRegistry.getInstance().getServerSideRequestInterceptors();

		ArrayList __return = new ArrayList();

		diMeInterceptionContext.setCurrentPhase(InterceptionPhase.BEFORE_SERVANT_CALL);
		for (ServerSideRequestInterceptor interceptor : diMeInterceptors){
			InterceptorResponse interceptorResponse = interceptor.beforeServantCall(diMeCallContext, diMeInterceptionContext);
			switch(interceptorResponse.getCommand()){
			case ABORT:
				if (interceptorResponse.getException() instanceof RuntimeException)
					throw (RuntimeException) interceptorResponse.getException();
				throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
			case RETURN:
				__return.set(0, interceptorResponse.getReturnValue());
				diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
				break;
			case OVERWRITE_RETURN_AND_CONTINUE:
				__return.set(0, interceptorResponse.getReturnValue());
				diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
				break;
			case CONTINUE:
				break;
			} //...switch
		} //...for
		// Concurrency control, server side - 
		callByReferenceCCStrategy_javautilMapparameters.notifyServerSideCallStarted(diMeCallContext);

		try{
			implementation.callByReference(parameters);
			__return.add(org.distributeme.core.util.VoidMarker.VOID);
			__return.add(diMeCallContext.getTransportableCallContext());
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.AFTER_SERVANT_CALL);
			for (ServerSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.afterServantCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					__return.set(0, interceptorResponse.getReturnValue());
					diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
					break;
				case OVERWRITE_RETURN_AND_CONTINUE:
					__return.set(0, interceptorResponse.getReturnValue());
					diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
					break;
				case CONTINUE:
					break;
				} //...switch
			} //...for
			return __return;
		}finally{
			callByReferenceCCStrategy_javautilMapparameters.notifyServerSideCallFinished(diMeCallContext);
		}
	}

	public List sum(int a, int b, Map<?,?> __transportableCallContext){
		lastAccess = System.currentTimeMillis();
		ServerSideCallContext diMeCallContext = new ServerSideCallContext("sum", __transportableCallContext);
		diMeCallContext.setServiceId(TestServiceConstants.getServiceId());
		ArrayList<Object> diMeParameters = new ArrayList<Object>();
		diMeParameters.add(a);
		diMeParameters.add(b);
		diMeCallContext.setParameters(diMeParameters);
		InterceptionContext diMeInterceptionContext = new InterceptionContext();
		// Initialize interceptors
		List<ServerSideRequestInterceptor> diMeInterceptors = InterceptorRegistry.getInstance().getServerSideRequestInterceptors();

		ArrayList __return = new ArrayList();

		diMeInterceptionContext.setCurrentPhase(InterceptionPhase.BEFORE_SERVANT_CALL);
		for (ServerSideRequestInterceptor interceptor : diMeInterceptors){
			InterceptorResponse interceptorResponse = interceptor.beforeServantCall(diMeCallContext, diMeInterceptionContext);
			switch(interceptorResponse.getCommand()){
			case ABORT:
				if (interceptorResponse.getException() instanceof RuntimeException)
					throw (RuntimeException) interceptorResponse.getException();
				throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
			case RETURN:
				__return.set(0, interceptorResponse.getReturnValue());
				diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
				break;
			case OVERWRITE_RETURN_AND_CONTINUE:
				__return.set(0, interceptorResponse.getReturnValue());
				diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
				break;
			case CONTINUE:
				break;
			} //...switch
		} //...for
		// Concurrency control, server side - 
		sumCCStrategy_inta_intb.notifyServerSideCallStarted(diMeCallContext);

		try{
			Object __result = implementation.sum(a, b);
			__return.add(__result);
			diMeInterceptionContext.setReturnValue(__result);
			__return.add(diMeCallContext.getTransportableCallContext());
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.AFTER_SERVANT_CALL);
			for (ServerSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.afterServantCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					__return.set(0, interceptorResponse.getReturnValue());
					diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
					break;
				case OVERWRITE_RETURN_AND_CONTINUE:
					__return.set(0, interceptorResponse.getReturnValue());
					diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
					break;
				case CONTINUE:
					break;
				} //...switch
			} //...for
			return __return;
		}finally{
			sumCCStrategy_inta_intb.notifyServerSideCallFinished(diMeCallContext);
		}
	}

	public List modifiedSum(int a, int b, Map<?,?> __transportableCallContext){
		lastAccess = System.currentTimeMillis();
		ServerSideCallContext diMeCallContext = new ServerSideCallContext("modifiedSum", __transportableCallContext);
		diMeCallContext.setServiceId(TestServiceConstants.getServiceId());
		ArrayList<Object> diMeParameters = new ArrayList<Object>();
		diMeParameters.add(a);
		diMeParameters.add(b);
		diMeCallContext.setParameters(diMeParameters);
		InterceptionContext diMeInterceptionContext = new InterceptionContext();
		// Initialize interceptors
		List<ServerSideRequestInterceptor> diMeInterceptors = InterceptorRegistry.getInstance().getServerSideRequestInterceptors();

		ArrayList __return = new ArrayList();

		diMeInterceptionContext.setCurrentPhase(InterceptionPhase.BEFORE_SERVANT_CALL);
		for (ServerSideRequestInterceptor interceptor : diMeInterceptors){
			InterceptorResponse interceptorResponse = interceptor.beforeServantCall(diMeCallContext, diMeInterceptionContext);
			switch(interceptorResponse.getCommand()){
			case ABORT:
				if (interceptorResponse.getException() instanceof RuntimeException)
					throw (RuntimeException) interceptorResponse.getException();
				throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
			case RETURN:
				__return.set(0, interceptorResponse.getReturnValue());
				diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
				break;
			case OVERWRITE_RETURN_AND_CONTINUE:
				__return.set(0, interceptorResponse.getReturnValue());
				diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
				break;
			case CONTINUE:
				break;
			} //...switch
		} //...for
		// Concurrency control, server side - 
		modifiedSumCCStrategy_inta_intb.notifyServerSideCallStarted(diMeCallContext);

		try{
			Object __result = implementation.modifiedSum(a, b);
			__return.add(__result);
			diMeInterceptionContext.setReturnValue(__result);
			__return.add(diMeCallContext.getTransportableCallContext());
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.AFTER_SERVANT_CALL);
			for (ServerSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.afterServantCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					__return.set(0, interceptorResponse.getReturnValue());
					diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
					break;
				case OVERWRITE_RETURN_AND_CONTINUE:
					__return.set(0, interceptorResponse.getReturnValue());
					diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
					break;
				case CONTINUE:
					break;
				} //...switch
			} //...for
			return __return;
		}finally{
			modifiedSumCCStrategy_inta_intb.notifyServerSideCallFinished(diMeCallContext);
		}
	}

	public List modifiedSumParameters(int a, int b, Map<?,?> __transportableCallContext){
		lastAccess = System.currentTimeMillis();
		ServerSideCallContext diMeCallContext = new ServerSideCallContext("modifiedSumParameters", __transportableCallContext);
		diMeCallContext.setServiceId(TestServiceConstants.getServiceId());
		ArrayList<Object> diMeParameters = new ArrayList<Object>();
		diMeParameters.add(a);
		diMeParameters.add(b);
		diMeCallContext.setParameters(diMeParameters);
		InterceptionContext diMeInterceptionContext = new InterceptionContext();
		// Initialize interceptors
		List<ServerSideRequestInterceptor> diMeInterceptors = InterceptorRegistry.getInstance().getServerSideRequestInterceptors();

		ArrayList __return = new ArrayList();

		diMeInterceptionContext.setCurrentPhase(InterceptionPhase.BEFORE_SERVANT_CALL);
		for (ServerSideRequestInterceptor interceptor : diMeInterceptors){
			InterceptorResponse interceptorResponse = interceptor.beforeServantCall(diMeCallContext, diMeInterceptionContext);
			switch(interceptorResponse.getCommand()){
			case ABORT:
				if (interceptorResponse.getException() instanceof RuntimeException)
					throw (RuntimeException) interceptorResponse.getException();
				throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
			case RETURN:
				__return.set(0, interceptorResponse.getReturnValue());
				diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
				break;
			case OVERWRITE_RETURN_AND_CONTINUE:
				__return.set(0, interceptorResponse.getReturnValue());
				diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
				break;
			case CONTINUE:
				break;
			} //...switch
		} //...for
		// Concurrency control, server side - 
		modifiedSumParametersCCStrategy_inta_intb.notifyServerSideCallStarted(diMeCallContext);

		try{
			Object __result = implementation.modifiedSumParameters(a, b);
			__return.add(__result);
			diMeInterceptionContext.setReturnValue(__result);
			__return.add(diMeCallContext.getTransportableCallContext());
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.AFTER_SERVANT_CALL);
			for (ServerSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.afterServantCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					__return.set(0, interceptorResponse.getReturnValue());
					diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
					break;
				case OVERWRITE_RETURN_AND_CONTINUE:
					__return.set(0, interceptorResponse.getReturnValue());
					diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
					break;
				case CONTINUE:
					break;
				} //...switch
			} //...for
			return __return;
		}finally{
			modifiedSumParametersCCStrategy_inta_intb.notifyServerSideCallFinished(diMeCallContext);
		}
	}

	public List returnString(Map<?,?> __transportableCallContext){
		lastAccess = System.currentTimeMillis();
		ServerSideCallContext diMeCallContext = new ServerSideCallContext("returnString", __transportableCallContext);
		diMeCallContext.setServiceId(TestServiceConstants.getServiceId());
		ArrayList<Object> diMeParameters = new ArrayList<Object>();
		diMeCallContext.setParameters(diMeParameters);
		InterceptionContext diMeInterceptionContext = new InterceptionContext();
		// Initialize interceptors
		List<ServerSideRequestInterceptor> diMeInterceptors = InterceptorRegistry.getInstance().getServerSideRequestInterceptors();

		ArrayList __return = new ArrayList();

		diMeInterceptionContext.setCurrentPhase(InterceptionPhase.BEFORE_SERVANT_CALL);
		for (ServerSideRequestInterceptor interceptor : diMeInterceptors){
			InterceptorResponse interceptorResponse = interceptor.beforeServantCall(diMeCallContext, diMeInterceptionContext);
			switch(interceptorResponse.getCommand()){
			case ABORT:
				if (interceptorResponse.getException() instanceof RuntimeException)
					throw (RuntimeException) interceptorResponse.getException();
				throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
			case RETURN:
				__return.set(0, interceptorResponse.getReturnValue());
				diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
				break;
			case OVERWRITE_RETURN_AND_CONTINUE:
				__return.set(0, interceptorResponse.getReturnValue());
				diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
				break;
			case CONTINUE:
				break;
			} //...switch
		} //...for
		// Concurrency control, server side - 
		returnStringCCStrategy.notifyServerSideCallStarted(diMeCallContext);

		try{
			Object __result = implementation.returnString();
			__return.add(__result);
			diMeInterceptionContext.setReturnValue(__result);
			__return.add(diMeCallContext.getTransportableCallContext());
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.AFTER_SERVANT_CALL);
			for (ServerSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.afterServantCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					__return.set(0, interceptorResponse.getReturnValue());
					diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
					break;
				case OVERWRITE_RETURN_AND_CONTINUE:
					__return.set(0, interceptorResponse.getReturnValue());
					diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
					break;
				case CONTINUE:
					break;
				} //...switch
			} //...for
			return __return;
		}finally{
			returnStringCCStrategy.notifyServerSideCallFinished(diMeCallContext);
		}
	}

	public List returnStringCaughtInClient(Map<?,?> __transportableCallContext){
		lastAccess = System.currentTimeMillis();
		ServerSideCallContext diMeCallContext = new ServerSideCallContext("returnStringCaughtInClient", __transportableCallContext);
		diMeCallContext.setServiceId(TestServiceConstants.getServiceId());
		ArrayList<Object> diMeParameters = new ArrayList<Object>();
		diMeCallContext.setParameters(diMeParameters);
		InterceptionContext diMeInterceptionContext = new InterceptionContext();
		// Initialize interceptors
		List<ServerSideRequestInterceptor> diMeInterceptors = InterceptorRegistry.getInstance().getServerSideRequestInterceptors();

		ArrayList __return = new ArrayList();

		diMeInterceptionContext.setCurrentPhase(InterceptionPhase.BEFORE_SERVANT_CALL);
		for (ServerSideRequestInterceptor interceptor : diMeInterceptors){
			InterceptorResponse interceptorResponse = interceptor.beforeServantCall(diMeCallContext, diMeInterceptionContext);
			switch(interceptorResponse.getCommand()){
			case ABORT:
				if (interceptorResponse.getException() instanceof RuntimeException)
					throw (RuntimeException) interceptorResponse.getException();
				throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
			case RETURN:
				__return.set(0, interceptorResponse.getReturnValue());
				diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
				break;
			case OVERWRITE_RETURN_AND_CONTINUE:
				__return.set(0, interceptorResponse.getReturnValue());
				diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
				break;
			case CONTINUE:
				break;
			} //...switch
		} //...for
		// Concurrency control, server side - 
		returnStringCaughtInClientCCStrategy.notifyServerSideCallStarted(diMeCallContext);

		try{
			Object __result = implementation.returnStringCaughtInClient();
			__return.add(__result);
			diMeInterceptionContext.setReturnValue(__result);
			__return.add(diMeCallContext.getTransportableCallContext());
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.AFTER_SERVANT_CALL);
			for (ServerSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.afterServantCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					__return.set(0, interceptorResponse.getReturnValue());
					diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
					break;
				case OVERWRITE_RETURN_AND_CONTINUE:
					__return.set(0, interceptorResponse.getReturnValue());
					diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
					break;
				case CONTINUE:
					break;
				} //...switch
			} //...for
			return __return;
		}finally{
			returnStringCaughtInClientCCStrategy.notifyServerSideCallFinished(diMeCallContext);
		}
	}

	public List sleepingCall(long timeToSleep, Map<?,?> __transportableCallContext){
		lastAccess = System.currentTimeMillis();
		ServerSideCallContext diMeCallContext = new ServerSideCallContext("sleepingCall", __transportableCallContext);
		diMeCallContext.setServiceId(TestServiceConstants.getServiceId());
		ArrayList<Object> diMeParameters = new ArrayList<Object>();
		diMeParameters.add(timeToSleep);
		diMeCallContext.setParameters(diMeParameters);
		InterceptionContext diMeInterceptionContext = new InterceptionContext();
		// Initialize interceptors
		List<ServerSideRequestInterceptor> diMeInterceptors = InterceptorRegistry.getInstance().getServerSideRequestInterceptors();

		ArrayList __return = new ArrayList();

		diMeInterceptionContext.setCurrentPhase(InterceptionPhase.BEFORE_SERVANT_CALL);
		for (ServerSideRequestInterceptor interceptor : diMeInterceptors){
			InterceptorResponse interceptorResponse = interceptor.beforeServantCall(diMeCallContext, diMeInterceptionContext);
			switch(interceptorResponse.getCommand()){
			case ABORT:
				if (interceptorResponse.getException() instanceof RuntimeException)
					throw (RuntimeException) interceptorResponse.getException();
				throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
			case RETURN:
				__return.set(0, interceptorResponse.getReturnValue());
				diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
				break;
			case OVERWRITE_RETURN_AND_CONTINUE:
				__return.set(0, interceptorResponse.getReturnValue());
				diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
				break;
			case CONTINUE:
				break;
			} //...switch
		} //...for
		// Concurrency control, server side - 
		sleepingCallCCStrategy_longtimeToSleep.notifyServerSideCallStarted(diMeCallContext);

		try{
			implementation.sleepingCall(timeToSleep);
			__return.add(org.distributeme.core.util.VoidMarker.VOID);
			__return.add(diMeCallContext.getTransportableCallContext());
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.AFTER_SERVANT_CALL);
			for (ServerSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.afterServantCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					__return.set(0, interceptorResponse.getReturnValue());
					diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
					break;
				case OVERWRITE_RETURN_AND_CONTINUE:
					__return.set(0, interceptorResponse.getReturnValue());
					diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
					break;
				case CONTINUE:
					break;
				} //...switch
			} //...for
			return __return;
		}finally{
			sleepingCallCCStrategy_longtimeToSleep.notifyServerSideCallFinished(diMeCallContext);
		}
	}

	// Service adapter methods
	public long getCreationTimestamp(){ return created; }
	public long getLastAccessTimestamp(){ return lastAccess; }

}
