package org.distributeme.test.interception.generated;
//CHECKSTYLE:OFF

import java.util.List;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import java.rmi.RemoteException;
import java.rmi.NotBoundException;
import org.distributeme.core.RegistryUtil;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import org.distributeme.core.ServiceDescriptor;
import org.distributeme.core.ServiceDescriptor.Protocol;
import org.distributeme.core.DiscoveryMode;
import org.distributeme.core.failing.FailingStrategy;
import org.distributeme.core.concurrencycontrol.ConcurrencyControlStrategy;
import org.distributeme.core.failing.FailDecision;
import org.distributeme.core.ClientSideCallContext;
import org.distributeme.core.exception.DistributemeRuntimeException;
import org.distributeme.core.exception.NoConnectionToServerException;
import org.distributeme.core.exception.ServiceUnavailableException;
import org.distributeme.core.Defaults;
import org.distributeme.core.interceptor.ClientSideRequestInterceptor;
import org.distributeme.core.interceptor.InterceptorRegistry;
import org.distributeme.core.interceptor.InterceptorResponse;
import org.distributeme.core.interceptor.InterceptionContext;
import org.distributeme.core.interceptor.InterceptionPhase;
import org.distributeme.core.interceptor.FailedByInterceptorException;

public class RemoteTestServiceStub implements org.distributeme.test.interception.TestService{


	private volatile ConcurrentMap<String,RemoteTestService> delegates = new ConcurrentHashMap<String,RemoteTestService>();

	private DiscoveryMode discoveryMode = DiscoveryMode.AUTO;

	// ROUTER DECL V2
	// No class-wide-router set, skipping.

	// Method wide routers if applicable 
	// Method wide routers END 

	// ROUTER DECL V2 end

	// Failing
	// Class wide failing strategy 
	private FailingStrategy clazzWideFailingStrategy = Defaults.getDefaultFailingStrategy();

	private FailingStrategy callByValueFailingStrategy_javautilMapparameters = clazzWideFailingStrategy;
	private FailingStrategy callByReferenceFailingStrategy_javautilMapparameters = clazzWideFailingStrategy;
	private FailingStrategy sumFailingStrategy_inta_intb = clazzWideFailingStrategy;
	private FailingStrategy modifiedSumFailingStrategy_inta_intb = clazzWideFailingStrategy;
	private FailingStrategy modifiedSumParametersFailingStrategy_inta_intb = clazzWideFailingStrategy;
	private FailingStrategy returnStringFailingStrategy = clazzWideFailingStrategy;
	private FailingStrategy returnStringCaughtInClientFailingStrategy = clazzWideFailingStrategy;
	private FailingStrategy sleepingCallFailingStrategy_longtimeToSleep = clazzWideFailingStrategy;
	// Failing end

	// CONCURRENCY CONTROL
	// Class wide concurrency control strategy 
	private ConcurrencyControlStrategy clazzWideCCStrategy = Defaults.getDefaultConcurrencyControlStrategy();

	private ConcurrencyControlStrategy callByValueCCStrategy_javautilMapparameters = clazzWideCCStrategy;
	private ConcurrencyControlStrategy callByReferenceCCStrategy_javautilMapparameters = clazzWideCCStrategy;
	private ConcurrencyControlStrategy sumCCStrategy_inta_intb = clazzWideCCStrategy;
	private ConcurrencyControlStrategy modifiedSumCCStrategy_inta_intb = clazzWideCCStrategy;
	private ConcurrencyControlStrategy modifiedSumParametersCCStrategy_inta_intb = clazzWideCCStrategy;
	private ConcurrencyControlStrategy returnStringCCStrategy = clazzWideCCStrategy;
	private ConcurrencyControlStrategy returnStringCaughtInClientCCStrategy = clazzWideCCStrategy;
	private ConcurrencyControlStrategy sleepingCallCCStrategy_longtimeToSleep = clazzWideCCStrategy;
	// CONCURRENCY CONTROL end

	public RemoteTestServiceStub(){
		discoveryMode = DiscoveryMode.AUTO;
	}

	private ServiceDescriptor manuallySetDescriptor;
	private RemoteTestService manuallySetTarget;

	public RemoteTestServiceStub(ServiceDescriptor target){
		discoveryMode = DiscoveryMode.MANUAL;
		manuallySetDescriptor = target;
		try{
			manuallySetTarget = lookup(manuallySetDescriptor);
		}catch(NoConnectionToServerException e){
			throw new IllegalStateException("Can not resolve manually set reference", e);
		}
	}

	public void callByValue(java.util.Map<java.lang.String,java.lang.String> parameters){
		callByValue(parameters, (ClientSideCallContext)null);
	} //...public void callByValue(java.util.Map<java.lang.String,java.lang.String> parameters)

	private void callByValue(java.util.Map<java.lang.String,java.lang.String> parameters, org.distributeme.core.ClientSideCallContext diMeCallContext){
		List __fromServerSide = null;
		Exception exceptionInMethod = null;
		// This flag is used by the interceptor logic to mark a request es failed, even it is not.
		boolean diMeForceFailing = false;
		boolean abortAndFail = false;
		if (diMeCallContext == null)
			diMeCallContext = new ClientSideCallContext("callByValue");
		if (discoveryMode == DiscoveryMode.MANUAL) {
			diMeCallContext.setServiceId(manuallySetDescriptor.getServiceId());
		}
		if (discoveryMode==DiscoveryMode.AUTO && diMeCallContext.getServiceId()==null)
			diMeCallContext.setServiceId(TestServiceConstants.getServiceId());

		HashMap __transportableCallContext = diMeCallContext.getTransportableCallContext();
		// Initialize interceptors
		List<ClientSideRequestInterceptor> diMeInterceptors = InterceptorRegistry.getInstance().getClientSideRequestInterceptors();
		InterceptionContext diMeInterceptionContext = new InterceptionContext();

		// Concurrency control, client side - start
		callByValueCCStrategy_javautilMapparameters.notifyClientSideCallStarted(diMeCallContext);

		try{
			ArrayList<Object> diMeParameters = new ArrayList<Object>();
			diMeParameters.add(parameters);
			diMeCallContext.setParameters(diMeParameters);
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.BEFORE_SERVICE_CALL);
			for (ClientSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.beforeServiceCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					return;
				case CONTINUE:
					break;
				case ABORT_AND_FAIL:
					abortAndFail = true;
					exceptionInMethod = new FailedByInterceptorException();
					break;
				case RETURN_AND_FAIL:
				// Force failing logic to work.
					diMeForceFailing = true;
					exceptionInMethod = new FailedByInterceptorException();
					break;
				default:
					throw new IllegalStateException("Unsupported or unexpected command from interceptor " + interceptorResponse.getCommand()+ " in phase:"+diMeInterceptionContext.getCurrentPhase());
				} //...switch
			} //...for
			// parse parameters again in case an interceptor modified them
			parameters = (java.util.Map<java.lang.String,java.lang.String>) diMeParameters.get(0);
			if (!abortAndFail){
				__fromServerSide = getDelegate(diMeCallContext.getServiceId()).callByValue(parameters,  __transportableCallContext);
				__transportableCallContext.putAll(((HashMap)__fromServerSide.get(1)));
				return;
			}
		}catch(RemoteException e){
			// handle exceptions properly
			e.printStackTrace();
			notifyDelegateFailed(diMeCallContext.getServiceId());
			exceptionInMethod = e;
		}catch(NoConnectionToServerException e){
			exceptionInMethod = e;
		}finally{
			// Concurrency control, client side - end
			callByValueCCStrategy_javautilMapparameters.notifyClientSideCallFinished(diMeCallContext);
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.AFTER_SERVICE_CALL);
			if (__fromServerSide!=null){
				diMeInterceptionContext.setReturnValue(__fromServerSide.get(0));
			}
			diMeInterceptionContext.setException(exceptionInMethod);
			boolean diMeReturnOverriden = false;
			for (ClientSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.afterServiceCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					return;
				case CONTINUE:
					break;
				case ABORT_AND_FAIL:
					abortAndFail = true;
					break;
				case RETURN_AND_FAIL:
				// Force failing logic to work.
				callByValueFailingStrategy_javautilMapparameters.callFailed(diMeCallContext);
					break;
				default:
					throw new IllegalStateException("Unsupported or unexpected command from interceptor " + interceptorResponse.getCommand()+ " in phase:"+diMeInterceptionContext.getCurrentPhase());
				} //...switch
			} //...for

		} //...finally
		// Failing
		if (exceptionInMethod!=null || diMeForceFailing || abortAndFail){
			FailDecision failDecision = callByValueFailingStrategy_javautilMapparameters.callFailed(diMeCallContext);
			if (failDecision.getTargetService()!=null)
				diMeCallContext.setServiceId(failDecision.getTargetService());
			switch(failDecision.getReaction()){
				case RETRY:
					callByValue(parameters, diMeCallContext.increaseCallCount());
					return;
				case RETRYONCE:
					// Only retry if its the first call
					if (!diMeCallContext.isFirstCall())
						break;
					callByValue(parameters, diMeCallContext.increaseCallCount());
					return;
				case FAIL:
				default:
				// Fail or default is to do nothing at all and let the request fail
			} //...switch(failDecision)
		}
		// fail through, if we are here, we must have had an exception before.
		if (exceptionInMethod == null)
			throw new AssertionError("Exception must have been thrown before, but it wasn't, framework error!");
		throw mapException(exceptionInMethod);
	}

	public void callByReference(java.util.Map<java.lang.String,java.lang.String> parameters){
		callByReference(parameters, (ClientSideCallContext)null);
	} //...public void callByReference(java.util.Map<java.lang.String,java.lang.String> parameters)

	private void callByReference(java.util.Map<java.lang.String,java.lang.String> parameters, org.distributeme.core.ClientSideCallContext diMeCallContext){
		List __fromServerSide = null;
		Exception exceptionInMethod = null;
		// This flag is used by the interceptor logic to mark a request es failed, even it is not.
		boolean diMeForceFailing = false;
		boolean abortAndFail = false;
		if (diMeCallContext == null)
			diMeCallContext = new ClientSideCallContext("callByReference");
		if (discoveryMode == DiscoveryMode.MANUAL) {
			diMeCallContext.setServiceId(manuallySetDescriptor.getServiceId());
		}
		if (discoveryMode==DiscoveryMode.AUTO && diMeCallContext.getServiceId()==null)
			diMeCallContext.setServiceId(TestServiceConstants.getServiceId());

		HashMap __transportableCallContext = diMeCallContext.getTransportableCallContext();
		// Initialize interceptors
		List<ClientSideRequestInterceptor> diMeInterceptors = InterceptorRegistry.getInstance().getClientSideRequestInterceptors();
		InterceptionContext diMeInterceptionContext = new InterceptionContext();

		// Concurrency control, client side - start
		callByReferenceCCStrategy_javautilMapparameters.notifyClientSideCallStarted(diMeCallContext);

		try{
			ArrayList<Object> diMeParameters = new ArrayList<Object>();
			diMeParameters.add(parameters);
			diMeCallContext.setParameters(diMeParameters);
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.BEFORE_SERVICE_CALL);
			for (ClientSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.beforeServiceCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					return;
				case CONTINUE:
					break;
				case ABORT_AND_FAIL:
					abortAndFail = true;
					exceptionInMethod = new FailedByInterceptorException();
					break;
				case RETURN_AND_FAIL:
				// Force failing logic to work.
					diMeForceFailing = true;
					exceptionInMethod = new FailedByInterceptorException();
					break;
				default:
					throw new IllegalStateException("Unsupported or unexpected command from interceptor " + interceptorResponse.getCommand()+ " in phase:"+diMeInterceptionContext.getCurrentPhase());
				} //...switch
			} //...for
			// parse parameters again in case an interceptor modified them
			parameters = (java.util.Map<java.lang.String,java.lang.String>) diMeParameters.get(0);
			if (!abortAndFail){
				__fromServerSide = getDelegate(diMeCallContext.getServiceId()).callByReference(parameters,  __transportableCallContext);
				__transportableCallContext.putAll(((HashMap)__fromServerSide.get(1)));
				return;
			}
		}catch(RemoteException e){
			// handle exceptions properly
			e.printStackTrace();
			notifyDelegateFailed(diMeCallContext.getServiceId());
			exceptionInMethod = e;
		}catch(NoConnectionToServerException e){
			exceptionInMethod = e;
		}finally{
			// Concurrency control, client side - end
			callByReferenceCCStrategy_javautilMapparameters.notifyClientSideCallFinished(diMeCallContext);
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.AFTER_SERVICE_CALL);
			if (__fromServerSide!=null){
				diMeInterceptionContext.setReturnValue(__fromServerSide.get(0));
			}
			diMeInterceptionContext.setException(exceptionInMethod);
			boolean diMeReturnOverriden = false;
			for (ClientSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.afterServiceCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					return;
				case CONTINUE:
					break;
				case ABORT_AND_FAIL:
					abortAndFail = true;
					break;
				case RETURN_AND_FAIL:
				// Force failing logic to work.
				callByReferenceFailingStrategy_javautilMapparameters.callFailed(diMeCallContext);
					break;
				default:
					throw new IllegalStateException("Unsupported or unexpected command from interceptor " + interceptorResponse.getCommand()+ " in phase:"+diMeInterceptionContext.getCurrentPhase());
				} //...switch
			} //...for

		} //...finally
		// Failing
		if (exceptionInMethod!=null || diMeForceFailing || abortAndFail){
			FailDecision failDecision = callByReferenceFailingStrategy_javautilMapparameters.callFailed(diMeCallContext);
			if (failDecision.getTargetService()!=null)
				diMeCallContext.setServiceId(failDecision.getTargetService());
			switch(failDecision.getReaction()){
				case RETRY:
					callByReference(parameters, diMeCallContext.increaseCallCount());
					return;
				case RETRYONCE:
					// Only retry if its the first call
					if (!diMeCallContext.isFirstCall())
						break;
					callByReference(parameters, diMeCallContext.increaseCallCount());
					return;
				case FAIL:
				default:
				// Fail or default is to do nothing at all and let the request fail
			} //...switch(failDecision)
		}
		// fail through, if we are here, we must have had an exception before.
		if (exceptionInMethod == null)
			throw new AssertionError("Exception must have been thrown before, but it wasn't, framework error!");
		throw mapException(exceptionInMethod);
	}

	public int sum(int a, int b){
		return sum(a, b, (ClientSideCallContext)null);
	} //...public int sum(int a, int b)

	private int sum(int a, int b, org.distributeme.core.ClientSideCallContext diMeCallContext){
		List __fromServerSide = null;
		Exception exceptionInMethod = null;
		// This flag is used by the interceptor logic to mark a request es failed, even it is not.
		boolean diMeForceFailing = false;
		boolean abortAndFail = false;
		if (diMeCallContext == null)
			diMeCallContext = new ClientSideCallContext("sum");
		if (discoveryMode == DiscoveryMode.MANUAL) {
			diMeCallContext.setServiceId(manuallySetDescriptor.getServiceId());
		}
		if (discoveryMode==DiscoveryMode.AUTO && diMeCallContext.getServiceId()==null)
			diMeCallContext.setServiceId(TestServiceConstants.getServiceId());

		HashMap __transportableCallContext = diMeCallContext.getTransportableCallContext();
		// Initialize interceptors
		List<ClientSideRequestInterceptor> diMeInterceptors = InterceptorRegistry.getInstance().getClientSideRequestInterceptors();
		InterceptionContext diMeInterceptionContext = new InterceptionContext();

		// Concurrency control, client side - start
		sumCCStrategy_inta_intb.notifyClientSideCallStarted(diMeCallContext);

		try{
			ArrayList<Object> diMeParameters = new ArrayList<Object>();
			diMeParameters.add(a);
			diMeParameters.add(b);
			diMeCallContext.setParameters(diMeParameters);
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.BEFORE_SERVICE_CALL);
			for (ClientSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.beforeServiceCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					return ((Integer)interceptorResponse.getReturnValue()).intValue();
				case CONTINUE:
					break;
				case ABORT_AND_FAIL:
					abortAndFail = true;
					exceptionInMethod = new FailedByInterceptorException();
					break;
				case RETURN_AND_FAIL:
				// Force failing logic to work.
					diMeForceFailing = true;
					exceptionInMethod = new FailedByInterceptorException();
					break;
				default:
					throw new IllegalStateException("Unsupported or unexpected command from interceptor " + interceptorResponse.getCommand()+ " in phase:"+diMeInterceptionContext.getCurrentPhase());
				} //...switch
			} //...for
			// parse parameters again in case an interceptor modified them
			a = ((Integer)diMeParameters.get(0)).intValue();
			b = ((Integer)diMeParameters.get(1)).intValue();
			if (!abortAndFail){
				__fromServerSide = getDelegate(diMeCallContext.getServiceId()).sum(a, b,  __transportableCallContext);
				__transportableCallContext.putAll(((HashMap)__fromServerSide.get(1)));
				return ((Integer)__fromServerSide.get(0)).intValue();
			}
		}catch(RemoteException e){
			// handle exceptions properly
			e.printStackTrace();
			notifyDelegateFailed(diMeCallContext.getServiceId());
			exceptionInMethod = e;
		}catch(NoConnectionToServerException e){
			exceptionInMethod = e;
		}finally{
			// Concurrency control, client side - end
			sumCCStrategy_inta_intb.notifyClientSideCallFinished(diMeCallContext);
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.AFTER_SERVICE_CALL);
			if (__fromServerSide!=null){
				diMeInterceptionContext.setReturnValue(__fromServerSide.get(0));
			}
			diMeInterceptionContext.setException(exceptionInMethod);
			boolean diMeReturnOverriden = false;
			for (ClientSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.afterServiceCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					return ((Integer)interceptorResponse.getReturnValue()).intValue();
				case OVERWRITE_RETURN_AND_CONTINUE:
					if (__fromServerSide == null)
						throw new AssertionError("Incorrect use of interceptor, there is no return value in this method or it is null");
					__fromServerSide.set(0, interceptorResponse.getReturnValue());
					diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
					diMeReturnOverriden = true;
					break;
				case CONTINUE:
					break;
				case ABORT_AND_FAIL:
					abortAndFail = true;
					break;
				case RETURN_AND_FAIL:
				// Force failing logic to work.
				sumFailingStrategy_inta_intb.callFailed(diMeCallContext);
					break;
				default:
					throw new IllegalStateException("Unsupported or unexpected command from interceptor " + interceptorResponse.getCommand()+ " in phase:"+diMeInterceptionContext.getCurrentPhase());
				} //...switch
			} //...for
			// The next check for null of __fromServerSide is unneeded but for security reasons.
			if (diMeReturnOverriden && __fromServerSide!=null)
				return ((Integer)__fromServerSide.get(0)).intValue();

		} //...finally
		// Failing
		if (exceptionInMethod!=null || diMeForceFailing || abortAndFail){
			FailDecision failDecision = sumFailingStrategy_inta_intb.callFailed(diMeCallContext);
			if (failDecision.getTargetService()!=null)
				diMeCallContext.setServiceId(failDecision.getTargetService());
			switch(failDecision.getReaction()){
				case RETRY:
					return sum(a, b, diMeCallContext.increaseCallCount());
				case RETRYONCE:
					// Only retry if its the first call
					if (!diMeCallContext.isFirstCall())
						break;
					return sum(a, b, diMeCallContext.increaseCallCount());
				case FAIL:
				default:
				// Fail or default is to do nothing at all and let the request fail
			} //...switch(failDecision)
		}
		// fail through, if we are here, we must have had an exception before.
		if (exceptionInMethod == null)
			throw new AssertionError("Exception must have been thrown before, but it wasn't, framework error!");
		throw mapException(exceptionInMethod);
	}

	public int modifiedSum(int a, int b){
		return modifiedSum(a, b, (ClientSideCallContext)null);
	} //...public int modifiedSum(int a, int b)

	private int modifiedSum(int a, int b, org.distributeme.core.ClientSideCallContext diMeCallContext){
		List __fromServerSide = null;
		Exception exceptionInMethod = null;
		// This flag is used by the interceptor logic to mark a request es failed, even it is not.
		boolean diMeForceFailing = false;
		boolean abortAndFail = false;
		if (diMeCallContext == null)
			diMeCallContext = new ClientSideCallContext("modifiedSum");
		if (discoveryMode == DiscoveryMode.MANUAL) {
			diMeCallContext.setServiceId(manuallySetDescriptor.getServiceId());
		}
		if (discoveryMode==DiscoveryMode.AUTO && diMeCallContext.getServiceId()==null)
			diMeCallContext.setServiceId(TestServiceConstants.getServiceId());

		HashMap __transportableCallContext = diMeCallContext.getTransportableCallContext();
		// Initialize interceptors
		List<ClientSideRequestInterceptor> diMeInterceptors = InterceptorRegistry.getInstance().getClientSideRequestInterceptors();
		InterceptionContext diMeInterceptionContext = new InterceptionContext();

		// Concurrency control, client side - start
		modifiedSumCCStrategy_inta_intb.notifyClientSideCallStarted(diMeCallContext);

		try{
			ArrayList<Object> diMeParameters = new ArrayList<Object>();
			diMeParameters.add(a);
			diMeParameters.add(b);
			diMeCallContext.setParameters(diMeParameters);
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.BEFORE_SERVICE_CALL);
			for (ClientSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.beforeServiceCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					return ((Integer)interceptorResponse.getReturnValue()).intValue();
				case CONTINUE:
					break;
				case ABORT_AND_FAIL:
					abortAndFail = true;
					exceptionInMethod = new FailedByInterceptorException();
					break;
				case RETURN_AND_FAIL:
				// Force failing logic to work.
					diMeForceFailing = true;
					exceptionInMethod = new FailedByInterceptorException();
					break;
				default:
					throw new IllegalStateException("Unsupported or unexpected command from interceptor " + interceptorResponse.getCommand()+ " in phase:"+diMeInterceptionContext.getCurrentPhase());
				} //...switch
			} //...for
			// parse parameters again in case an interceptor modified them
			a = ((Integer)diMeParameters.get(0)).intValue();
			b = ((Integer)diMeParameters.get(1)).intValue();
			if (!abortAndFail){
				__fromServerSide = getDelegate(diMeCallContext.getServiceId()).modifiedSum(a, b,  __transportableCallContext);
				__transportableCallContext.putAll(((HashMap)__fromServerSide.get(1)));
				return ((Integer)__fromServerSide.get(0)).intValue();
			}
		}catch(RemoteException e){
			// handle exceptions properly
			e.printStackTrace();
			notifyDelegateFailed(diMeCallContext.getServiceId());
			exceptionInMethod = e;
		}catch(NoConnectionToServerException e){
			exceptionInMethod = e;
		}finally{
			// Concurrency control, client side - end
			modifiedSumCCStrategy_inta_intb.notifyClientSideCallFinished(diMeCallContext);
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.AFTER_SERVICE_CALL);
			if (__fromServerSide!=null){
				diMeInterceptionContext.setReturnValue(__fromServerSide.get(0));
			}
			diMeInterceptionContext.setException(exceptionInMethod);
			boolean diMeReturnOverriden = false;
			for (ClientSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.afterServiceCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					return ((Integer)interceptorResponse.getReturnValue()).intValue();
				case OVERWRITE_RETURN_AND_CONTINUE:
					if (__fromServerSide == null)
						throw new AssertionError("Incorrect use of interceptor, there is no return value in this method or it is null");
					__fromServerSide.set(0, interceptorResponse.getReturnValue());
					diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
					diMeReturnOverriden = true;
					break;
				case CONTINUE:
					break;
				case ABORT_AND_FAIL:
					abortAndFail = true;
					break;
				case RETURN_AND_FAIL:
				// Force failing logic to work.
				modifiedSumFailingStrategy_inta_intb.callFailed(diMeCallContext);
					break;
				default:
					throw new IllegalStateException("Unsupported or unexpected command from interceptor " + interceptorResponse.getCommand()+ " in phase:"+diMeInterceptionContext.getCurrentPhase());
				} //...switch
			} //...for
			// The next check for null of __fromServerSide is unneeded but for security reasons.
			if (diMeReturnOverriden && __fromServerSide!=null)
				return ((Integer)__fromServerSide.get(0)).intValue();

		} //...finally
		// Failing
		if (exceptionInMethod!=null || diMeForceFailing || abortAndFail){
			FailDecision failDecision = modifiedSumFailingStrategy_inta_intb.callFailed(diMeCallContext);
			if (failDecision.getTargetService()!=null)
				diMeCallContext.setServiceId(failDecision.getTargetService());
			switch(failDecision.getReaction()){
				case RETRY:
					return modifiedSum(a, b, diMeCallContext.increaseCallCount());
				case RETRYONCE:
					// Only retry if its the first call
					if (!diMeCallContext.isFirstCall())
						break;
					return modifiedSum(a, b, diMeCallContext.increaseCallCount());
				case FAIL:
				default:
				// Fail or default is to do nothing at all and let the request fail
			} //...switch(failDecision)
		}
		// fail through, if we are here, we must have had an exception before.
		if (exceptionInMethod == null)
			throw new AssertionError("Exception must have been thrown before, but it wasn't, framework error!");
		throw mapException(exceptionInMethod);
	}

	public int modifiedSumParameters(int a, int b){
		return modifiedSumParameters(a, b, (ClientSideCallContext)null);
	} //...public int modifiedSumParameters(int a, int b)

	private int modifiedSumParameters(int a, int b, org.distributeme.core.ClientSideCallContext diMeCallContext){
		List __fromServerSide = null;
		Exception exceptionInMethod = null;
		// This flag is used by the interceptor logic to mark a request es failed, even it is not.
		boolean diMeForceFailing = false;
		boolean abortAndFail = false;
		if (diMeCallContext == null)
			diMeCallContext = new ClientSideCallContext("modifiedSumParameters");
		if (discoveryMode == DiscoveryMode.MANUAL) {
			diMeCallContext.setServiceId(manuallySetDescriptor.getServiceId());
		}
		if (discoveryMode==DiscoveryMode.AUTO && diMeCallContext.getServiceId()==null)
			diMeCallContext.setServiceId(TestServiceConstants.getServiceId());

		HashMap __transportableCallContext = diMeCallContext.getTransportableCallContext();
		// Initialize interceptors
		List<ClientSideRequestInterceptor> diMeInterceptors = InterceptorRegistry.getInstance().getClientSideRequestInterceptors();
		InterceptionContext diMeInterceptionContext = new InterceptionContext();

		// Concurrency control, client side - start
		modifiedSumParametersCCStrategy_inta_intb.notifyClientSideCallStarted(diMeCallContext);

		try{
			ArrayList<Object> diMeParameters = new ArrayList<Object>();
			diMeParameters.add(a);
			diMeParameters.add(b);
			diMeCallContext.setParameters(diMeParameters);
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.BEFORE_SERVICE_CALL);
			for (ClientSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.beforeServiceCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					return ((Integer)interceptorResponse.getReturnValue()).intValue();
				case CONTINUE:
					break;
				case ABORT_AND_FAIL:
					abortAndFail = true;
					exceptionInMethod = new FailedByInterceptorException();
					break;
				case RETURN_AND_FAIL:
				// Force failing logic to work.
					diMeForceFailing = true;
					exceptionInMethod = new FailedByInterceptorException();
					break;
				default:
					throw new IllegalStateException("Unsupported or unexpected command from interceptor " + interceptorResponse.getCommand()+ " in phase:"+diMeInterceptionContext.getCurrentPhase());
				} //...switch
			} //...for
			// parse parameters again in case an interceptor modified them
			a = ((Integer)diMeParameters.get(0)).intValue();
			b = ((Integer)diMeParameters.get(1)).intValue();
			if (!abortAndFail){
				__fromServerSide = getDelegate(diMeCallContext.getServiceId()).modifiedSumParameters(a, b,  __transportableCallContext);
				__transportableCallContext.putAll(((HashMap)__fromServerSide.get(1)));
				return ((Integer)__fromServerSide.get(0)).intValue();
			}
		}catch(RemoteException e){
			// handle exceptions properly
			e.printStackTrace();
			notifyDelegateFailed(diMeCallContext.getServiceId());
			exceptionInMethod = e;
		}catch(NoConnectionToServerException e){
			exceptionInMethod = e;
		}finally{
			// Concurrency control, client side - end
			modifiedSumParametersCCStrategy_inta_intb.notifyClientSideCallFinished(diMeCallContext);
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.AFTER_SERVICE_CALL);
			if (__fromServerSide!=null){
				diMeInterceptionContext.setReturnValue(__fromServerSide.get(0));
			}
			diMeInterceptionContext.setException(exceptionInMethod);
			boolean diMeReturnOverriden = false;
			for (ClientSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.afterServiceCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					return ((Integer)interceptorResponse.getReturnValue()).intValue();
				case OVERWRITE_RETURN_AND_CONTINUE:
					if (__fromServerSide == null)
						throw new AssertionError("Incorrect use of interceptor, there is no return value in this method or it is null");
					__fromServerSide.set(0, interceptorResponse.getReturnValue());
					diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
					diMeReturnOverriden = true;
					break;
				case CONTINUE:
					break;
				case ABORT_AND_FAIL:
					abortAndFail = true;
					break;
				case RETURN_AND_FAIL:
				// Force failing logic to work.
				modifiedSumParametersFailingStrategy_inta_intb.callFailed(diMeCallContext);
					break;
				default:
					throw new IllegalStateException("Unsupported or unexpected command from interceptor " + interceptorResponse.getCommand()+ " in phase:"+diMeInterceptionContext.getCurrentPhase());
				} //...switch
			} //...for
			// The next check for null of __fromServerSide is unneeded but for security reasons.
			if (diMeReturnOverriden && __fromServerSide!=null)
				return ((Integer)__fromServerSide.get(0)).intValue();

		} //...finally
		// Failing
		if (exceptionInMethod!=null || diMeForceFailing || abortAndFail){
			FailDecision failDecision = modifiedSumParametersFailingStrategy_inta_intb.callFailed(diMeCallContext);
			if (failDecision.getTargetService()!=null)
				diMeCallContext.setServiceId(failDecision.getTargetService());
			switch(failDecision.getReaction()){
				case RETRY:
					return modifiedSumParameters(a, b, diMeCallContext.increaseCallCount());
				case RETRYONCE:
					// Only retry if its the first call
					if (!diMeCallContext.isFirstCall())
						break;
					return modifiedSumParameters(a, b, diMeCallContext.increaseCallCount());
				case FAIL:
				default:
				// Fail or default is to do nothing at all and let the request fail
			} //...switch(failDecision)
		}
		// fail through, if we are here, we must have had an exception before.
		if (exceptionInMethod == null)
			throw new AssertionError("Exception must have been thrown before, but it wasn't, framework error!");
		throw mapException(exceptionInMethod);
	}

	public java.lang.String returnString(){
		return returnString((ClientSideCallContext)null);
	} //...public java.lang.String returnString()

	private java.lang.String returnString(org.distributeme.core.ClientSideCallContext diMeCallContext){
		List __fromServerSide = null;
		Exception exceptionInMethod = null;
		// This flag is used by the interceptor logic to mark a request es failed, even it is not.
		boolean diMeForceFailing = false;
		boolean abortAndFail = false;
		if (diMeCallContext == null)
			diMeCallContext = new ClientSideCallContext("returnString");
		if (discoveryMode == DiscoveryMode.MANUAL) {
			diMeCallContext.setServiceId(manuallySetDescriptor.getServiceId());
		}
		if (discoveryMode==DiscoveryMode.AUTO && diMeCallContext.getServiceId()==null)
			diMeCallContext.setServiceId(TestServiceConstants.getServiceId());

		HashMap __transportableCallContext = diMeCallContext.getTransportableCallContext();
		// Initialize interceptors
		List<ClientSideRequestInterceptor> diMeInterceptors = InterceptorRegistry.getInstance().getClientSideRequestInterceptors();
		InterceptionContext diMeInterceptionContext = new InterceptionContext();

		// Concurrency control, client side - start
		returnStringCCStrategy.notifyClientSideCallStarted(diMeCallContext);

		try{
			ArrayList<Object> diMeParameters = new ArrayList<Object>();
			diMeCallContext.setParameters(diMeParameters);
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.BEFORE_SERVICE_CALL);
			for (ClientSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.beforeServiceCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					return (java.lang.String) interceptorResponse.getReturnValue();
				case CONTINUE:
					break;
				case ABORT_AND_FAIL:
					abortAndFail = true;
					exceptionInMethod = new FailedByInterceptorException();
					break;
				case RETURN_AND_FAIL:
				// Force failing logic to work.
					diMeForceFailing = true;
					exceptionInMethod = new FailedByInterceptorException();
					break;
				default:
					throw new IllegalStateException("Unsupported or unexpected command from interceptor " + interceptorResponse.getCommand()+ " in phase:"+diMeInterceptionContext.getCurrentPhase());
				} //...switch
			} //...for
			// parse parameters again in case an interceptor modified them
			if (!abortAndFail){
				__fromServerSide = getDelegate(diMeCallContext.getServiceId()).returnString( __transportableCallContext);
				__transportableCallContext.putAll(((HashMap)__fromServerSide.get(1)));
				return (java.lang.String) __fromServerSide.get(0);
			}
		}catch(RemoteException e){
			// handle exceptions properly
			e.printStackTrace();
			notifyDelegateFailed(diMeCallContext.getServiceId());
			exceptionInMethod = e;
		}catch(NoConnectionToServerException e){
			exceptionInMethod = e;
		}finally{
			// Concurrency control, client side - end
			returnStringCCStrategy.notifyClientSideCallFinished(diMeCallContext);
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.AFTER_SERVICE_CALL);
			if (__fromServerSide!=null){
				diMeInterceptionContext.setReturnValue(__fromServerSide.get(0));
			}
			diMeInterceptionContext.setException(exceptionInMethod);
			boolean diMeReturnOverriden = false;
			for (ClientSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.afterServiceCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					return (java.lang.String) interceptorResponse.getReturnValue();
				case OVERWRITE_RETURN_AND_CONTINUE:
					if (__fromServerSide == null)
						throw new AssertionError("Incorrect use of interceptor, there is no return value in this method or it is null");
					__fromServerSide.set(0, interceptorResponse.getReturnValue());
					diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
					diMeReturnOverriden = true;
					break;
				case CONTINUE:
					break;
				case ABORT_AND_FAIL:
					abortAndFail = true;
					break;
				case RETURN_AND_FAIL:
				// Force failing logic to work.
				returnStringFailingStrategy.callFailed(diMeCallContext);
					break;
				default:
					throw new IllegalStateException("Unsupported or unexpected command from interceptor " + interceptorResponse.getCommand()+ " in phase:"+diMeInterceptionContext.getCurrentPhase());
				} //...switch
			} //...for
			// The next check for null of __fromServerSide is unneeded but for security reasons.
			if (diMeReturnOverriden && __fromServerSide!=null)
				return (java.lang.String) __fromServerSide.get(0);

		} //...finally
		// Failing
		if (exceptionInMethod!=null || diMeForceFailing || abortAndFail){
			FailDecision failDecision = returnStringFailingStrategy.callFailed(diMeCallContext);
			if (failDecision.getTargetService()!=null)
				diMeCallContext.setServiceId(failDecision.getTargetService());
			switch(failDecision.getReaction()){
				case RETRY:
					return returnString(diMeCallContext.increaseCallCount());
				case RETRYONCE:
					// Only retry if its the first call
					if (!diMeCallContext.isFirstCall())
						break;
					return returnString(diMeCallContext.increaseCallCount());
				case FAIL:
				default:
				// Fail or default is to do nothing at all and let the request fail
			} //...switch(failDecision)
		}
		// fail through, if we are here, we must have had an exception before.
		if (exceptionInMethod == null)
			throw new AssertionError("Exception must have been thrown before, but it wasn't, framework error!");
		throw mapException(exceptionInMethod);
	}

	public java.lang.String returnStringCaughtInClient(){
		return returnStringCaughtInClient((ClientSideCallContext)null);
	} //...public java.lang.String returnStringCaughtInClient()

	private java.lang.String returnStringCaughtInClient(org.distributeme.core.ClientSideCallContext diMeCallContext){
		List __fromServerSide = null;
		Exception exceptionInMethod = null;
		// This flag is used by the interceptor logic to mark a request es failed, even it is not.
		boolean diMeForceFailing = false;
		boolean abortAndFail = false;
		if (diMeCallContext == null)
			diMeCallContext = new ClientSideCallContext("returnStringCaughtInClient");
		if (discoveryMode == DiscoveryMode.MANUAL) {
			diMeCallContext.setServiceId(manuallySetDescriptor.getServiceId());
		}
		if (discoveryMode==DiscoveryMode.AUTO && diMeCallContext.getServiceId()==null)
			diMeCallContext.setServiceId(TestServiceConstants.getServiceId());

		HashMap __transportableCallContext = diMeCallContext.getTransportableCallContext();
		// Initialize interceptors
		List<ClientSideRequestInterceptor> diMeInterceptors = InterceptorRegistry.getInstance().getClientSideRequestInterceptors();
		InterceptionContext diMeInterceptionContext = new InterceptionContext();

		// Concurrency control, client side - start
		returnStringCaughtInClientCCStrategy.notifyClientSideCallStarted(diMeCallContext);

		try{
			ArrayList<Object> diMeParameters = new ArrayList<Object>();
			diMeCallContext.setParameters(diMeParameters);
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.BEFORE_SERVICE_CALL);
			for (ClientSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.beforeServiceCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					return (java.lang.String) interceptorResponse.getReturnValue();
				case CONTINUE:
					break;
				case ABORT_AND_FAIL:
					abortAndFail = true;
					exceptionInMethod = new FailedByInterceptorException();
					break;
				case RETURN_AND_FAIL:
				// Force failing logic to work.
					diMeForceFailing = true;
					exceptionInMethod = new FailedByInterceptorException();
					break;
				default:
					throw new IllegalStateException("Unsupported or unexpected command from interceptor " + interceptorResponse.getCommand()+ " in phase:"+diMeInterceptionContext.getCurrentPhase());
				} //...switch
			} //...for
			// parse parameters again in case an interceptor modified them
			if (!abortAndFail){
				__fromServerSide = getDelegate(diMeCallContext.getServiceId()).returnStringCaughtInClient( __transportableCallContext);
				__transportableCallContext.putAll(((HashMap)__fromServerSide.get(1)));
				return (java.lang.String) __fromServerSide.get(0);
			}
		}catch(RemoteException e){
			// handle exceptions properly
			e.printStackTrace();
			notifyDelegateFailed(diMeCallContext.getServiceId());
			exceptionInMethod = e;
		}catch(NoConnectionToServerException e){
			exceptionInMethod = e;
		}finally{
			// Concurrency control, client side - end
			returnStringCaughtInClientCCStrategy.notifyClientSideCallFinished(diMeCallContext);
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.AFTER_SERVICE_CALL);
			if (__fromServerSide!=null){
				diMeInterceptionContext.setReturnValue(__fromServerSide.get(0));
			}
			diMeInterceptionContext.setException(exceptionInMethod);
			boolean diMeReturnOverriden = false;
			for (ClientSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.afterServiceCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					return (java.lang.String) interceptorResponse.getReturnValue();
				case OVERWRITE_RETURN_AND_CONTINUE:
					if (__fromServerSide == null)
						throw new AssertionError("Incorrect use of interceptor, there is no return value in this method or it is null");
					__fromServerSide.set(0, interceptorResponse.getReturnValue());
					diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
					diMeReturnOverriden = true;
					break;
				case CONTINUE:
					break;
				case ABORT_AND_FAIL:
					abortAndFail = true;
					break;
				case RETURN_AND_FAIL:
				// Force failing logic to work.
				returnStringCaughtInClientFailingStrategy.callFailed(diMeCallContext);
					break;
				default:
					throw new IllegalStateException("Unsupported or unexpected command from interceptor " + interceptorResponse.getCommand()+ " in phase:"+diMeInterceptionContext.getCurrentPhase());
				} //...switch
			} //...for
			// The next check for null of __fromServerSide is unneeded but for security reasons.
			if (diMeReturnOverriden && __fromServerSide!=null)
				return (java.lang.String) __fromServerSide.get(0);

		} //...finally
		// Failing
		if (exceptionInMethod!=null || diMeForceFailing || abortAndFail){
			FailDecision failDecision = returnStringCaughtInClientFailingStrategy.callFailed(diMeCallContext);
			if (failDecision.getTargetService()!=null)
				diMeCallContext.setServiceId(failDecision.getTargetService());
			switch(failDecision.getReaction()){
				case RETRY:
					return returnStringCaughtInClient(diMeCallContext.increaseCallCount());
				case RETRYONCE:
					// Only retry if its the first call
					if (!diMeCallContext.isFirstCall())
						break;
					return returnStringCaughtInClient(diMeCallContext.increaseCallCount());
				case FAIL:
				default:
				// Fail or default is to do nothing at all and let the request fail
			} //...switch(failDecision)
		}
		// fail through, if we are here, we must have had an exception before.
		if (exceptionInMethod == null)
			throw new AssertionError("Exception must have been thrown before, but it wasn't, framework error!");
		throw mapException(exceptionInMethod);
	}

	public void sleepingCall(long timeToSleep){
		sleepingCall(timeToSleep, (ClientSideCallContext)null);
	} //...public void sleepingCall(long timeToSleep)

	private void sleepingCall(long timeToSleep, org.distributeme.core.ClientSideCallContext diMeCallContext){
		List __fromServerSide = null;
		Exception exceptionInMethod = null;
		// This flag is used by the interceptor logic to mark a request es failed, even it is not.
		boolean diMeForceFailing = false;
		boolean abortAndFail = false;
		if (diMeCallContext == null)
			diMeCallContext = new ClientSideCallContext("sleepingCall");
		if (discoveryMode == DiscoveryMode.MANUAL) {
			diMeCallContext.setServiceId(manuallySetDescriptor.getServiceId());
		}
		if (discoveryMode==DiscoveryMode.AUTO && diMeCallContext.getServiceId()==null)
			diMeCallContext.setServiceId(TestServiceConstants.getServiceId());

		HashMap __transportableCallContext = diMeCallContext.getTransportableCallContext();
		// Initialize interceptors
		List<ClientSideRequestInterceptor> diMeInterceptors = InterceptorRegistry.getInstance().getClientSideRequestInterceptors();
		InterceptionContext diMeInterceptionContext = new InterceptionContext();

		// Concurrency control, client side - start
		sleepingCallCCStrategy_longtimeToSleep.notifyClientSideCallStarted(diMeCallContext);

		try{
			ArrayList<Object> diMeParameters = new ArrayList<Object>();
			diMeParameters.add(timeToSleep);
			diMeCallContext.setParameters(diMeParameters);
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.BEFORE_SERVICE_CALL);
			for (ClientSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.beforeServiceCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					return;
				case CONTINUE:
					break;
				case ABORT_AND_FAIL:
					abortAndFail = true;
					exceptionInMethod = new FailedByInterceptorException();
					break;
				case RETURN_AND_FAIL:
				// Force failing logic to work.
					diMeForceFailing = true;
					exceptionInMethod = new FailedByInterceptorException();
					break;
				default:
					throw new IllegalStateException("Unsupported or unexpected command from interceptor " + interceptorResponse.getCommand()+ " in phase:"+diMeInterceptionContext.getCurrentPhase());
				} //...switch
			} //...for
			// parse parameters again in case an interceptor modified them
			timeToSleep = ((Long)diMeParameters.get(0)).longValue();
			if (!abortAndFail){
				__fromServerSide = getDelegate(diMeCallContext.getServiceId()).sleepingCall(timeToSleep,  __transportableCallContext);
				__transportableCallContext.putAll(((HashMap)__fromServerSide.get(1)));
				return;
			}
		}catch(RemoteException e){
			// handle exceptions properly
			e.printStackTrace();
			notifyDelegateFailed(diMeCallContext.getServiceId());
			exceptionInMethod = e;
		}catch(NoConnectionToServerException e){
			exceptionInMethod = e;
		}finally{
			// Concurrency control, client side - end
			sleepingCallCCStrategy_longtimeToSleep.notifyClientSideCallFinished(diMeCallContext);
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.AFTER_SERVICE_CALL);
			if (__fromServerSide!=null){
				diMeInterceptionContext.setReturnValue(__fromServerSide.get(0));
			}
			diMeInterceptionContext.setException(exceptionInMethod);
			boolean diMeReturnOverriden = false;
			for (ClientSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.afterServiceCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					return;
				case CONTINUE:
					break;
				case ABORT_AND_FAIL:
					abortAndFail = true;
					break;
				case RETURN_AND_FAIL:
				// Force failing logic to work.
				sleepingCallFailingStrategy_longtimeToSleep.callFailed(diMeCallContext);
					break;
				default:
					throw new IllegalStateException("Unsupported or unexpected command from interceptor " + interceptorResponse.getCommand()+ " in phase:"+diMeInterceptionContext.getCurrentPhase());
				} //...switch
			} //...for

		} //...finally
		// Failing
		if (exceptionInMethod!=null || diMeForceFailing || abortAndFail){
			FailDecision failDecision = sleepingCallFailingStrategy_longtimeToSleep.callFailed(diMeCallContext);
			if (failDecision.getTargetService()!=null)
				diMeCallContext.setServiceId(failDecision.getTargetService());
			switch(failDecision.getReaction()){
				case RETRY:
					sleepingCall(timeToSleep, diMeCallContext.increaseCallCount());
					return;
				case RETRYONCE:
					// Only retry if its the first call
					if (!diMeCallContext.isFirstCall())
						break;
					sleepingCall(timeToSleep, diMeCallContext.increaseCallCount());
					return;
				case FAIL:
				default:
				// Fail or default is to do nothing at all and let the request fail
			} //...switch(failDecision)
		}
		// fail through, if we are here, we must have had an exception before.
		if (exceptionInMethod == null)
			throw new AssertionError("Exception must have been thrown before, but it wasn't, framework error!");
		throw mapException(exceptionInMethod);
	}

	// according to findbugs this method is never used, so we remove it for now reduce warnings.

	//private void notifyDelegateFailed(){
		//notifyDelegateFailed(TestServiceConstants.getServiceId());
	//}

	private void notifyDelegateFailed(String serviceId){
		if (discoveryMode==DiscoveryMode.MANUAL){
			manuallySetTarget = null;
			return;
		}
		if (serviceId!=null)
			delegates.remove(serviceId);
	} //...notifyDelegateFailed

	private RemoteTestService getDelegate() throws NoConnectionToServerException{
		if (discoveryMode==DiscoveryMode.MANUAL){
			if (manuallySetTarget!=null)
				return manuallySetTarget;
			manuallySetTarget = lookup(manuallySetDescriptor);
			return manuallySetTarget;
		} //...if (mode==MANUAL)
		return getDelegate(TestServiceConstants.getServiceId());
	}

	private RemoteTestService getDelegate(String serviceId) throws NoConnectionToServerException{
		// if no serviceId is provided, fallback to default resolve with manual mode
		if (serviceId==null || discoveryMode==DiscoveryMode.MANUAL)
			return getDelegate();
		RemoteTestService delegate = delegates.get(serviceId);
		if (delegate==null){
			try{
				delegate = lookup(serviceId);
				RemoteTestService existingDelegate = delegates.putIfAbsent(serviceId, delegate);
				if (existingDelegate!=null)
					delegate = existingDelegate;
			}catch(Exception e){
			// //TODO - generate and throw typed exception.
				throw new NoConnectionToServerException("Couldn't lookup delegate because: "+e.getMessage()+" at "+RegistryUtil.describeRegistry(), e);
			}//try
		} //...first if (del==null) 
		return delegate;
	} //...fun

	private RemoteTestService lookup(String serviceId) throws NoConnectionToServerException{
		// //first we need to lookup target host.
		ServiceDescriptor toLookup = new ServiceDescriptor(Protocol.RMI, serviceId);
		ServiceDescriptor targetService = RegistryUtil.resolve(toLookup);
		if (targetService==null)
			throw new RuntimeException("Can't resolve host for an instance of "+TestServiceConstants.getServiceId());
		Registry registry = null;
		try{
			registry = LocateRegistry.getRegistry(targetService.getHost(), targetService.getPort());
		}catch(Exception e){
			System.err.println("lookup - couldn't obtain rmi registry on "+targetService+", aborting lookup"); e.printStackTrace();
			throw new NoConnectionToServerException("Can't resolve rmi registry for an instance of "+TestServiceConstants.getServiceId());
		}
		try{
			return (RemoteTestService) registry.lookup(serviceId);
		}catch(RemoteException e){
			throw new NoConnectionToServerException("Can't lookup service in the target rmi registry for an instance of "+serviceId, e);
		}catch(NotBoundException e){
			throw new NoConnectionToServerException("Can't lookup service in the target rmi registry for an instance of "+serviceId, e);
		}
	}

	private RemoteTestService lookup(ServiceDescriptor serviceDescriptor) throws NoConnectionToServerException{
		Registry registry = null;
		try{
			registry = LocateRegistry.getRegistry(serviceDescriptor.getHost(), serviceDescriptor.getPort());
		}catch(Exception e){
			System.err.println("lookup - couldn't obtain rmi registry on "+serviceDescriptor+", aborting lookup"); e.printStackTrace();
			throw new NoConnectionToServerException("Can't resolve rmi registry for "+serviceDescriptor);
		}
		try{
			RemoteTestService ret = (RemoteTestService) registry.lookup(serviceDescriptor.getServiceId());
			return ret;
		}catch(RemoteException e){
			throw new NoConnectionToServerException("Can't lookup service in the target rmi registry for an instance of "+serviceDescriptor, e);
		}catch(NotBoundException e){
			throw new NoConnectionToServerException("Can't lookup service in the target rmi registry for an instance of "+serviceDescriptor, e);
		}
	}

	private DistributemeRuntimeException mapException(Exception in){
		if (in instanceof DistributemeRuntimeException)
			return (DistributemeRuntimeException) in;
		if (in instanceof RemoteException)
			return new ServiceUnavailableException ("Service unavailable due to rmi failure: "+in.getMessage(), in);
		return new ServiceUnavailableException("Unexpected exception: "+in.getMessage()+" " + in.getClass().getName(), in);
	}
}
