/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.test.aggregation.c.generated;

import java.security.Permission;
import java.util.ArrayList;
import java.util.List;
import net.anotheria.util.IdCodeGenerator;
import net.anotheria.util.PidTools;
import org.distributeme.agents.transporter.generated.TransporterServer;
import org.distributeme.core.RegistryUtil;
import org.distributeme.core.ServerShutdownHook;
import org.distributeme.core.ServiceDescriptor;
import org.distributeme.core.Verbosity;
import org.distributeme.core.listener.ListenerRegistry;
import org.distributeme.core.listener.ServerLifecycleListener;
import org.distributeme.core.listener.ServerLifecycleListenerShutdownHook;
import org.distributeme.core.util.LocalServiceDescriptorStore;
import org.distributeme.support.eventservice.generated.EventServiceRMIBridgeServer;
import org.distributeme.support.lifecycle.generated.LifecycleSupportServer;
import org.distributeme.test.aggregation.a.generated.AServer;
import org.distributeme.test.aggregation.b.generated.BServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class CServer {
    private static Logger log;
    private static Marker FATAL;
    private static final List<ServerLifecycleListener> serverListeners;

    public static void main(String[] a) throws Exception {
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new SecurityManager(){

                @Override
                public void checkPermission(Permission perm) {
                }
            });
        }
        try {
            CServer.init();
            PidTools.logPid();
            Verbosity.logServerSideExceptions();
            CServer.createSupportServicesAndRegisterLocally();
            CServer.createCombinedServicesAndRegisterLocally();
            CServer.startService();
            CServer.notifyListenersAboutStart();
        }
        catch (Throwable e) {
            log.error(FATAL, "Unhandled exception caught", e);
            System.err.println(e.getMessage());
            System.exit(-4);
        }
    }

    private static void notifyListenersAboutStart() {
        List configuredListeners = ListenerRegistry.getInstance().getServerLifecycleListeners();
        if (configuredListeners != null && configuredListeners.size() > 0) {
            for (ServerLifecycleListener listener : configuredListeners) {
                try {
                    listener.afterStart();
                }
                catch (Exception e) {
                    log.error("Couldn't call afterStart on  listener " + listener, (Throwable)e);
                }
            }
        }
    }

    public static void init() throws Exception {
        log = LoggerFactory.getLogger(CServer.class);
    }

    public static void startService() throws Exception {
        String instanceId = IdCodeGenerator.generateCode((int)10);
        ServiceDescriptor aserverDescriptor = AServer.createDescriptor(instanceId);
        LocalServiceDescriptorStore.getInstance().addServiceDescriptor(aserverDescriptor);
        if (!RegistryUtil.bind((ServiceDescriptor)aserverDescriptor)) {
            log.error(FATAL, "Couldn't bind " + aserverDescriptor + " to the central registry at " + RegistryUtil.describeRegistry());
            System.err.println("Couldn't bind " + aserverDescriptor + " at the central registry at " + RegistryUtil.describeRegistry());
            System.exit(-3);
        }
        Runtime.getRuntime().addShutdownHook((Thread)new ServerShutdownHook(aserverDescriptor));
        System.out.println("Server " + aserverDescriptor.getServiceId() + " is up and ready.");
        ServiceDescriptor bserverDescriptor = BServer.createDescriptor(instanceId);
        LocalServiceDescriptorStore.getInstance().addServiceDescriptor(bserverDescriptor);
        if (!RegistryUtil.bind((ServiceDescriptor)bserverDescriptor)) {
            log.error(FATAL, "Couldn't bind " + bserverDescriptor + " to the central registry at " + RegistryUtil.describeRegistry());
            System.err.println("Couldn't bind " + bserverDescriptor + " at the central registry at " + RegistryUtil.describeRegistry());
            System.exit(-3);
        }
        Runtime.getRuntime().addShutdownHook((Thread)new ServerShutdownHook(bserverDescriptor));
        System.out.println("Server " + bserverDescriptor.getServiceId() + " is up and ready.");
        Runtime.getRuntime().addShutdownHook((Thread)new ServerLifecycleListenerShutdownHook(serverListeners));
    }

    public static void createSupportServicesAndRegisterLocally() throws Exception {
        LifecycleSupportServer.init();
        LifecycleSupportServer.createServiceAndRegisterLocally();
        EventServiceRMIBridgeServer.init();
        EventServiceRMIBridgeServer.createServiceAndRegisterLocally();
        TransporterServer.init();
        TransporterServer.createServiceAndRegisterLocally();
    }

    public static void createCombinedServicesAndRegisterLocally() throws Exception {
        CServer.createCombinedServicesAndRegisterLocally(-1);
    }

    public static void createCombinedServicesAndRegisterLocally(int customRegistryPort) throws Exception {
        AServer.init();
        AServer.createServiceAndRegisterLocally(customRegistryPort);
        BServer.init();
        BServer.createServiceAndRegisterLocally(customRegistryPort);
    }

    static {
        FATAL = MarkerFactory.getMarker((String)"FATAL");
        serverListeners = new ArrayList<ServerLifecycleListener>(0);
    }
}

