/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.test.asynch;

import org.distributeme.test.asynch.TestService;
import org.distributeme.test.asynch.TestServiceException;
import org.distributeme.test.asynch.generated.AsynchTestServiceStub;
import org.distributeme.test.asynch.generated.RemoteTestServiceStub;

public class SimpleClient {
    public static void main(String[] args) {
        AsynchTestServiceStub asynchTestService = new AsynchTestServiceStub();
        RemoteTestServiceStub synchTestService = new RemoteTestServiceStub();
        synchTestService.ping(System.currentTimeMillis());
        asynchTestService.ping(System.currentTimeMillis());
        System.out.println("Test Asynchron ");
        SimpleClient.testException(asynchTestService);
        asynchTestService.shutdown();
        System.out.println("Test Synchron ");
        SimpleClient.testException(synchTestService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void test(TestService testService) {
        long start = System.currentTimeMillis();
        long random = -1L;
        try {
            random = testService.sleepAndReturnRandom(1000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            long end = System.currentTimeMillis();
            System.out.println("Service replied " + random + " in " + (end - start) + " ms");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void testSleep(TestService testService) {
        long start = System.currentTimeMillis();
        try {
            testService.sleep(3000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            long end = System.currentTimeMillis();
            System.out.println("Service replied in " + (end - start) + " ms");
        }
    }

    private static final void testException(TestService testService) {
        long start = System.currentTimeMillis();
        try {
            testService.sleepAndThrowTypedException(1000L);
        }
        catch (TestServiceException e) {
            long end = System.currentTimeMillis();
            System.out.println("Service replied in " + (end - start) + " ms ---- " + e.getMessage());
        }
    }

    private static final void testException2(TestService testService) {
        long start = System.currentTimeMillis();
        try {
            testService.sleepAndThrowRuntimeException(50L);
        }
        catch (RuntimeException e) {
            long end = System.currentTimeMillis();
            System.out.println("Service replied in " + (end - start) + " ms ---- " + e.getMessage());
        }
    }
}

