/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.test.asynch;

import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.distributeme.test.asynch.TestService;
import org.distributeme.test.asynch.TestServiceException;

public class TestServiceImpl
implements TestService {
    private AtomicInteger requestCounter = new AtomicInteger();
    private Random rnd = new Random(System.currentTimeMillis());

    @Override
    public long ping(long param) {
        return param;
    }

    @Override
    public long sleepAndReturnRandom(long sleepTime) {
        int reqNumber = this.requestCounter.incrementAndGet();
        System.out.println("sarr REQ BEGIN " + reqNumber);
        int ret = this.rnd.nextInt(1000);
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println("sarr REQ FINISH " + reqNumber + ", will return " + ret);
        return ret;
    }

    @Override
    public void sleep(long sleepTime) {
        int reqNumber = this.requestCounter.incrementAndGet();
        System.out.println("sleep REQ BEGIN " + reqNumber);
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println("sleep REQ FINISH " + reqNumber);
    }

    @Override
    public void sleepAndThrowTypedException(long sleepTime) throws TestServiceException {
        int reqNumber = this.requestCounter.incrementAndGet();
        System.out.println("sleep REQ BEGIN " + reqNumber);
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println("sleep REQ FINISH " + reqNumber);
        throw new TestServiceException("Exception in req: " + reqNumber);
    }

    @Override
    public void sleepAndThrowRuntimeException(long sleepTime) {
        int reqNumber = this.requestCounter.incrementAndGet();
        System.out.println("sleep REQ BEGIN " + reqNumber);
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println("sleep REQ FINISH " + reqNumber);
        throw new RuntimeException("RT Exception in req: " + reqNumber);
    }
}

