/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.test.combined.generated;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.List;
import net.anotheria.anoprise.metafactory.Extension;
import net.anotheria.anoprise.metafactory.FactoryNotFoundException;
import net.anotheria.anoprise.metafactory.MetaFactory;
import net.anotheria.anoprise.metafactory.Service;
import net.anotheria.util.IdCodeGenerator;
import org.distributeme.core.RMIRegistryUtil;
import org.distributeme.core.RegistryUtil;
import org.distributeme.core.ServerShutdownHook;
import org.distributeme.core.ServiceDescriptor;
import org.distributeme.core.conventions.SystemProperties;
import org.distributeme.core.listener.ListenerRegistry;
import org.distributeme.core.listener.ServerLifecycleListener;
import org.distributeme.core.listener.ServerLifecycleListenerShutdownHook;
import org.distributeme.core.routing.RegistrationNameProvider;
import org.distributeme.core.routing.RoutingAware;
import org.distributeme.core.util.LocalServiceDescriptorStore;
import org.distributeme.test.combined.BusinessService;
import org.distributeme.test.combined.generated.BusinessServiceConstants;
import org.distributeme.test.combined.generated.RemoteBusinessService;
import org.distributeme.test.combined.generated.RemoteBusinessServiceSkeleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class BusinessServer {
    private static Logger log;
    private static Marker FATAL;
    private static final List<ServerLifecycleListener> serverListeners;
    private static RemoteBusinessService skeleton;
    private static RemoteBusinessService rmiServant;
    private static String serviceId;

    private static void notifyListenersAboutStart() {
        List configuredListeners = ListenerRegistry.getInstance().getServerLifecycleListeners();
        if (configuredListeners != null && configuredListeners.size() > 0) {
            for (ServerLifecycleListener listener : configuredListeners) {
                try {
                    listener.afterStart();
                }
                catch (Exception e) {
                    log.error("Couldn't call afterStart on  listener " + listener, (Throwable)e);
                }
            }
        }
    }

    public static void init() throws Exception {
        log = LoggerFactory.getLogger(BusinessServer.class);
    }

    public static void createServiceAndRegisterLocally() throws Exception {
        BusinessServer.createServiceAndRegisterLocally(-1);
    }

    public static void createServiceAndRegisterLocally(int customRegistryPort) throws Exception {
        try {
            Class<?> factoryClazz = Class.forName("org.distributeme.test.combined.BusinessServiceFactory");
            MetaFactory.addFactoryClass(BusinessService.class, (Extension)Extension.LOCAL, factoryClazz);
        }
        catch (ClassNotFoundException factoryNotFound) {
            try {
                Class<?> implClazz = Class.forName("org.distributeme.test.combined.BusinessServiceImpl");
                MetaFactory.createOnTheFlyFactory(BusinessService.class, (Extension)Extension.LOCAL, (Service)((Service)implClazz.newInstance()));
            }
            catch (ClassNotFoundException implNotFound) {
                log.info("Giving up trying to find an impl instance, tried org.distributeme.test.combined.BusinessServiceFactory and org.distributeme.test.combined.BusinessServiceImpl, expect start to fail since init code were empty too and no factory has been supplied explicitely");
            }
        }
        BusinessService impl = null;
        try {
            impl = (BusinessService)MetaFactory.get(BusinessService.class, (Extension)Extension.LOCAL);
        }
        catch (FactoryNotFoundException factoryNotFound) {
            throw new AssertionError((Object)"Un- or mis-configured, can't instantiate service instance for org.distributeme.test.combined.BusinessService tried initcode, submitted factory, autoguessed factory (org.distributeme.test.combined.BusinessServiceFactory) and impl class (org.distributeme.test.combined.BusinessServiceImpl)");
        }
        skeleton = new RemoteBusinessServiceSkeleton(impl);
        rmiServant = (RemoteBusinessService)UnicastRemoteObject.exportObject((Remote)skeleton, SystemProperties.SERVICE_BINDING_PORT.getAsInt());
        String definedServiceId = serviceId = BusinessServiceConstants.getServiceId();
        String regNameProviderClass = System.getProperty("dimeRegistrationNameProvider");
        if (regNameProviderClass != null) {
            RegistrationNameProvider suppliedNameProvider = (RegistrationNameProvider)Class.forName(regNameProviderClass).newInstance();
            serviceId = suppliedNameProvider.getRegistrationName(serviceId);
        }
        log.info("Getting local registry");
        Registry registry = null;
        try {
            registry = RMIRegistryUtil.findOrCreateRegistry((int)customRegistryPort);
        }
        catch (RemoteException e) {
            log.error(FATAL, "Couldn't obtain free port for a local rmi registry", (Throwable)e);
            System.err.println("Couldn't obtain a free port for local rmi registry");
            System.exit(-1);
        }
        log.info("Registering " + serviceId + " locally.");
        try {
            registry.rebind(serviceId, rmiServant);
        }
        catch (Exception e) {
            log.error(FATAL, "Couldn't rebind myself at the local registry", (Throwable)e);
            System.err.println("Couldn't rebind myself at the local registry");
            e.printStackTrace();
            System.exit(-2);
        }
        if (impl instanceof RoutingAware) {
            ((RoutingAware)impl).notifyServiceId(definedServiceId, serviceId, null, null);
        }
    }

    public static ServiceDescriptor createDescriptor(String instanceId) throws Exception {
        return RegistryUtil.createLocalServiceDescription((ServiceDescriptor.Protocol)ServiceDescriptor.Protocol.RMI, (String)serviceId, (String)instanceId, (int)RMIRegistryUtil.getRmiRegistryPort());
    }

    public static void startService() throws Exception {
        boolean registerCentrally;
        String instanceId = IdCodeGenerator.generateCode((int)10);
        boolean bl = registerCentrally = !SystemProperties.SKIP_CENTRAL_REGISTRY.getAsBoolean();
        if (registerCentrally) {
            ServiceDescriptor descriptor = BusinessServer.createDescriptor(instanceId);
            LocalServiceDescriptorStore.getInstance().addServiceDescriptor(descriptor);
            if (!RegistryUtil.bind((ServiceDescriptor)descriptor)) {
                log.error(FATAL, "Couldn't bind myself to the central registry at " + RegistryUtil.describeRegistry());
                System.err.println("Couldn't bind myself at the central registry at " + RegistryUtil.describeRegistry());
                System.exit(-3);
            }
            Runtime.getRuntime().addShutdownHook((Thread)new ServerShutdownHook(descriptor));
        } else {
            System.out.println("skipping registration for " + serviceId);
        }
        System.out.println("Server " + serviceId + " is up and ready.");
        Runtime.getRuntime().addShutdownHook((Thread)new ServerLifecycleListenerShutdownHook(serverListeners));
    }

    static {
        FATAL = MarkerFactory.getMarker((String)"FATAL");
        serverListeners = new ArrayList<ServerLifecycleListener>(0);
        skeleton = null;
        rmiServant = null;
        serviceId = null;
    }
}

