/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.test.concurrencycontrol;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import org.distributeme.core.ServiceLocator;
import org.distributeme.core.exception.DistributemeRuntimeException;
import org.distributeme.test.concurrencycontrol.TestService;

public class TestRun {
    public static final int THREADS = 10;
    private static final CountDownLatch ready = new CountDownLatch(10);
    private static final CountDownLatch start = new CountDownLatch(1);
    private static final CountDownLatch finish = new CountDownLatch(10);
    static long tsuccesses;
    static long ttotals;

    public static void test(final int limit, final Method method) throws Exception {
        ttotals = 0L;
        tsuccesses = 0L;
        System.out.println("STARTING " + limit + " " + method);
        final TestService service = (TestService)ServiceLocator.getRemote(TestService.class);
        for (int i = 0; i < 10; ++i) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    Random rnd = new Random(System.currentTimeMillis());
                    try {
                        ready.countDown();
                        start.await();
                        int tries = 0;
                        int successes = 0;
                        for (int i = 0; i < limit; ++i) {
                            ++tries;
                            try {
                                method.invoke((Object)service, System.currentTimeMillis());
                                ++successes;
                            }
                            catch (DistributemeRuntimeException distributemeRuntimeException) {
                            }
                            catch (InvocationTargetException invocationTargetException) {
                                // empty catch block
                            }
                            try {
                                Thread.sleep(rnd.nextInt(20));
                                continue;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        System.out.println("Thread " + this + " finished : tries: " + tries + " successes: " + successes);
                        tsuccesses += (long)successes;
                        ttotals += (long)tries;
                        finish.countDown();
                    }
                    catch (Exception ignored) {
                        ignored.printStackTrace();
                    }
                }
            });
            t.start();
        }
        System.out.println("Waiting for ready");
        ready.await();
        System.out.println("STARTING");
        start.countDown();
        finish.await();
        System.out.println("FINISHED " + tsuccesses + "/" + ttotals + " - " + tsuccesses * 100L / ttotals + " %.");
        service.printAndResetStats();
    }
}

