/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.test.concurrencycontrol;

import java.util.concurrent.atomic.AtomicLong;
import org.distributeme.test.concurrencycontrol.TestService;

public class TestServiceImpl
implements TestService {
    private AtomicLong clientSideLimitedConcurrentRequestCounter;
    private AtomicLong serverSideLimitedConcurrentRequestCounter;
    private AtomicLong bothSidesLimitedConcurrentRequestCounter;
    private AtomicLong clazzLevelLimitedConcurrentRequestCounter;
    private AtomicLong clientSideLimitedMaxRequestCount;
    private AtomicLong serverSideLimitedMaxRequestCount;
    private AtomicLong bothSidesLimitedMaxRequestCount;
    private AtomicLong clazzLevelLimitedMaxRequestCount;

    public TestServiceImpl() {
        this.resetStats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long clientSideLimited(long parameter) {
        long concurrentRequests = this.clientSideLimitedConcurrentRequestCounter.incrementAndGet();
        long currentMaxRequest = this.clientSideLimitedMaxRequestCount.get();
        if (currentMaxRequest < concurrentRequests) {
            this.clientSideLimitedMaxRequestCount.compareAndSet(currentMaxRequest, concurrentRequests);
        }
        try {
            Thread.sleep(5L);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.clientSideLimitedConcurrentRequestCounter.decrementAndGet();
        }
        return parameter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long serverSideLimited(long parameter) {
        long concurrentRequests = this.serverSideLimitedConcurrentRequestCounter.incrementAndGet();
        long currentMaxRequest = this.serverSideLimitedMaxRequestCount.get();
        if (currentMaxRequest < concurrentRequests) {
            this.serverSideLimitedMaxRequestCount.compareAndSet(currentMaxRequest, concurrentRequests);
        }
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.serverSideLimitedConcurrentRequestCounter.decrementAndGet();
        }
        return parameter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long bothSideLimited(long parameter) {
        long concurrentRequests = this.bothSidesLimitedConcurrentRequestCounter.incrementAndGet();
        long currentMaxRequest = this.bothSidesLimitedMaxRequestCount.get();
        if (currentMaxRequest < concurrentRequests) {
            this.bothSidesLimitedMaxRequestCount.compareAndSet(currentMaxRequest, concurrentRequests);
        }
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.bothSidesLimitedConcurrentRequestCounter.decrementAndGet();
        }
        return parameter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long clazzLevelServerSideLimited(long parameter) {
        long concurrentRequests = this.clazzLevelLimitedConcurrentRequestCounter.incrementAndGet();
        long currentMaxRequest = this.clazzLevelLimitedMaxRequestCount.get();
        if (currentMaxRequest < concurrentRequests) {
            this.clazzLevelLimitedMaxRequestCount.compareAndSet(currentMaxRequest, concurrentRequests);
        }
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.clazzLevelLimitedConcurrentRequestCounter.decrementAndGet();
        }
        return parameter;
    }

    @Override
    public void printAndResetStats() {
        this.printStats();
        this.resetStats();
    }

    @Override
    public void printStats() {
        System.out.println("Client side lock: current: " + this.clientSideLimitedConcurrentRequestCounter.get() + ", max: " + this.clientSideLimitedMaxRequestCount.get());
        System.out.println("Server side lock: current: " + this.serverSideLimitedConcurrentRequestCounter.get() + ", max: " + this.serverSideLimitedMaxRequestCount.get());
        System.out.println("Both   side lock: current: " + this.bothSidesLimitedConcurrentRequestCounter.get() + ", max: " + this.bothSidesLimitedMaxRequestCount.get());
        System.out.println("Clazz level lock: current: " + this.clazzLevelLimitedConcurrentRequestCounter.get() + ", max: " + this.clazzLevelLimitedMaxRequestCount.get());
        System.out.println("======================================");
    }

    private void resetStats() {
        this.clientSideLimitedConcurrentRequestCounter = new AtomicLong(0L);
        this.serverSideLimitedConcurrentRequestCounter = new AtomicLong(0L);
        this.bothSidesLimitedConcurrentRequestCounter = new AtomicLong(0L);
        this.clazzLevelLimitedConcurrentRequestCounter = new AtomicLong(0L);
        this.clientSideLimitedMaxRequestCount = new AtomicLong(0L);
        this.serverSideLimitedMaxRequestCount = new AtomicLong(0L);
        this.bothSidesLimitedMaxRequestCount = new AtomicLong(0L);
        this.clazzLevelLimitedMaxRequestCount = new AtomicLong(0L);
    }
}

