/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.test.echo;

import java.util.HashMap;
import org.distributeme.core.ServiceLocator;
import org.distributeme.test.echo.Echo;
import org.distributeme.test.echo.EchoService;
import org.distributeme.test.echo.EchoServiceException;

public class TestRemoteClient {
    public static void main(String[] a) throws Exception {
        EchoService service = (EchoService)ServiceLocator.getRemote(EchoService.class);
        service.printHello();
        System.out.println("sent printHello");
        Echo echo = new Echo();
        System.out.println("sending echo: " + echo);
        echo = service.echo(echo);
        System.out.println("received echo: " + echo);
        long limit = 1000L;
        long start = System.nanoTime();
        int i = 0;
        while ((long)i < limit) {
            echo = service.echo(echo);
            ++i;
        }
        long end = System.nanoTime();
        double duration = (double)(end - start) / 1000.0 / 1000.0;
        System.out.println("Sent " + limit + " requests in " + duration);
        System.out.println("avg req dur: " + duration / (double)limit + " ms.");
        String msg = "bla";
        try {
            service.throwException(msg);
        }
        catch (EchoServiceException e) {
            System.out.println("Expected exception " + msg + ", got: " + e.getMessage());
        }
        System.out.println("=== TESTING testCallByRef ===");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("CLIENTSIDE", "hello from client");
        System.out.println("Client side parameters.... " + params);
        service.testCallByRef(params);
        System.out.println("Client side parameters after call " + params);
        System.out.println("=== TESTING testCallByRefWithInterceptors ===");
        params = new HashMap();
        params.put("CLIENTSIDE", "hello from client");
        System.out.println("Client side parameters.... " + params);
        service.testCallByRefWithInterceptors(params);
        System.out.println("Client side parameters after call " + params);
    }
}

