/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.test.echo;

import org.distributeme.core.ServiceLocator;
import org.distributeme.test.echo.Echo;
import org.distributeme.test.echo.EchoService;
import org.distributeme.test.echo.EchoServiceException;

public class TestRemoteClientWithOffset {
    public static void main(String[] a) throws Exception {
        EchoService service = (EchoService)ServiceLocator.getRemote(EchoService.class);
        System.out.println("Sleeping 3 s");
        Thread.currentThread();
        Thread.sleep(3000L);
        service.printHello();
        System.out.println("sent printHello");
        Echo echo = new Echo();
        System.out.println("sending echo: " + echo);
        echo = service.echo(echo);
        System.out.println("received echo: " + echo);
        long limit = 10000L;
        long start = System.nanoTime();
        for (int i = 0; i < 10000; ++i) {
            echo = service.echo(echo);
        }
        long end = System.nanoTime();
        double duration = (double)(end - start) / 1000.0 / 1000.0;
        System.out.println("Sent " + limit + " requests in " + duration);
        System.out.println("avg req dur: " + duration / (double)limit + " ms.");
        String msg = "bla";
        try {
            service.throwException(msg);
        }
        catch (EchoServiceException e) {
            System.out.println("Expected exception " + msg + ", got: " + e.getMessage());
        }
    }
}

