/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.test.interception;

import java.util.HashMap;
import org.distributeme.core.ServiceLocator;
import org.distributeme.test.interception.TestService;
import org.distributeme.test.interception.TestServiceImpl;

public class TestClient {
    private static TestService testService;
    private static TestServiceImpl localInstance;

    public static void main(String[] args) {
        System.out.println("Remember to use startWithInterceptors.sh");
        testService = (TestService)ServiceLocator.getRemote(TestService.class);
        System.out.println("========================================================================");
        TestClient.testPiggybacking();
    }

    private static void testPiggybacking() {
        System.out.println("Passing some parameter map");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("Client says", "Hi");
        System.out.println("--------------");
        HashMap p2 = (HashMap)parameters.clone();
        System.out.println("Parameter map is " + p2);
        localInstance.callByValue(p2);
        System.out.println("After executing locally map is: " + p2);
        System.out.println("--------------");
        System.out.println("Calling same method remotely.");
        testService.callByValue(parameters);
        System.out.println(" --- now parameters are: " + parameters);
        System.out.println("--------------");
        System.out.println("Calling same method via intercepted method.");
        testService.callByReference(parameters);
        System.out.println(" --- now parameters are: " + parameters);
    }

    private static void testParameterInspection() {
        for (int i = 0; i < 50; ++i) {
            testService.sum(i, i);
        }
    }

    private static void testSumOverride() {
        int a = 10;
        int b = 15;
        System.out.println("Testing sum methods, parameters are " + a + " and " + b + ", expected result is: " + (a + b));
        System.out.println("Calling sum expecting " + localInstance.sum(a, b));
        System.out.println("Result is " + testService.sum(a, b));
        System.out.println();
        System.out.println("Calling modifiedSum expecting " + localInstance.modifiedSum(a, b));
        System.out.println("Result is " + testService.modifiedSum(a, b));
        System.out.println();
        System.out.println("Calling modifiedSumParameters expecting " + localInstance.modifiedSumParameters(a, b));
        System.out.println("Result is " + testService.modifiedSumParameters(a, b));
    }

    private static void testReturnValueOverride() {
        System.out.println("Calling server, expecting answer: \"" + localInstance.returnString() + "\"");
        System.out.println("Server returned: " + testService.returnString());
    }

    private static void testReturnInterceptedInClient() {
        System.out.println("Calling server, expecting answer: \"" + localInstance.returnStringCaughtInClient() + "\"");
        System.out.println("Server returned: " + testService.returnStringCaughtInClient());
    }

    static {
        localInstance = new TestServiceImpl();
    }
}

