/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.test.interception.interceptor;

import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import net.anotheria.util.NumberUtils;
import org.distributeme.core.ClientSideCallContext;
import org.distributeme.core.interceptor.AbstractClientSideRequestInterceptor;
import org.distributeme.core.interceptor.InterceptionContext;
import org.distributeme.core.interceptor.InterceptorResponse;

public class TestAbortCallInterceptor
extends AbstractClientSideRequestInterceptor {
    private Map<Thread, Entry> activeCalls = new HashMap<Thread, Entry>();
    Timer timer = new Timer("Interceptor", true);

    public TestAbortCallInterceptor() {
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                System.out.println("Timer is checking: " + TestAbortCallInterceptor.this.activeCalls);
                for (Entry e : TestAbortCallInterceptor.this.activeCalls.values()) {
                    if (!e.isExpired()) continue;
                    System.out.println(e + " expired ");
                    e.targetThread.interrupt();
                }
            }
        }, 0L, 1000L);
    }

    public InterceptorResponse beforeServiceCall(ClientSideCallContext context, InterceptionContext iContext) {
        if (!context.getServiceId().equals("org_distributeme_test_interception_TestService")) {
            return InterceptorResponse.CONTINUE;
        }
        if (!context.getMethodName().equals("sleepingCall")) {
            return InterceptorResponse.CONTINUE;
        }
        this.activeCalls.put(Thread.currentThread(), new Entry(Thread.currentThread()));
        System.out.println("added " + Thread.currentThread());
        return super.beforeServiceCall(context, iContext);
    }

    public InterceptorResponse afterServiceCall(ClientSideCallContext context, InterceptionContext iContext) {
        if (!context.getServiceId().equals("org_distributeme_test_interception_TestService")) {
            return InterceptorResponse.CONTINUE;
        }
        if (!context.getMethodName().equals("sleepingCall")) {
            return InterceptorResponse.CONTINUE;
        }
        this.activeCalls.remove(Thread.currentThread());
        System.out.println("removed " + Thread.currentThread());
        return super.afterServiceCall(context, iContext);
    }

    static class Entry {
        Thread targetThread;
        long passTime;

        Entry(Thread aTargetThread) {
            this.targetThread = aTargetThread;
            this.passTime = System.currentTimeMillis();
        }

        public boolean isExpired() {
            return System.currentTimeMillis() - this.passTime > 1500L;
        }

        public String toString() {
            return this.targetThread + " at " + NumberUtils.makeISO8601TimestampString((long)this.passTime);
        }
    }
}

