/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.test.lifecycle;

import java.util.List;
import java.util.Map;
import org.distributeme.core.RegistryUtil;
import org.distributeme.core.ServiceDescriptor;
import org.distributeme.support.lifecycle.generated.LifecycleSupportServiceConstants;
import org.distributeme.support.lifecycle.generated.RemoteLifecycleSupportServiceStub;
import org.distributeme.test.lifecycle.AbstractLifecycleTest;

public class CheckHealthStatus
extends AbstractLifecycleTest {
    public static void main(String[] args) throws Exception {
        String serviceListAsXML = RegistryUtil.getXMLServiceList();
        System.out.println("Servicelist: " + serviceListAsXML);
        List<ServiceDescriptor> descriptors = CheckHealthStatus.parse(serviceListAsXML);
        System.out.println("parsed list " + descriptors);
        for (ServiceDescriptor descriptor : descriptors) {
            System.out.println("Pinging " + descriptor.getSystemWideUniqueId());
            ServiceDescriptor lifeCycleDescriptor = descriptor.changeServiceId(LifecycleSupportServiceConstants.getServiceId());
            try {
                RemoteLifecycleSupportServiceStub service = new RemoteLifecycleSupportServiceStub(lifeCycleDescriptor);
                System.out.println(" Service online: " + service.isOnline());
                service.printStatusToSystemOut();
                Map statuses = service.getHealthStatuses();
                System.out.println("Statuses: " + statuses);
            }
            catch (Exception e) {
                System.out.println("Failed!");
                e.printStackTrace();
            }
            System.out.println("===========");
        }
    }
}

