/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.test.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.distributeme.core.routing.RoutingAware;
import org.distributeme.core.util.ServerSideUtils;
import org.distributeme.test.list.ListObject;
import org.distributeme.test.list.ListObjectId;
import org.distributeme.test.list.ListService;

public class ListServiceImpl
implements ListService,
RoutingAware {
    private HashMap<ListObjectId, ListObject> objects = new HashMap();

    public ListServiceImpl() {
        for (int i = 0; i < 100; ++i) {
            this.objects.put(new ListObjectId(i), new ListObject(i));
        }
    }

    @Override
    public ListObject getListObject(ListObjectId id) {
        System.out.println(this.failoverInfoString() + "%%% Called getListObject(" + id + ")");
        return this.objects.get(id);
    }

    @Override
    public Collection<ListObject> getListObjects() {
        System.out.println(this.failoverInfoString() + "%%% Called getListObjects()");
        ArrayList<ListObject> ret = new ArrayList<ListObject>();
        Collection<ListObject> all = this.objects.values();
        ret.addAll(all);
        return ret;
    }

    @Override
    public Collection<ListObject> getSomeListObjects(Collection<ListObjectId> ids) {
        System.out.println(this.failoverInfoString() + "%%% Called getListObjects() with " + ids.size() + " params, " + ids);
        ArrayList<ListObject> ret = new ArrayList<ListObject>();
        for (ListObjectId id : ids) {
            ret.add(this.objects.get(id));
        }
        System.out.println("%%% Returning " + ret);
        return ret;
    }

    @Override
    public Collection<ListObject> getListObjectsSharded() {
        System.out.println(this.failoverInfoString() + "%%% Called getListObjectsSharded()");
        return null;
    }

    @Override
    public Collection<ListObject> getSomeListObjectsSharded(Collection<ListObjectId> ids) {
        System.out.println(this.failoverInfoString() + "%%% Called getSomeListObjectsSharded() with " + ids.size() + " params, " + ids);
        return null;
    }

    private String failoverInfoString() {
        return this.isFailoverCall() ? "FAILOVER " + (ServerSideUtils.isBlacklisted() ? "-BLACKLIST-" : "") + " - " : "";
    }

    private boolean isFailoverCall() {
        return ServerSideUtils.isFailoverCall();
    }

    public void notifyServiceId(String definedServiceId, String registeredAsServiceId, String routingParameter, String configurationName) {
        System.out.println("I am " + definedServiceId + " registered as " + registeredAsServiceId);
        System.out.println("My Routing Param is " + routingParameter + ", myConfig name " + configurationName);
    }
}

