/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.test.roundrobinwithfotonext.interceptor;

import org.distributeme.core.ClientSideCallContext;
import org.distributeme.core.interceptor.ClientSideRequestInterceptor;
import org.distributeme.core.interceptor.InterceptionContext;
import org.distributeme.core.interceptor.InterceptorResponse;

public class ClientSideMarkLongRequestAsFailedInterceptor
implements ClientSideRequestInterceptor {
    public static final String START_ATTRIBUTE = ClientSideMarkLongRequestAsFailedInterceptor.class.getName() + "-start";
    public static final String TIMEOUT_PROPERTY = "availabilityTestingFailureTimeout";
    private long TIMEOUT = 60000L;

    public ClientSideMarkLongRequestAsFailedInterceptor() {
        String timeoutProperty = System.getProperty(TIMEOUT_PROPERTY);
        if (timeoutProperty != null && timeoutProperty.length() > 0) {
            this.TIMEOUT = Long.parseLong(timeoutProperty);
        }
    }

    public InterceptorResponse afterServiceCall(ClientSideCallContext context, InterceptionContext iContext) {
        long start = (Long)iContext.getLocalStore().get(START_ATTRIBUTE);
        long end = System.currentTimeMillis();
        long duration = end - start;
        if (duration > this.TIMEOUT) {
            System.out.println("%%% SLOW CALL " + duration);
            return InterceptorResponse.RETURN_AND_FAIL;
        }
        return InterceptorResponse.CONTINUE;
    }

    public InterceptorResponse beforeServiceCall(ClientSideCallContext context, InterceptionContext iContext) {
        iContext.getLocalStore().put(START_ATTRIBUTE, System.currentTimeMillis());
        return InterceptorResponse.CONTINUE;
    }
}

