/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.accumulation;

import net.anotheria.moskito.core.accumulation.Accumulator;
import net.anotheria.moskito.core.accumulation.AccumulatorDefinition;
import net.anotheria.moskito.core.accumulation.AccumulatorRepository;
import net.anotheria.moskito.core.stats.TimeUnit;

public final class Accumulators {
    public static final String DEFAULT_INTERVAL = "5m";

    private Accumulators() {
    }

    public static Accumulator createMemoryAccumulator1m(String name, String producerName, String valueName) {
        return Accumulators.createAccumulator(name, producerName, producerName, valueName, "1m");
    }

    public static Accumulator createMemoryAccumulator5m(String name, String producerName, String valueName) {
        return Accumulators.createAccumulator(name, producerName, producerName, valueName, DEFAULT_INTERVAL);
    }

    public static Accumulator createMemoryAccumulator(String name, String producerName, String valueName, String interval) {
        return Accumulators.createAccumulator(name, producerName, producerName, valueName, interval);
    }

    public static Accumulator createAccumulator(String name, String producerName, String statName, String valueName, String intervalName, TimeUnit timeUnit) {
        AccumulatorDefinition definition = new AccumulatorDefinition();
        definition.setName(name);
        definition.setProducerName(producerName);
        definition.setStatName(statName);
        definition.setValueName(valueName);
        definition.setIntervalName(intervalName);
        Accumulator acc = AccumulatorRepository.getInstance().createAccumulator(definition);
        return acc;
    }

    public static Accumulator createAccumulator(String name, String producerName, String statName, String valueName, String intervalName) {
        return Accumulators.createAccumulator(name, producerName, statName, valueName, intervalName, TimeUnit.MILLISECONDS);
    }

    public static void createServiceAVGAccumulator(String name, String producerName) {
        Accumulators.createServiceAVGAccumulator(name, producerName, DEFAULT_INTERVAL);
    }

    public static void createServiceAVGAccumulator(String name, String producerName, String interval) {
        Accumulators.createAccumulator(name, producerName, "cumulated", "AVG", interval);
    }

    public static void createServiceREQAccumulator(String name, String producerName) {
        Accumulators.createServiceREQAccumulator(name, producerName, DEFAULT_INTERVAL);
    }

    public static void createServiceREQAccumulator(String name, String producerName, String interval) {
        Accumulators.createAccumulator(name, producerName, "cumulated", "REQ", interval);
    }

    public static void createUrlAVGAccumulator(String name, String url) {
        Accumulators.createUrlAVGAccumulator(name, url, DEFAULT_INTERVAL);
    }

    public static void createUrlAVGAccumulator(String name, String url, String interval) {
        Accumulators.createAccumulator(name, "RequestURIFilter", url, "AVG", interval);
    }

    public static void createUrlREQAccumulator(String name, String url) {
        Accumulators.createUrlREQAccumulator(name, url, DEFAULT_INTERVAL);
    }

    public static void createUrlREQAccumulator(String name, String url, String interval) {
        Accumulators.createAccumulator(name, "RequestURIFilter", url, "REQ", interval);
    }

    public static void createUrlTotalTimeAccumulator(String name, String url) {
        Accumulators.createUrlTotalTimeAccumulator(name, url, DEFAULT_INTERVAL);
    }

    public static void createUrlTotalTimeAccumulator(String name, String url, String interval) {
        Accumulators.createAccumulator(name, "RequestURIFilter", url, "time", interval);
    }
}

