/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.calltrace;

import java.lang.reflect.Method;

public final class TracingUtil {
    private TracingUtil() {
    }

    public static String buildCall(Method method, Object[] parameters) {
        if (method == null) {
            throw new IllegalArgumentException("Parameter method can't be null");
        }
        StringBuilder call = new StringBuilder(method.getDeclaringClass().getSimpleName()).append('.').append(method.getName()).append("(");
        if (parameters != null && parameters.length > 0) {
            for (int i = 0; i < parameters.length; ++i) {
                call.append(parameters[i]);
                if (i >= parameters.length - 1) continue;
                call.append(", ");
            }
        }
        call.append(")");
        return call.toString();
    }
}

