/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.counter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.anotheria.moskito.core.predefined.Constants;
import net.anotheria.moskito.core.producers.AbstractStats;
import net.anotheria.moskito.core.stats.Interval;
import net.anotheria.moskito.core.stats.StatValue;
import net.anotheria.moskito.core.stats.TimeUnit;
import net.anotheria.moskito.core.stats.impl.StatValueFactory;

public abstract class GenericCounterStats
extends AbstractStats {
    private HashMap<String, StatValue> values = new HashMap();
    private final List<String> valueNames;

    protected GenericCounterStats(String name, Interval[] intervals, String firstCounter, String ... moreCounters) {
        super(name);
        StatValue firstCounterValue = StatValueFactory.createStatValue(0L, firstCounter, intervals);
        this.addStatValues(firstCounterValue);
        this.values.put(firstCounter, firstCounterValue);
        if (moreCounters != null) {
            for (String mc : moreCounters) {
                StatValue additionalValue = StatValueFactory.createStatValue(0L, mc, intervals);
                this.addStatValues(additionalValue);
                this.values.put(mc, additionalValue);
            }
        }
        this.valueNames = Collections.unmodifiableList(new ArrayList<String>(this.values.keySet()));
    }

    protected GenericCounterStats(String name, String firstCounter, String ... moreCounters) {
        this(name, Constants.getDefaultIntervals(), firstCounter, moreCounters);
    }

    public void inc(String counterName) {
        this.values.get(counterName).increase();
    }

    public void incBy(String counterName, long value) {
        this.values.get(counterName).increaseByLong(value);
    }

    public long get(String counterName, String intervalName) {
        return this.values.get(counterName).getValueAsLong(intervalName);
    }

    @Override
    public String toStatsString(String aIntervalName, TimeUnit unit) {
        StringBuilder s = new StringBuilder();
        s.append(this.getName()).append(' ');
        for (String value : this.values.keySet()) {
            s.append(value).append(": ");
            s.append(this.values.get(value).getValueAsLong(aIntervalName));
        }
        return s.toString();
    }

    @Override
    public String toString() {
        return this.getName() + " " + this.values.values();
    }

    public Set<String> getPossibleNames() {
        return this.values.keySet();
    }

    public abstract String describeForWebUI();

    @Override
    public String getValueByNameAsString(String valueName, String intervalName, TimeUnit timeUnit) {
        if (valueName == null || valueName.equals("")) {
            throw new AssertionError((Object)"Value name can not be empty");
        }
        valueName = valueName.toLowerCase();
        return "" + this.values.get(valueName).getValueAsLong(intervalName);
    }

    @Override
    public List<String> getAvailableValueNames() {
        return this.valueNames;
    }
}

