/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.decorators.predefined;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.moskito.core.decorators.AbstractDecorator;
import net.anotheria.moskito.core.decorators.value.DoubleValueAO;
import net.anotheria.moskito.core.decorators.value.LongValueAO;
import net.anotheria.moskito.core.decorators.value.StatValueAO;
import net.anotheria.moskito.core.predefined.CacheStats;
import net.anotheria.moskito.core.producers.IStats;
import net.anotheria.moskito.core.stats.TimeUnit;

public class CacheStatsDecorator
extends AbstractDecorator {
    private static final String[] CAPTIONS = new String[]{"Req", "Hit", "HR", "WR", "GC", "RO", "EX", "FI", "FR"};
    private static final String[] SHORT_EXPLANATIONS = new String[]{"Number of requests", "Number of hits", "Hit ratio", "Number of writes ", "Number of garbage collected items", "Number of rolled over items", "Number of expired items", "Number of filtered items", "Fill ratio"};
    private static final String[] EXPLANATIONS = new String[]{"Total number of retrieval requests", "Total number of hits among the requests", "Hit ratio (hits / requests). You want it as high as possible. 1.0 is max.", "Total number of writes (number of items put into the cache)", "Number of garbage collected items (only if the cache implementation uses SoftReferences)", "Number of rolled over items. Rollover is implementation specific, but for most caches with fixed sizes it will happen.", "Number of expired items (only if the cache supports expiration).", "Number of filtered items (only if the cache supports filtering).", "Fill ratio, how much storage place is actually used (if implemented by the cache :-))."};

    public CacheStatsDecorator() {
        super("Cache", CAPTIONS, SHORT_EXPLANATIONS, EXPLANATIONS);
    }

    @Override
    public List<StatValueAO> getValues(IStats statsObject, String interval, TimeUnit unit) {
        CacheStats stats = (CacheStats)statsObject;
        ArrayList<StatValueAO> ret = new ArrayList<StatValueAO>(CAPTIONS.length);
        int i = 0;
        ret.add(new LongValueAO(CAPTIONS[i++], stats.getRequests(interval)));
        ret.add(new LongValueAO(CAPTIONS[i++], stats.getHits(interval)));
        ret.add(new DoubleValueAO(CAPTIONS[i++], stats.getHitRatio(interval)));
        ret.add(new LongValueAO(CAPTIONS[i++], stats.getWrites(interval)));
        ret.add(new LongValueAO(CAPTIONS[i++], stats.getGarbageCollected(interval)));
        ret.add(new LongValueAO(CAPTIONS[i++], stats.getRolloverCount(interval)));
        ret.add(new LongValueAO(CAPTIONS[i++], stats.getExpired(interval)));
        ret.add(new LongValueAO(CAPTIONS[i++], stats.getFiltered(interval)));
        ret.add(new DoubleValueAO(CAPTIONS[i++], stats.getFillRatio(interval)));
        return ret;
    }
}

