/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.decorators.predefined;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.anotheria.moskito.core.decorators.IDecorator;
import net.anotheria.moskito.core.decorators.value.DoubleValueAO;
import net.anotheria.moskito.core.decorators.value.LongValueAO;
import net.anotheria.moskito.core.decorators.value.StatCaptionBean;
import net.anotheria.moskito.core.decorators.value.StatValueAO;
import net.anotheria.moskito.core.decorators.value.StringValueAO;
import net.anotheria.moskito.core.producers.GenericStats;
import net.anotheria.moskito.core.stats.TimeUnit;
import net.anotheria.moskito.core.stats.TypeAwareStatValue;
import net.anotheria.util.sorter.IComparable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericStatsDecorator
implements IDecorator<GenericStats> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericStatsDecorator.class);
    private final String name;
    private final List<StatCaptionBean> captions = new ArrayList<StatCaptionBean>();

    public GenericStatsDecorator(String name) {
        this.name = name;
    }

    public int compareTo(IComparable anotherComparable, int method) {
        return this.getName().compareToIgnoreCase(((IDecorator)anotherComparable).getName());
    }

    @Override
    public List<StatCaptionBean> getCaptions() {
        return Collections.unmodifiableList(this.captions);
    }

    public boolean isInitialized() {
        return !this.captions.isEmpty();
    }

    public void addCaption(String name, String type) {
        this.captions.add(new StatCaptionBean(name, name + " as " + type, ""));
    }

    @Override
    public String getExplanation(String caption) {
        for (StatCaptionBean scb : this.captions) {
            if (!scb.getCaption().equals(caption)) continue;
            return scb.getExplanation();
        }
        return "n.a.";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<StatValueAO> getValues(GenericStats stats, String interval, TimeUnit unit) {
        List<String> names = stats.getAvailableValueNames();
        ArrayList<StatValueAO> ret = new ArrayList<StatValueAO>(names.size());
        block4: for (String name : names) {
            TypeAwareStatValue sValue = stats.getValueByName(name);
            if (sValue == null) {
                LOGGER.info("unable to determine value for name: " + name);
                continue;
            }
            switch (sValue.getType()) {
                case DOUBLE: {
                    ret.add(new DoubleValueAO(name, sValue.getValueAsDouble(interval)));
                    continue block4;
                }
                case INT: 
                case LONG: {
                    ret.add(new LongValueAO(name, sValue.getValueAsLong(interval)));
                    continue block4;
                }
            }
            ret.add(new StringValueAO(name, sValue.getValueAsString(interval)));
        }
        return ret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("GenericStatsDecorator: ").append(this.name).append(" - ");
        for (StatCaptionBean c : this.captions) {
            sb.append(c.getCaption()).append("; ");
        }
        return sb.toString();
    }
}

