/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.decorators.predefined;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.moskito.core.decorators.AbstractDecorator;
import net.anotheria.moskito.core.decorators.value.DoubleValueAO;
import net.anotheria.moskito.core.decorators.value.LongValueAO;
import net.anotheria.moskito.core.decorators.value.StatValueAO;
import net.anotheria.moskito.core.predefined.PageInBrowserStats;
import net.anotheria.moskito.core.producers.IStats;
import net.anotheria.moskito.core.stats.TimeUnit;

public class PageInBrowserStatsDecorator
extends AbstractDecorator {
    private static final String[] CAPTIONS = PageInBrowserStatsDecoratorValueName.getCaptions();
    private static final String[] SHORT_EXPLANATIONS = PageInBrowserStatsDecoratorValueName.getShortExplanations();
    private static final String[] EXPLANATIONS = PageInBrowserStatsDecoratorValueName.getExplanations();

    public PageInBrowserStatsDecorator() {
        super("PageInBrowserStats", CAPTIONS, SHORT_EXPLANATIONS, EXPLANATIONS);
    }

    @Override
    public List<StatValueAO> getValues(IStats stats, String interval, TimeUnit unit) {
        PageInBrowserStats pageInBrowserStats = (PageInBrowserStats)stats;
        long domMinLoadTime = pageInBrowserStats.getDomMinLoadTime(interval, unit);
        long domMaxLoadTime = pageInBrowserStats.getDomMaxLoadTime(interval, unit);
        double domAverageLoadTime = pageInBrowserStats.getAverageDOMLoadTime(interval, unit);
        long domLastLoadTime = pageInBrowserStats.getDomLastLoadTime(interval, unit);
        long winMinLoadTime = pageInBrowserStats.getWindowMinLoadTime(interval, unit);
        long winMaxLoadTime = pageInBrowserStats.getWindowMaxLoadTime(interval, unit);
        double winAverageLoadTime = pageInBrowserStats.getAverageWindowLoadTime(interval, unit);
        long winLastLoadTime = pageInBrowserStats.getWindowLastLoadTime(interval, unit);
        long totalDomLoadTime = pageInBrowserStats.getTotalDomLoadTime(interval, unit);
        long totalWinLoadTime = pageInBrowserStats.getTotalWindowLoadTime(interval, unit);
        long numberOfLoads = pageInBrowserStats.getNumberOfLoads();
        ArrayList<StatValueAO> result = new ArrayList<StatValueAO>();
        result.add(new LongValueAO(PageInBrowserStatsDecoratorValueName.DOM_MIN.getCaption(), domMinLoadTime));
        result.add(new LongValueAO(PageInBrowserStatsDecoratorValueName.DOM_MAX.getCaption(), domMaxLoadTime));
        result.add(new DoubleValueAO(PageInBrowserStatsDecoratorValueName.DOM_AVG.getCaption(), domAverageLoadTime));
        result.add(new LongValueAO(PageInBrowserStatsDecoratorValueName.DOM_LAST.getCaption(), domLastLoadTime));
        result.add(new LongValueAO(PageInBrowserStatsDecoratorValueName.DOM_TOTAL.getCaption(), totalDomLoadTime));
        result.add(new LongValueAO(PageInBrowserStatsDecoratorValueName.WIN_MIN.getCaption(), winMinLoadTime));
        result.add(new LongValueAO(PageInBrowserStatsDecoratorValueName.WIN_MAX.getCaption(), winMaxLoadTime));
        result.add(new DoubleValueAO(PageInBrowserStatsDecoratorValueName.WIN_AVG.getCaption(), winAverageLoadTime));
        result.add(new LongValueAO(PageInBrowserStatsDecoratorValueName.WIN_LAST.getCaption(), winLastLoadTime));
        result.add(new LongValueAO(PageInBrowserStatsDecoratorValueName.WIN_TOTAL.getCaption(), totalWinLoadTime));
        result.add(new LongValueAO(PageInBrowserStatsDecoratorValueName.NUMBER_OF_LOADS.getCaption(), numberOfLoads));
        return result;
    }

    public static enum PageInBrowserStatsDecoratorValueName {
        DOM_MIN("DOMMin", "DOM minimum load time", "DOM minimum load time"),
        DOM_MAX("DOMMax", "DOM maximum load time", "DOM maximum load time"),
        DOM_AVG("DOMAvg", "DOM average load time", "DOM average load time"),
        DOM_LAST("DOMLast", "DOM last load time", "DOM last load time"),
        DOM_TOTAL("DOMTotal", "DOM total loads time", "DOM total loads time"),
        WIN_MIN("WindowMin", "Window minimum load time", "Web page minimum load time - including DOM, images, scripts and sub-frames."),
        WIN_MAX("WindowMax", "Window maximum load time", "Web page maximum load time - including DOM, images, scripts and sub-frames."),
        WIN_AVG("WindowAvg", "Window average load time", "Web page average load time - including DOM, images, scripts and sub-frames."),
        WIN_LAST("WindowLast", "Window last load time", "Web page average load time - including DOM, images, scripts and sub-frames."),
        WIN_TOTAL("WindowTotal", "Window total loads time", "Web page total loads time"),
        NUMBER_OF_LOADS("Count", "Total number of loads", "Total number of web page loads");

        private String caption;
        private String shortExplanation;
        private String explanation;

        private PageInBrowserStatsDecoratorValueName(String caption, String shortExplanation, String explanation) {
            this.caption = caption;
            this.shortExplanation = shortExplanation;
            this.explanation = explanation;
        }

        public String getCaption() {
            return this.caption;
        }

        public String getShortExplanation() {
            return this.shortExplanation;
        }

        public String getExplanation() {
            return this.explanation;
        }

        public static String[] getCaptions() {
            ArrayList<String> result = new ArrayList<String>(PageInBrowserStatsDecoratorValueName.values().length);
            for (PageInBrowserStatsDecoratorValueName valueName : PageInBrowserStatsDecoratorValueName.values()) {
                result.add(valueName.getCaption());
            }
            return result.toArray(new String[result.size()]);
        }

        public static String[] getShortExplanations() {
            ArrayList<String> result = new ArrayList<String>(PageInBrowserStatsDecoratorValueName.values().length);
            for (PageInBrowserStatsDecoratorValueName valueName : PageInBrowserStatsDecoratorValueName.values()) {
                result.add(valueName.getShortExplanation());
            }
            return result.toArray(new String[result.size()]);
        }

        public static String[] getExplanations() {
            ArrayList<String> result = new ArrayList<String>(PageInBrowserStatsDecoratorValueName.values().length);
            for (PageInBrowserStatsDecoratorValueName valueName : PageInBrowserStatsDecoratorValueName.values()) {
                result.add(valueName.getExplanation());
            }
            return result.toArray(new String[result.size()]);
        }
    }
}

