/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.decorators.predefined;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.moskito.core.decorators.AbstractDecorator;
import net.anotheria.moskito.core.decorators.value.LongValueAO;
import net.anotheria.moskito.core.decorators.value.StatValueAO;
import net.anotheria.moskito.core.decorators.value.StringValueAO;
import net.anotheria.moskito.core.predefined.RuntimeStats;
import net.anotheria.moskito.core.producers.IStats;
import net.anotheria.moskito.core.stats.TimeUnit;
import net.anotheria.util.NumberUtils;

public class RuntimeStatsDecorator
extends AbstractDecorator {
    private static final String[] CAPTIONS = new String[]{"Name", "StartTime", "Uptime", "StartDate", "Uphours", "Updays"};
    private static final String[] SHORT_EXPLANATIONS = new String[]{"Name of the process", "StartTime in ms", "Uptime in ms", "StartDate as ISO8601", "Uphours", "Updays"};
    private static final String[] EXPLANATIONS = new String[]{"Name of the process", "Starttime of the process in ms since 1970", "Uptime in ms since start", "StartDate as ISO8601", "Uphours", "Updays"};

    public RuntimeStatsDecorator() {
        this("Runtime");
    }

    public RuntimeStatsDecorator(String aName) {
        super(aName, CAPTIONS, SHORT_EXPLANATIONS, EXPLANATIONS);
    }

    @Override
    public List<StatValueAO> getValues(IStats statsObject, String interval, TimeUnit unit) {
        RuntimeStats stats = (RuntimeStats)statsObject;
        ArrayList<StatValueAO> ret = new ArrayList<StatValueAO>(CAPTIONS.length);
        long starttime = stats.getStartTime(interval);
        long uptime = stats.getUptime(interval);
        int i = 0;
        ret.add(new StringValueAO(CAPTIONS[i++], stats.getProcessName(interval)));
        ret.add(new LongValueAO(CAPTIONS[i++], starttime));
        ret.add(new LongValueAO(CAPTIONS[i++], uptime));
        ret.add(new StringValueAO(CAPTIONS[i++], NumberUtils.makeISO8601TimestampString((long)starttime)));
        ret.add(new LongValueAO(CAPTIONS[i++], uptime / 1000L / 60L / 60L));
        ret.add(new StringValueAO(CAPTIONS[i++], "" + (float)(uptime * 100L / 1000L / 60L / 60L / 24L) / 100.0f));
        return ret;
    }
}

