/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.decorators.predefined;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.moskito.core.decorators.AbstractDecorator;
import net.anotheria.moskito.core.decorators.value.LongValueAO;
import net.anotheria.moskito.core.decorators.value.StatValueAO;
import net.anotheria.moskito.core.predefined.ThreadCountStats;
import net.anotheria.moskito.core.producers.IStats;
import net.anotheria.moskito.core.stats.TimeUnit;

public class ThreadCountDecorator
extends AbstractDecorator {
    private static final String[] CAPTIONS = new String[]{"Started", "Min Cur", "Current", "Max Cur", "Daemon"};
    private static final String[] SHORT_EXPLANATIONS = new String[]{"Total number of started threads", "Min number of currently running threads", "Number of currently running threads", "Max number of currently running threads", "Total number of started daemon threads"};
    private static final String[] EXPLANATIONS = new String[]{"Total number of started threads", "Min number of currently running threads", "Number of currently running threads", "Max number of currently running threads", "Total number of started daemon threads"};

    public ThreadCountDecorator() {
        super("ThreadCount", CAPTIONS, SHORT_EXPLANATIONS, EXPLANATIONS);
    }

    @Override
    public List<StatValueAO> getValues(IStats statsObject, String interval, TimeUnit unit) {
        ThreadCountStats stats = (ThreadCountStats)statsObject;
        ArrayList<StatValueAO> ret = new ArrayList<StatValueAO>(CAPTIONS.length);
        int i = 0;
        ret.add(new LongValueAO(CAPTIONS[i++], stats.getStarted(interval)));
        ret.add(new LongValueAO(CAPTIONS[i++], stats.getMinCurrent(interval)));
        ret.add(new LongValueAO(CAPTIONS[i++], stats.getCurrent(interval)));
        ret.add(new LongValueAO(CAPTIONS[i++], stats.getMaxCurrent(interval)));
        ret.add(new LongValueAO(CAPTIONS[i++], stats.getDaemon(interval)));
        return ret;
    }
}

