/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.decorators.value;

import net.anotheria.moskito.core.decorators.value.StatValueAO;
import net.anotheria.util.BasicComparable;
import net.anotheria.util.sorter.IComparable;

public class DoubleValueAO
extends StatValueAO {
    private double doubleValue;
    private String doubleAsString;

    public DoubleValueAO(String name, double aValue) {
        super(name);
        this.doubleValue = !Double.isInfinite(aValue) ? (double)Math.round(aValue * 1000.0) / 1000.0 : aValue;
        double floatingPart = this.doubleValue - (double)((int)this.doubleValue);
        String fpAsString = "" + floatingPart;
        if (fpAsString.length() > 6) {
            fpAsString = fpAsString.substring(0, 5);
        }
        while (fpAsString.length() < 5) {
            fpAsString = fpAsString + "0";
        }
        this.doubleAsString = (int)this.doubleValue + "." + fpAsString.substring(2);
    }

    @Override
    public String getValue() {
        return this.doubleAsString;
    }

    @Override
    public String getType() {
        return "double";
    }

    public int compareTo(IComparable anotherComparable, int ignored) {
        return BasicComparable.compareDouble((double)this.doubleValue, (double)((DoubleValueAO)anotherComparable).doubleValue);
    }

    @Override
    public String getRawValue() {
        return "" + this.doubleValue;
    }
}

