/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.predefined;

import net.anotheria.moskito.core.predefined.AbstractMemoryPoolStats;
import net.anotheria.moskito.core.predefined.Constants;
import net.anotheria.moskito.core.predefined.IMemoryPoolStats;
import net.anotheria.moskito.core.stats.Interval;
import net.anotheria.moskito.core.stats.StatValue;
import net.anotheria.moskito.core.stats.TimeUnit;
import net.anotheria.moskito.core.stats.impl.StatValueFactory;

public class MemoryPoolStats
extends AbstractMemoryPoolStats
implements IMemoryPoolStats {
    private StatValue init;
    private StatValue used;
    private StatValue minUsed;
    private StatValue maxUsed;
    private StatValue commited;
    private StatValue minCommited;
    private StatValue maxCommited;
    private StatValue max;

    public MemoryPoolStats() {
        this("unnamed", Constants.getDefaultIntervals());
    }

    public MemoryPoolStats(String aName) {
        this(aName, Constants.getDefaultIntervals());
    }

    public MemoryPoolStats(String aName, Interval[] selectedIntervals) {
        super(aName);
        this.init = StatValueFactory.createStatValue(0L, "init", selectedIntervals);
        this.used = StatValueFactory.createStatValue(0L, "used", selectedIntervals);
        this.minUsed = StatValueFactory.createStatValue(0L, "minUsed", selectedIntervals);
        this.minUsed.setDefaultValueAsLong(Integer.MAX_VALUE);
        this.minUsed.reset();
        this.maxUsed = StatValueFactory.createStatValue(0L, "maxUsed", selectedIntervals);
        this.commited = StatValueFactory.createStatValue(0L, "commited", selectedIntervals);
        this.minCommited = StatValueFactory.createStatValue(0L, "minCommited", selectedIntervals);
        this.minCommited.setDefaultValueAsLong(Integer.MAX_VALUE);
        this.minCommited.reset();
        this.maxCommited = StatValueFactory.createStatValue(0L, "maxCommited", selectedIntervals);
        this.max = StatValueFactory.createStatValue(0L, "max", selectedIntervals);
        this.addStatValues(this.init, this.used, this.minUsed, this.maxUsed, this.commited, this.minCommited, this.maxCommited, this.max);
    }

    @Override
    public String toStatsString(String intervalName, TimeUnit timeUnit) {
        StringBuilder b = new StringBuilder();
        b.append(this.getName()).append(' ');
        b.append(" INIT: ").append(this.init.getValueAsLong(intervalName));
        b.append(" MIN USED: ").append(this.minUsed.getValueAsLong(intervalName));
        b.append(" USED: ").append(this.used.getValueAsLong(intervalName));
        b.append(" MAX USED: ").append(this.maxUsed.getValueAsLong(intervalName));
        b.append(" MIN COMMITED: ").append(this.minCommited.getValueAsLong(intervalName));
        b.append(" COMMITED: ").append(this.commited.getValueAsLong(intervalName));
        b.append(" MAX COMMITED: ").append(this.maxCommited.getValueAsLong(intervalName));
        b.append(" MAX: ").append(this.max.getValueAsLong(intervalName));
        return b.toString();
    }

    @Override
    public long getInit(String intervalName) {
        return this.init.getValueAsLong(intervalName);
    }

    @Override
    public long getUsed(String intervalName) {
        return this.used.getValueAsLong(intervalName);
    }

    @Override
    public long getMinUsed(String intervalName) {
        return this.minUsed.getValueAsLong(intervalName);
    }

    @Override
    public long getMaxUsed(String intervalName) {
        return this.maxUsed.getValueAsLong(intervalName);
    }

    @Override
    public long getCommited(String intervalName) {
        return this.commited.getValueAsLong(intervalName);
    }

    @Override
    public long getMinCommited(String intervalName) {
        return this.minCommited.getValueAsLong(intervalName);
    }

    @Override
    public long getMaxCommited(String intervalName) {
        return this.maxCommited.getValueAsLong(intervalName);
    }

    @Override
    public long getMax(String intervalName) {
        return this.max.getValueAsLong(intervalName);
    }

    @Override
    public long getFree(String intervalName) {
        return this.getCommited(intervalName) - this.getUsed(intervalName);
    }

    public void setInit(long value) {
        this.init.setValueAsLong(value);
    }

    public void setMax(long value) {
        this.init.setValueAsLong(value);
    }

    public void setUsed(long value) {
        this.used.setValueAsLong(value);
        this.minUsed.setValueIfLesserThanCurrentAsLong(value);
        this.maxUsed.setValueIfGreaterThanCurrentAsLong(value);
    }

    public void setCommited(long value) {
        this.commited.setValueAsLong(value);
        this.minCommited.setValueIfLesserThanCurrentAsLong(value);
        this.maxCommited.setValueIfGreaterThanCurrentAsLong(value);
    }
}

