/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.predefined;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.anotheria.moskito.core.calltrace.CurrentlyTracedCall;
import net.anotheria.moskito.core.calltrace.RunningTraceContainer;
import net.anotheria.moskito.core.calltrace.TraceStep;
import net.anotheria.moskito.core.calltrace.TracedCall;
import net.anotheria.moskito.core.predefined.Constants;
import net.anotheria.moskito.core.producers.AbstractCallExecution;
import net.anotheria.moskito.core.producers.AbstractStats;
import net.anotheria.moskito.core.producers.CallExecution;
import net.anotheria.moskito.core.stats.Interval;
import net.anotheria.moskito.core.stats.StatValue;
import net.anotheria.moskito.core.stats.TimeUnit;
import net.anotheria.moskito.core.stats.impl.StatValueFactory;

public abstract class RequestOrientedStats
extends AbstractStats {
    private transient Interval[] selectedIntervals;
    private String methodName;
    private StatValue totalRequests;
    private StatValue totalTime;
    private StatValue currentRequests;
    private StatValue errors;
    private StatValue maxCurrentRequests;
    private StatValue lastRequest;
    private StatValue minTime;
    private StatValue maxTime;
    private static final List<String> VALUE_NAMES = Collections.unmodifiableList(Arrays.asList("TR", "TT", "CR", "MCR", "ERR", "Last", "Min", "Max", "Avg"));

    public RequestOrientedStats(String aMethodName) {
        this(aMethodName, Constants.getDefaultIntervals());
    }

    public RequestOrientedStats() {
        this("unnamed", Constants.getDefaultIntervals());
    }

    public RequestOrientedStats(String aMethodName, Interval[] aSelectedIntervals) {
        this.methodName = aMethodName;
        Long pattern = 0L;
        this.selectedIntervals = Arrays.copyOf(aSelectedIntervals, aSelectedIntervals.length);
        this.totalRequests = StatValueFactory.createStatValue(pattern, "requests", aSelectedIntervals);
        this.totalTime = StatValueFactory.createStatValue(pattern, "totalTime", aSelectedIntervals);
        this.currentRequests = StatValueFactory.createStatValue(pattern, "currentRequests", aSelectedIntervals);
        this.maxCurrentRequests = StatValueFactory.createStatValue(pattern, "maxCurrentRequests", aSelectedIntervals);
        this.errors = StatValueFactory.createStatValue(pattern, "errors", aSelectedIntervals);
        this.lastRequest = StatValueFactory.createStatValue(pattern, "last", aSelectedIntervals);
        this.minTime = StatValueFactory.createStatValue(pattern, "minTime", aSelectedIntervals);
        this.minTime.setDefaultValueAsLong(Long.MAX_VALUE);
        this.minTime.reset();
        this.maxTime = StatValueFactory.createStatValue(pattern, "maxTime", aSelectedIntervals);
        this.maxTime.setDefaultValueAsLong(Long.MIN_VALUE);
        this.maxTime.reset();
        this.addStatValues(this.totalRequests, this.totalTime, this.currentRequests, this.maxCurrentRequests, this.errors, this.lastRequest, this.minTime, this.maxTime);
    }

    public void addRequest() {
        this.totalRequests.increase();
        this.currentRequests.increase();
        this.maxCurrentRequests.setValueIfGreaterThanCurrentAsLong(this.currentRequests.getValueAsLong());
    }

    public void notifyRequestFinished() {
        this.currentRequests.decrease();
    }

    public void notifyError() {
        this.errors.increase();
    }

    public void addExecutionTime(long time) {
        this.totalTime.increaseByLong(time);
        this.lastRequest.setValueAsLong(time);
        this.minTime.setValueIfLesserThanCurrentAsLong(time);
        this.maxTime.setValueIfGreaterThanCurrentAsLong(time);
    }

    public double getAverageRequestDuration() {
        return this.getAverageRequestDuration(null);
    }

    public double getAverageRequestDuration(String intervalName) {
        return this.totalTime.getValueAsDouble(intervalName) / this.totalRequests.getValueAsDouble(intervalName);
    }

    public double getAverageRequestDuration(String intervalName, TimeUnit unit) {
        return (double)unit.transformNanos(this.totalTime.getValueAsLong(intervalName)) / this.totalRequests.getValueAsDouble(intervalName);
    }

    public double getErrorRate(String intervalName) {
        long tr = this.getTotalRequests(intervalName);
        double errorRate = tr == 0L ? 0.0 : (double)this.getErrors(intervalName) / (double)tr;
        return (double)((int)(errorRate * 10000.0)) / 100.0;
    }

    @Override
    public String toString() {
        return this.toString(null);
    }

    @Override
    public String toStatsString(String intervalName, TimeUnit timeUnit) {
        StringBuilder ret = new StringBuilder();
        ret.append(this.getMethodName());
        ret.append(" TR: ").append(this.totalRequests.getValueAsLong(intervalName));
        ret.append(" TT: ").append(timeUnit.transformNanos(this.totalTime.getValueAsLong(intervalName)));
        ret.append(" CR: ").append(this.currentRequests.getValueAsLong(intervalName));
        ret.append(" MCR: ").append(this.maxCurrentRequests.getValueAsLong(intervalName));
        ret.append(" ERR: ").append(this.errors.getValueAsLong(intervalName));
        ret.append(" Last: ").append(timeUnit.transformNanos(this.lastRequest.getValueAsLong(intervalName)));
        long minTimeTmp = this.minTime.getValueAsLong(intervalName);
        ret.append(" Min: ");
        if (minTimeTmp == Long.MAX_VALUE) {
            ret.append("NoR");
        } else {
            ret.append(timeUnit.transformNanos(minTimeTmp));
        }
        long maxTimeTmp = this.maxTime.getValueAsLong(intervalName);
        ret.append(" Max: ");
        if (maxTimeTmp == Long.MIN_VALUE) {
            ret.append("NoR");
        } else {
            ret.append(timeUnit.transformNanos(maxTimeTmp));
        }
        ret.append(" Avg: ").append(this.getAverageRequestDuration(intervalName, timeUnit));
        ret.append(" ERate: ").append(this.getErrorRate(intervalName));
        return ret.toString();
    }

    @Override
    public String getValueByNameAsString(String valueName, String intervalName, TimeUnit timeUnit) {
        if (valueName == null || valueName.equals("")) {
            throw new AssertionError((Object)"Value name can not be empty");
        }
        if ((valueName = valueName.toLowerCase()).equals("tr") || valueName.equals("req")) {
            return "" + this.totalRequests.getValueAsLong(intervalName);
        }
        if (valueName.equals("tt") || valueName.equals("time") || valueName.equals("totaltime")) {
            return "" + timeUnit.transformNanos(this.totalTime.getValueAsLong(intervalName));
        }
        if (valueName.equals("cr")) {
            return "" + this.currentRequests.getValueAsLong(intervalName);
        }
        if (valueName.equals("mcr")) {
            return "" + this.maxCurrentRequests.getValueAsLong(intervalName);
        }
        if (valueName.equals("err")) {
            return "" + this.errors.getValueAsLong(intervalName);
        }
        if (valueName.equals("last")) {
            return "" + timeUnit.transformNanos(this.lastRequest.getValueAsLong(intervalName));
        }
        if (valueName.equals("min")) {
            return "" + timeUnit.transformNanos(this.minTime.getValueAsLong(intervalName));
        }
        if (valueName.equals("max")) {
            return "" + timeUnit.transformNanos(this.maxTime.getValueAsLong(intervalName));
        }
        if (valueName.equals("avg")) {
            return "" + this.getAverageRequestDuration(intervalName, timeUnit);
        }
        if (valueName.equals("erate") || valueName.equals("errorrate") || valueName.equals("errrate")) {
            return "" + this.getErrorRate(intervalName);
        }
        return super.getValueByNameAsString(valueName, intervalName, timeUnit);
    }

    public String toString(String intervalName) {
        String ret = this.methodName;
        ret = ret + this.toStatsString(intervalName);
        return ret;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String string) {
        this.methodName = string;
    }

    public long getTotalRequests(String intervalName) {
        return this.totalRequests.getValueAsLong(intervalName);
    }

    public long getTotalRequests() {
        return this.totalRequests.getValueAsLong(null);
    }

    public long getTotalTime() {
        return this.getTotalTime(null);
    }

    public long getTotalTime(String intervalName) {
        return this.totalTime.getValueAsLong(intervalName);
    }

    public long getCurrentRequests(String intervalName) {
        return this.currentRequests.getValueAsLong(intervalName);
    }

    public long getCurrentRequests() {
        return this.getCurrentRequests(null);
    }

    public long getMaxCurrentRequests(String intervalName) {
        return this.maxCurrentRequests.getValueAsLong(intervalName);
    }

    public long getMaxCurrentRequests() {
        return this.getMaxCurrentRequests(null);
    }

    public long getErrors() {
        return this.getErrors(null);
    }

    public long getErrors(String intervalName) {
        return this.errors.getValueAsLong(intervalName);
    }

    public long getLastRequest() {
        return this.getLastRequest(null);
    }

    public long getLastRequest(String intervalName) {
        return this.lastRequest.getValueAsLong(intervalName);
    }

    public Interval[] getSelectedIntervals() {
        return Arrays.copyOf(this.selectedIntervals, this.selectedIntervals.length);
    }

    public void setSelectedIntervals(Interval[] selectedIntervals) {
        this.selectedIntervals = Arrays.copyOf(selectedIntervals, selectedIntervals.length);
    }

    public long getMinTime(String intervalName) {
        return this.minTime.getValueAsLong(intervalName);
    }

    public long getMinTime() {
        return this.minTime.getValueAsLong(null);
    }

    public long getMaxTime(String intervalName) {
        return this.maxTime.getValueAsLong(intervalName);
    }

    public long getMaxTime() {
        return this.maxTime.getValueAsLong(null);
    }

    @Override
    public String getName() {
        return this.methodName;
    }

    @Override
    public CallExecution createCallExecution() {
        return new RequestCallExecution();
    }

    @Override
    public List<String> getAvailableValueNames() {
        return VALUE_NAMES;
    }

    @Override
    public boolean isEmpty(String intervalName) {
        return this.getCurrentRequests(intervalName) == 0L;
    }

    private class RequestCallExecution
    extends AbstractCallExecution {
        private long startTime;
        private TraceStep currentStep = null;
        private CurrentlyTracedCall currentlyTracedCall = null;
        private long duration = 0L;

        private RequestCallExecution() {
        }

        @Override
        public void finishExecution(String result) {
            long exTime = System.nanoTime() - this.startTime;
            this.duration += exTime;
            RequestOrientedStats.this.addExecutionTime(this.duration);
            RequestOrientedStats.this.notifyRequestFinished();
            if (this.currentStep != null) {
                this.currentStep.setDuration(exTime);
                if (result != null) {
                    this.currentStep.appendToCall(" = " + result);
                }
            }
            if (this.currentlyTracedCall != null) {
                this.currentlyTracedCall.endStep();
            }
        }

        @Override
        public void notifyExecutionError() {
            RequestOrientedStats.this.notifyError();
        }

        @Override
        public void startExecution(boolean traceCall, String callDescription) {
            RequestOrientedStats.this.addRequest();
            this.startTime = System.nanoTime();
            if (traceCall) {
                TracedCall tracedCall = RunningTraceContainer.getCurrentlyTracedCall();
                CurrentlyTracedCall currentlyTracedCall = this.currentlyTracedCall = tracedCall.callTraced() ? (CurrentlyTracedCall)tracedCall : null;
                if (this.currentlyTracedCall != null) {
                    this.currentStep = this.currentlyTracedCall.startStep(callDescription == null ? RequestOrientedStats.this.getName() : callDescription);
                }
            }
        }

        @Override
        public void pauseExecution() {
            if (this.startTime == 0L) {
                return;
            }
            this.duration += System.nanoTime() - this.startTime;
            this.startTime = 0L;
        }

        @Override
        public void resumeExecution() {
            if (this.startTime != 0L) {
                this.pauseExecution();
            }
            this.startTime = System.nanoTime();
        }
    }
}

