/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.predefined;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.anotheria.moskito.core.calltrace.CurrentlyTracedCall;
import net.anotheria.moskito.core.calltrace.RunningTraceContainer;
import net.anotheria.moskito.core.calltrace.TraceStep;
import net.anotheria.moskito.core.calltrace.TracedCall;
import net.anotheria.moskito.core.dynamic.IOnDemandCallHandler;
import net.anotheria.moskito.core.predefined.ServiceStats;
import net.anotheria.moskito.core.producers.IStats;
import net.anotheria.moskito.core.producers.IStatsProducer;
import net.anotheria.moskito.core.tracer.TracerRepository;

public class ServiceStatsCallHandler
implements IOnDemandCallHandler {
    @Override
    public Object invoke(Object target, Object[] args, Method method, Class<?> targetClass, Class<?>[] declaredExceptions, IStats aDefaultStats, IStats aMethodStats, IStatsProducer producer) throws Throwable {
        ServiceStats defaultStats = (ServiceStats)aDefaultStats;
        ServiceStats methodStats = (ServiceStats)aMethodStats;
        defaultStats.addRequest();
        methodStats.addRequest();
        TracedCall aRunningTrace = RunningTraceContainer.getCurrentlyTracedCall();
        TraceStep currentStep = null;
        CurrentlyTracedCall currentTrace = aRunningTrace.callTraced() ? (CurrentlyTracedCall)aRunningTrace : null;
        TracerRepository tracerRepository = TracerRepository.getInstance();
        String producerId = producer.getProducerId();
        boolean tracePassingOfThisProducer = tracerRepository.isTracingEnabledForProducer(producerId);
        StringBuilder call = null;
        if (currentTrace != null || tracePassingOfThisProducer) {
            call = new StringBuilder(producer.getProducerId()).append('.').append(method.getName()).append("(");
            if (args != null && args.length > 0) {
                for (int i = 0; i < args.length; ++i) {
                    call.append(args[i]);
                    if (i >= args.length - 1) continue;
                    call.append(", ");
                }
            }
            call.append(")");
        }
        if (currentTrace != null) {
            currentStep = currentTrace.startStep(call.toString(), producer);
        }
        long startTime = System.nanoTime();
        Object ret = null;
        try {
            Object object = ret = method.invoke(target, args);
            return object;
        }
        catch (InvocationTargetException e) {
            defaultStats.notifyError();
            methodStats.notifyError();
            if (currentStep != null) {
                currentStep.setAborted();
            }
            throw e.getCause();
        }
        catch (Throwable t) {
            defaultStats.notifyError();
            methodStats.notifyError();
            if (currentStep != null) {
                currentStep.setAborted();
            }
            if (tracePassingOfThisProducer) {
                call.append("ERR: ").append(t.getMessage());
            }
            throw t;
        }
        finally {
            long exTime = System.nanoTime() - startTime;
            defaultStats.addExecutionTime(exTime);
            methodStats.addExecutionTime(exTime);
            defaultStats.notifyRequestFinished();
            methodStats.notifyRequestFinished();
            if (currentStep != null) {
                currentStep.setDuration(exTime);
                try {
                    currentStep.appendToCall(" = " + ret);
                }
                catch (Throwable t) {
                    currentStep.appendToCall(" = ERR: " + t.getMessage() + " (" + t.getClass() + ")");
                }
            }
            if (currentTrace != null) {
                currentTrace.endStep();
            }
            if (tracePassingOfThisProducer) {
                call.append(" = ").append(ret);
                tracerRepository.addTracedExecution(producerId, call.toString(), Thread.currentThread().getStackTrace(), exTime);
            }
        }
    }
}

