/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.producers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.anotheria.moskito.core.producers.CallExecution;
import net.anotheria.moskito.core.producers.IStats;
import net.anotheria.moskito.core.producers.StatsMXBean;
import net.anotheria.moskito.core.stats.StatValue;
import net.anotheria.moskito.core.stats.TimeUnit;

public abstract class AbstractStats
implements IStats,
StatsMXBean {
    protected static final long MB = 0x100000L;
    private String name;
    private static final List<String> EMPTY_LIST = Collections.unmodifiableList(new ArrayList());
    private LinkedList<StatValue> statValuesList = new LinkedList();

    protected AbstractStats() {
        this("unnamed");
    }

    protected AbstractStats(String aName) {
        this.name = aName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String toStatsString() {
        return this.toStatsString(TimeUnit.MILLISECONDS);
    }

    @Override
    public String toStatsString(String intervalName) {
        return this.toStatsString(intervalName, TimeUnit.MILLISECONDS);
    }

    @Override
    public String toStatsString(TimeUnit timeUnit) {
        return this.toStatsString(null, timeUnit);
    }

    @Override
    public CallExecution createCallExecution() {
        throw new AssertionError((Object)"Not implemented");
    }

    @Override
    public String getValueByNameAsString(String valueName, String intervalName, TimeUnit timeUnit) {
        return null;
    }

    @Override
    public List<String> getAvailableValueNames() {
        return EMPTY_LIST;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public boolean isEmpty(String intervalName) {
        return false;
    }

    @Override
    public void destroy() {
        for (StatValue v : this.statValuesList) {
            v.destroy();
        }
    }

    protected void addStatValues(StatValue ... values) {
        if (values == null) {
            return;
        }
        for (StatValue v : values) {
            this.statValuesList.add(v);
        }
    }
}

